//---------------------------------------------------------------------------
#ifndef atominterH
#define atominterH

#ifndef __BORLANDC__
#include <astring.h>
#else
#include <vcl.h>
#endif

#include <ptree.h>
#include <atomlist.h>
#include <astack.h>
//---------------------------------------------------------------------------
const int
   ttUnknown        = 0,
   ttInteger        = 1,
   ttBinInteger     = 2,
   ttOctInteger     = 3,
   ttHexInteger     = 4,
   ttDouble         = 5,
   ttExponent       = 6,
   ttComplex        = 7,
   ttMeasure        = 8,

   ttString         = 10,
   ttExpression     = 11,
   ttSymbol         = 12,
   ttOperator       = 13,
   ttSeparator      = 14,
   ttFunction       = 15,
   ttVariable       = 16,
   ttConstant       = 17,

   ttLParenth       = 20,
   ttRParenth       = 21,

   ttLBracket       = 30,
   ttRBracket       = 31,

   ttLCurly         = 40,
   ttRCurly         = 41,

   ttLVert          = 50,
   ttRVert          = 51,

   ttBaseSign       = 97,
   ttSpace          = 98,
   ttOther          = 99;
//---------------------------------------------------------------------------
class atominter
{
   private:
   FILE* flog;
   atomlist* _const;
   atomlist* _var;
   ptree* _exptree;
   AnsiString _expstr;
   atomstack* _stack;
   atom _result;
   bool _casesens;
   int _errorCode;
   int _errorPos;
   int _startms, _stopms;
   AnsiString _errorExp;
   AnsiString _errorStr;

   bool makeTokens( AnsiString Text );
   bool beforeParse( pnode* parent );
   void removeBlanks( pnode* parent );
   bool parseFunctions( pnode* parent );
   bool parseConstants( pnode* parent );
   bool parseVariables( pnode* parent );
   bool parseComplex( pnode* parent );
   bool parseMissedOperators( pnode* parent );
   bool parseOperators( pnode* parent );
   bool evalNode( pnode* parent );
   void Add2Log( AnsiString Text, bool Clear = false );
   void clearTreeData( pnode* parent );

   bool isfunc( const char* text );
   bool isconst( const char* text );
   bool isvar( const char* text );

   public:
   atominter( void );
   ~atominter();

   bool fromString( AnsiString Text );
   AnsiString typeToString( int type );
   bool calcExp( void );
   atom Result( void );

   void assignStack( atomstack* AStack );
   void assignConstants( atomlist* AConst );
   void assignVariables( atomlist* AVar );
   void setCaseSensitive( bool Enable );

   ptree* getExpTree( void ) { return _exptree; }
   atomstack* getStack( void ) { return _stack; }
   atomlist* getConst( void ) { return _const; }
   atomlist* getVar( void ) { return _var; }
   bool caseSens( void ) { return _casesens; }
   int errorCode( void ) { return _errorCode; }
   int errorPos( void ) { return _errorPos; }
   AnsiString errorExp( void ) { return _errorExp; }
   AnsiString errorStr( void ) { return _errorStr; }
   int exectimems( void ) { return _stopms - _startms; }
};
//---------------------------------------------------------------------------
#endif
