//---------------------------------------------------------------------------

#ifndef uMatrixH
#define uMatrixH

#include <acomplex.h>
#include <avector.h>

//---------------------------------------------------------------------------
class CMatrix
{
   private:
   CComplex* Cells;
   int Cols, Rows;

   public:
   CMatrix( void );
   CMatrix( int ARows, int ACols, long double* Values = NULL );
   CMatrix( int ARows, int ACols, CComplex* Values );
   CMatrix( const CVector& v );
   CMatrix( const CVector* v );
   CMatrix( CMatrix* M );

   int ColCount( void ) const;
   int RowCount( void ) const;
   void AddRow( void );
   void InsertRow( int Index );
   void DeleteRow( int Index );
   void AddCol( void );
   void InsertCol( int Index );
   void DeleteCol( int Index );
   void SetSize( int ARow, int ACol );
   bool IsEmpty( void ) const;

   CComplex GetCell( int ARow, int ACol ) const; // [ Y ][ X ]
   CComplex GetCell( int ANumber ) const; // [ Y ][ X ]
   bool SetCell( int ARow, int ACol, CComplex v ); // [ Y ][ X ]
   bool SetCell( int ANumber, CComplex v ); // [ Y ][ X ]
   AnsiString ToString( void );
   CComplex Det( void ) const;
   CComplex Minor( int Row, int Col ) const;
   void Transpose( void );
   void Inverse( void );
   CMatrix GetRange( int Left, int Top, int Right, int Bottom );
   
   int GetSize( void );
   int Save( FILE* f );
   int Load( FILE* f );

   const CMatrix& operator=( const CMatrix& val );

   friend CMatrix operator+( const CMatrix& a, const CMatrix& b );
   friend CMatrix operator-( const CMatrix& a, const CMatrix& b );

   friend CMatrix operator*( const CMatrix& a, const CMatrix& b );
   friend CMatrix operator*( const CMatrix& a, const CComplex& b );
   friend CMatrix operator*( const CComplex& a, const CMatrix& b );
   friend CMatrix operator*( const CVector& a, const CMatrix& b );
   friend CMatrix operator*( const CMatrix& a, const CVector& b );

   friend CMatrix operator/( const CMatrix& a, const CComplex& b );
   friend CMatrix operator^( const CMatrix& a, const int& b );
   friend bool operator==( const CMatrix& a, const CMatrix& b );
   friend bool operator!=( const CMatrix& a, const CMatrix& b );
   friend CMatrix Transpose( const CMatrix& a );
   friend CMatrix Inverse( const CMatrix& a );
   friend CMatrix SingleMatrix( const CMatrix& a );
   friend CMatrix round( const CMatrix& a, int ARound );
};
//---------------------------------------------------------------------------
AnsiString MatrixToStr( CMatrix m );
AnsiString MatrixToStrF( CMatrix m, int prec = -1 );
CMatrix StrToMatrix( AnsiString Text );
//---------------------------------------------------------------------------
#endif
