//---------------------------------------------------------------------------
#include <stdio.h>
#include <math.h>

#ifdef __WIN32__
#include <windows.h>
#endif

#include <atomutil.h>
//#include "uComplex.h"
//#include "uMathCnv.h"
#include "ameasure.h"

typedef struct
{
   int unit;
   int ikind[ UnitKindCount ];
   char text[ 10 ];
   char desc[ 30 ];
   int simple;
} TMeasureUnits;

typedef struct
{
   int from;
   int fcount;
   int to;
   int tcount;
   double coef;
} TMeasureUnitsCnv;

typedef struct
{
   int category;
   char desc[ 30 ];
} TMeasureCategory;

typedef struct
{
   int category;
   char sdesc[ 10 ];
   char ldesc[ 30 ];
} TMeasureInCategory;

typedef struct
{
   int category;
   char desc[ 30 ];
} TConvCategory;

typedef struct
{
   int category;
   char sdesc[ 10 ];
   char ldesc[ 30 ];
} TConvUnit;

typedef struct
{
   double coef;
   int fcount;
   int tcount;
} ucnvstr;

const int SIUnitCount = UnitKindCount;

int SIUnits[ SIUnitCount ] = { muM, muKg, muSec, muAmper,
                               muKelvin, muMole, muCandela,
                               muSteradian
                             };

TMeasureUnits Units[] = {
                     { muAng,           {  1,  0,  0,  0,  0,  0,  0,  0 }, "ang", "Angstrem", 1 },
                     { muNm,            {  1,  0,  0,  0,  0,  0,  0,  0 }, "nm", "Nanometer", 1 },
                     { muMm,            {  1,  0,  0,  0,  0,  0,  0,  0 }, "mm", "Millimeter", 1 },
                     { muCm,            {  1,  0,  0,  0,  0,  0,  0,  0 }, "cm", "Centimeter", 1 },
                     { muInch,          {  1,  0,  0,  0,  0,  0,  0,  0 }, "in", "Inch", 1 },
                     { muDm,            {  1,  0,  0,  0,  0,  0,  0,  0 }, "dm", "Decimeter", 1 },
                     { muFoot,          {  1,  0,  0,  0,  0,  0,  0,  0 }, "ft", "Foot", 1 },
                     { muYard,          {  1,  0,  0,  0,  0,  0,  0,  0 }, "yd", "Yard", 1 },
                     { muM,             {  1,  0,  0,  0,  0,  0,  0,  0 }, "m", "Meter", 1 },
                     { muFath,          {  1,  0,  0,  0,  0,  0,  0,  0 }, "fth", "Fathom", 1 },
                     { muRod,           {  1,  0,  0,  0,  0,  0,  0,  0 }, "rd", "Rod", 1 },
                     { muChain,         {  1,  0,  0,  0,  0,  0,  0,  0 }, "ch", "Chain", 1 },
                     { muFurlong,       {  1,  0,  0,  0,  0,  0,  0,  0 }, "fur", "Furlong", 1 },
                     { muKm,            {  1,  0,  0,  0,  0,  0,  0,  0 }, "km", "Kilometer", 1 },
                     { muMi,            {  1,  0,  0,  0,  0,  0,  0,  0 }, "mi", "Land mile", 1 },
                     { muNMi,           {  1,  0,  0,  0,  0,  0,  0,  0 }, "nmi", "Nautical mile", 1 },
                     { muNMiUK,         {  1,  0,  0,  0,  0,  0,  0,  0 }, "nmiUK", "Nautical mile (UK)", 1 },
                     { muAstroUnit,     {  1,  0,  0,  0,  0,  0,  0,  0 }, "au", "Astronomical unit", 1 },
                     { muLightYear,     {  1,  0,  0,  0,  0,  0,  0,  0 }, "lyr", "Light Year", 1 },
                     { muParsec,        {  1,  0,  0,  0,  0,  0,  0,  0 }, "pc", "Parsec", 1 },

                     { muGrain,         {  0,  1,  0,  0,  0,  0,  0,  0 }, "gr", "Grain", 1 },
                     { muCarat,         {  0,  1,  0,  0,  0,  0,  0,  0 }, "ct", "Carat", 1 },
                     { muG,             {  0,  1,  0,  0,  0,  0,  0,  0 }, "g", "Gram", 1 },
                     { muDram,          {  0,  1,  0,  0,  0,  0,  0,  0 }, "dr", "Dram", 1 },
                     { muDwt,           {  0,  1,  0,  0,  0,  0,  0,  0 }, "dwt", "Penny Weight", 1 },
                     { muOz,            {  0,  1,  0,  0,  0,  0,  0,  0 }, "oz", "Ounce", 1 },
                     { muOzTroy,        {  0,  1,  0,  0,  0,  0,  0,  0 }, "ozt", "Troy Ounce", 1 },
                     { muLbt,           {  0,  1,  0,  0,  0,  0,  0,  0 }, "lbt", "Troy Pound", 1 },
                     { muLb,            {  0,  1,  0,  0,  0,  0,  0,  0 }, "lb", "Pound", 1 },
                     { muKg,            {  0,  1,  0,  0,  0,  0,  0,  0 }, "kg", "Kilogram", 1 },
                     { muStone,         {  0,  1,  0,  0,  0,  0,  0,  0 }, "st", "Stone", 1 },
                     { muSlug,          {  0,  1,  0,  0,  0,  0,  0,  0 }, "slug", "Slug", 1 },
                     { muCwt,           {  0,  1,  0,  0,  0,  0,  0,  0 }, "cwt", "Hundredweight (US)", 1 },
                     { muCwtUK,         {  0,  1,  0,  0,  0,  0,  0,  0 }, "cwtUK", "Hundredweight (UK)", 1 },
                     { muTon,           {  0,  1,  0,  0,  0,  0,  0,  0 }, "t", "Ton", 1 },
                     { muTonUS,         {  0,  1,  0,  0,  0,  0,  0,  0 }, "tonUS", "Ton US", 1 },
                     { muTonUK,         {  0,  1,  0,  0,  0,  0,  0,  0 }, "tonUK", "Ton UK", 1 },

                     { muSec,           {  0,  0,  1,  0,  0,  0,  0,  0 }, "s", "Second", 1 },
                     { muMin,           {  0,  0,  1,  0,  0,  0,  0,  0 }, "min", "Minute", 1 },
                     { muHour,          {  0,  0,  1,  0,  0,  0,  0,  0 }, "h", "Hour", 1 },
                     { muDay,           {  0,  0,  1,  0,  0,  0,  0,  0 }, "d", "Day", 1 },
                     { muWeek,          {  0,  0,  1,  0,  0,  0,  0,  0 }, "week", "Week", 1 },
                     { muHz,            {  0,  0, -1,  0,  0,  0,  0,  0 }, "Hz", "Hertz", 1 },

                     { muHa,            {  2,  0,  0,  0,  0,  0,  0,  0 }, "ha", "Hectar", 1 },
                     { muAre,           {  2,  0,  0,  0,  0,  0,  0,  0 }, "a", "Are", 1 },
                     { muAcre,          {  2,  0,  0,  0,  0,  0,  0,  0 }, "ac", "Acre", 1 },

                     { muL,             {  3,  0,  0,  0,  0,  0,  0,  0 }, "l", "Litr", 1 },
                     { muOunceFl,       {  3,  0,  0,  0,  0,  0,  0,  0 }, "ozfl", "Fluid Ounce UK", 1 },
                     { muOunceFlUK,     {  3,  0,  0,  0,  0,  0,  0,  0 }, "ozflUK", "Fluid Ounce UK", 1 },
                     { muGal,           {  3,  0,  0,  0,  0,  0,  0,  0 }, "gal", "Gallon", 1 },
                     { muGalD,          {  3,  0,  0,  0,  0,  0,  0,  0 }, "galD", "Gallon Dry", 1 },
                     { muGalUK,         {  3,  0,  0,  0,  0,  0,  0,  0 }, "galUK", "Gallon UK", 1 },
                     { muQuart,         {  3,  0,  0,  0,  0,  0,  0,  0 }, "qt", "Quart", 1 },
                     { muQuartD,        {  3,  0,  0,  0,  0,  0,  0,  0 }, "qtD", "Quart Dry", 1 },
                     { muQuartUK,       {  3,  0,  0,  0,  0,  0,  0,  0 }, "qtUK", "Quart UK", 1 },
                     { muPint,          {  3,  0,  0,  0,  0,  0,  0,  0 }, "pt", "Pint", 1 },
                     { muPintD,         {  3,  0,  0,  0,  0,  0,  0,  0 }, "ptD", "Pint Dry", 1 },
                     { muPintUK,        {  3,  0,  0,  0,  0,  0,  0,  0 }, "ptUK", "Pint UK", 1 },
                     { muBushel,        {  3,  0,  0,  0,  0,  0,  0,  0 }, "bu", "Bushel", 1 },
                     { muBushelUK,      {  3,  0,  0,  0,  0,  0,  0,  0 }, "buUK", "Bushel UK", 1 },
                     { muBarrel,        {  3,  0,  0,  0,  0,  0,  0,  0 }, "bo", "Barrel Oil", 1 },
                     { muBarrelD,       {  3,  0,  0,  0,  0,  0,  0,  0 }, "bbl", "Barrel Dry", 1 },
                     { muBarrelUK,      {  3,  0,  0,  0,  0,  0,  0,  0 }, "bblUK", "Barrel UK", 1 },
                     { muBoardFoot,     {  3,  0,  0,  0,  0,  0,  0,  0 }, "fbm", "Board foot", 1 },
                     { muPeck,          {  3,  0,  0,  0,  0,  0,  0,  0 }, "pk", "Peck US", 1 },
                     { muPeckUK,        {  3,  0,  0,  0,  0,  0,  0,  0 }, "pkUK", "Peck UK", 1 },

                     { muAmper,         {  0,  0,  0,  1,  0,  0,  0,  0 }, "A", "Ampere", 1 },

                     { muKelvin,        {  0,  0,  0,  0,  1,  0,  0,  0 }, "K", "Kelvin", 1 },
                     { muCelsius,       {  0,  0,  0,  0,  1,  0,  0,  0 }, "C", "Celsius", 1 },
                     { muFahrenheit,    {  0,  0,  0,  0,  1,  0,  0,  0 }, "F", "Fahrenheit", 1 },

                     { muMole,          {  0,  0,  0,  0,  0,  1,  0,  0 }, "mol", "Mole", 1 },

                     { muCandela,       {  0,  0,  0,  0,  0,  0,  1,  0 }, "cd", "Candela", 1 },

                     { muSteradian,     {  0,  0,  0,  0,  0,  0,  0,  1 }, "sr", "Steradian", 1 },

                     { muNewton,        {  1,  1, -2,  0,  0,  0,  0,  0 }, "N", "Newton", 1 },//0 },
                     { muKNewton,       {  1,  1, -2,  0,  0,  0,  0,  0 }, "kN", "Newton", 1 },//0 },
                     { muDyn,           {  1,  1, -2,  0,  0,  0,  0,  0 }, "dyn", "Dyne", 1 },//0 },
                     { muLbf,           {  1,  1, -2,  0,  0,  0,  0,  0 }, "lbf", "Pound force", 1 },//0 },
                     { muPdl,           {  1,  1, -2,  0,  0,  0,  0,  0 }, "pdl", "Poundal", 1 },//0 },

                     { muJoule,         {  2,  1, -2,  0,  0,  0,  0,  0 }, "J", "Joule", 1 }, //0 },
                     { muKJoule,        {  2,  1, -2,  0,  0,  0,  0,  0 }, "kJ", "Kilojoule", 1 }, //0 },
                     { muCal,           {  2,  1, -2,  0,  0,  0,  0,  0 }, "cal", "Calorie", 1 },
                     { muKCal,          {  2,  1, -2,  0,  0,  0,  0,  0 }, "kcal", "Kilocalorie", 1 },
                     { muEV,            {  2,  1, -2,  0,  0,  0,  0,  0 }, "eV", "Electron Volt", 1 },
                     { muMEV,           {  2,  1, -2,  0,  0,  0,  0,  0 }, "MeV", "MegaElectron Volt", 1 },
                     { muGEV,           {  2,  1, -2,  0,  0,  0,  0,  0 }, "GeV", "GigaElectron Volt", 1 },
                     { muBTU,           {  2,  1, -2,  0,  0,  0,  0,  0 }, "Btu", "British Thermal Unit", 1 },
                     { muErg,           {  2,  1, -2,  0,  0,  0,  0,  0 }, "erg", "Erg", 1 },

                     { muWatt,          {  2,  1, -3,  0,  0,  0,  0,  0 }, "W", "Watt", 1 },//0 },
                     { muKWatt,         {  2,  1, -3,  0,  0,  0,  0,  0 }, "kW", "Kilowatt", 1 },
                     { muHorsePower,    {  2,  1, -3,  0,  0,  0,  0,  0 }, "hp", "Horse power", 1 },
                     { muHorsePowerM,   {  2,  1, -3,  0,  0,  0,  0,  0 }, "hpm", "Horse power (Metric)", 1 },

                     { muPascal,        { -1,  1, -2,  0,  0,  0,  0,  0 }, "Pa", "Pascal", 1 },//0 },
                     { muKPascal,       { -1,  1, -2,  0,  0,  0,  0,  0 }, "kPa", "Kilopascal", 1 },//0 },
                     { muAtm,           { -1,  1, -2,  0,  0,  0,  0,  0 }, "atm", "Atmosphere", 1 },
                     { muPsi,           { -1,  1, -2,  0,  0,  0,  0,  0 }, "psi", "Pounds per sq.in.", 1 },
                     { muPsf,           { -1,  1, -2,  0,  0,  0,  0,  0 }, "psf", "Pounds per sq.ft.", 1 },
                     { muMmHg,          { -1,  1, -2,  0,  0,  0,  0,  0 }, "mmHg", "Mm of Mercury", 1 },
                     { muInHg,          { -1,  1, -2,  0,  0,  0,  0,  0 }, "inHg", "Inch of Mercury", 1 },
                     { muBar,           { -1,  1, -2,  0,  0,  0,  0,  0 }, "bar", "Bar", 1 },
                     { muMBar,          { -1,  1, -2,  0,  0,  0,  0,  0 }, "mbar", "Millibar", 1 },
                     { muTorr,          { -1,  1, -2,  0,  0,  0,  0,  0 }, "torr", "Torr", 1 },

                     { muKnot,          {  1,  0, -1,  0,  0,  0,  0,  0 }, "kt", "Knot", 1 },
                     { muMph,           {  1,  0, -1,  0,  0,  0,  0,  0 }, "mph", "Land mile per hour", 1 },
                     { muSpeedOfLight,  {  1,  0, -1,  0,  0,  0,  0,  0 }, "c", "Speed of Light", 1 },

                     { muGravAcc,       {  1,  0, -2,  0,  0,  0,  0,  0 }, "ga", "Gravity acceleration", 1 },

                     { muStilb,         { -2,  0,  0,  0,  0,  0,  1,  0 }, "sb", "Stilb", 1 },

                     { muPhot,          { -2,  0,  0,  0,  0,  0,  1,  1 }, "ph", "Phot", 1 },
                     { muLux,           { -2,  0,  0,  0,  0,  0,  1,  1 }, "lx", "Lux", 1 },
                     { muFootCandle,    { -2,  0,  0,  0,  0,  0,  1,  1 }, "fc", "Foot-candle", 1 },

                     { muFlam,          {  2,  0,  0,  0,  0,  0,  1,  0 }, "flam", "Foot-lambert", 1 },

                     { muVolt,          {  2,  1, -3, -1,  0,  0,  0,  0 }, "V", "Volt", 1 },

                     { muWeber,         {  2,  1, -2, -1,  0,  0,  0,  0 }, "Wb", "Weber", 1 },

                     { muTesla,         {  0,  1, -2, -1,  0,  0,  0,  0 }, "T", "Tesla", 1 },

                     { muSiemens,       { -2, -1,  3,  2,  0,  0,  0,  0 }, "S", "Siemens", 1 },

                     { muRoentgen,      {  0, -1,  1,  1,  0,  0,  0,  0 }, "R", "Roentgen", 1 },

                     { muPoise,         { -1,  1, -1,  0,  0,  0,  0,  0 }, "P", "Poise", 1 },

                     { muCoulomb,       {  0,  0,  1,  1,  0,  0,  0,  0 }, "C", "Coulomb", 1 },

                     { muFarad,         { -2, -1,  4,  2,  0,  0,  0,  0 }, "F", "Farad", 1 },

                     { muOhm,           { -2, -1,  4,  2,  0,  0,  0,  0 }, "ohm", "Ohm", 1 },

                     { muGray,          {  2,  0, -2,  0,  0,  0,  0,  0 }, "Gy", "Gray", 1 },

                     { muHenry,         {  2,  1, -2, -2,  0,  0,  0,  0 }, "H", "Henry", 1 },

                     { muFaraday,       {  0,  0,  1,  1,  0,  0,  0,  0 }, "Fdy", "Faraday", 1 },

                     { muUnknown,       {  0,  0,  0,  0,  0,  0,  0,  0 }, "?", "?", 1 }
                     };


TMeasureCategory _measureCategories[] =
                     {
                        { ucLength, "Length" },
                        { ucMass, "Mass" },
                        { ucTime, "Time" },
                        { ucArea, "Area" },
                        { ucVolume, "Volume" },
                        { ucSpeed, "Speed" },
                        { ucAcceleration, "Acceleration" },
                        { ucForce, "Force" },
                        { ucEnergy, "Energy" },
                        { ucPower, "Power" },
                        { ucPressure, "Pressure" },
                        { ucTemperature, "Temperature" },
                        { ucElCurr, "Electric current" },
                        { ucAmtOfSubst, "Amout of Substance" },
                        { ucLuminous, "Luminous" },
                        { ucRadiation, "Radiation" },

                        { ucUnknown, "?" }
                     };

TMeasureInCategory _measureInCategory[] =
                     {
                        { ucLength, "m", "Meter" },
                        { ucLength, "mm", "Millimeter" },
                        { ucLength, "cm", "Centimeter" },
                        { ucLength, "in", "Inch" },
                        { ucLength, "dm", "Decimeter" },
                        { ucLength, "ft", "Foot" },
                        { ucLength, "yd", "Yard" },
                        { ucLength, "fth", "Fathom" },
                        { ucLength, "rd", "Rod" },
                        { ucLength, "ch", "Chain" },
                        { ucLength, "fur", "Furlong" },
                        { ucLength, "km", "Kilometer" },
                        { ucLength, "mi", "Land mile" },
                        { ucLength, "nmi", "Nautical mile" },
                        { ucLength, "nmiUK", "Nautical mile (UK)" },
                        { ucLength, "au", "Astronomical unit" },
                        { ucLength, "lyr", "Light Year" },
                        { ucLength, "pc", "Parsec" },

                        { ucTime, "s", "Second" },
                        { ucTime, "min", "Minute" },
                        { ucTime, "h", "Hour" },
                        { ucTime, "d", "Day" },
                        { ucTime, "week", "Week" },

                        { ucSpeed, "m/s", "Meter per second" },
                        { ucSpeed, "km/h", "Kilometer per hour" },
                        { ucSpeed, "mph", "Land mile per hour" },
                        { ucSpeed, "kt", "Knot (Nautical mile/hour)" },
                        { ucSpeed, "c", "Speed of Light" },

                        { ucArea, "m^2", "Square meter" },
                        { ucArea, "in^2", "Square inch" },
                        { ucArea, "ha", "Hectar" },
                        { ucArea, "a", "Are" },
                        { ucArea, "ac", "Acre" },

                        { ucVolume, "l", "Liter" },
                        { ucVolume, "m^3", "Cubic meter" },
                        { ucVolume, "gal", "Gallon" },
                        { ucVolume, "galD", "Gallon Dry" },
                        { ucVolume, "galUK", "Gallon UK" },
                        { ucVolume, "pk", "Peck" },
                        { ucVolume, "pkUK", "Peck UK" },
                        { ucVolume, "ozfl", "Fluid Ounce" },
                        { ucVolume, "ozflUK", "Fluid Ounce UK" },
                        { ucVolume, "qt", "Quart" },
                        { ucVolume, "qtD", "Quart Dry" },
                        { ucVolume, "qtUK", "Quart UK" },
                        { ucVolume, "pt", "Pint" },
                        { ucVolume, "ptD", "Pint Dry" },
                        { ucVolume, "ptUK", "Pint UK" },
                        { ucVolume, "fbm", "Board foot" },
                        { ucVolume, "bu", "Bushel" },
                        { ucVolume, "buUK", "Bushel UK" },
                        { ucVolume, "bo", "Barrel Oil" },
                        { ucVolume, "bbl", "Barrel (Dry)" },
                        { ucVolume, "bblUK", "Barrel UK" },

                        { ucMass, "kg", "Kilogram" },
                        { ucMass, "g", "Gram" },
                        { ucMass, "t", "Ton" },
                        { ucMass, "gr", "Grain" },
                        { ucMass, "ct", "Carat" },
                        { ucMass, "dr", "Dram" },
                        { ucMass, "dwt", "Penny Weight" },
                        { ucMass, "oz", "Ounce" },
                        { ucMass, "ozt", "Troy Ounce" },
                        { ucMass, "lbt", "Troy Pound" },
                        { ucMass, "lb", "Pound" },
                        { ucMass, "st", "Stone" },
                        { ucMass, "slug", "Slug" },
                        { ucMass, "cwt", "Hundredweight (US)" },
                        { ucMass, "cwtUK", "Hundredweight (UK)" },
                        { ucMass, "tonUS", "Ton US" },
                        { ucMass, "tonUK", "Ton UK" },

                        { ucAcceleration, "m/s^2", "m/s^2" },
                        { ucAcceleration, "ga", "Standard freefall" },

                        { ucForce, "N", "Newton" },
                        { ucForce, "kN", "Kilonewton" },
                        { ucForce, "dyn", "Dyne (1E-5*N)" },
                        { ucForce, "lbf", "Pound force" },
                        { ucForce, "pdl", "Poundal" },

                        { ucEnergy, "J", "Joule (N/s)" },
                        { ucEnergy, "kJ", "Kilojoule" },
                        { ucEnergy, "cal", "Calorie(s)" },
                        { ucEnergy, "kcal", "Kilocalorie(s)" },
                        { ucEnergy, "eV", "Electron Volt" },
                        { ucEnergy, "MeV", "MegaElectron Volt" },
                        { ucEnergy, "GeV", "GigaElectron Volt" },
                        { ucEnergy, "erg", "Erg" },
                        { ucEnergy, "Btu", "British Thermal Unit(s)" },
                        { ucEnergy, "W*h", "Watt h." },
                        { ucEnergy, "W*min", "Watt min." },
                        { ucEnergy, "W*s", "Watt sec." },
                        { ucEnergy, "kW*h", "KiloWatt h." },
                        { ucEnergy, "kW*min", "KiloWatt min." },
                        { ucEnergy, "kW*s", "KiloWatt sec." },
                        { ucEnergy, "hp*h", "Horse power h." },
                        { ucEnergy, "hp*min", "Horse power min." },
                        { ucEnergy, "hp*s", "Horse power sec." },

                        { ucPower, "W", "Watt" },
                        { ucPower, "kW", "Kilowatt" },
                        { ucPower, "hp", "Horse power" },
                        { ucPower, "hpm", "Horse power (Metric)" },
                        { ucPower, "J/h", "Joule per hour" },
                        { ucPower, "J/min", "Joule per minute" },
                        { ucPower, "J/s", "Joule per second" },

                        { ucPressure, "bar", "Bar" },
                        { ucPressure, "mbar", "Millibar" },
                        { ucPressure, "Pa", "Pascal (N/m^2)" },
                        { ucPressure, "kPa", "Kilopascal" },
                        { ucPressure, "atm", "Atmosphere" },
                        { ucPressure, "torr", "Torr" },
                        { ucPressure, "psi", "PSI (Pounds per sq.inch)" },
                        { ucPressure, "psf", "Pounds per sq.foot" },
                        { ucPressure, "mmHg", "Millimeters of Mercury" },
                        { ucPressure, "inHg", "Inches of Mercury" },

                        { ucTemperature, "K", "Kelvin" },
                        { ucTemperature, "C", "Celsius" },
                        { ucTemperature, "F", "Fahrenheit" },

                        { ucElCurr, "A", "Ampere" },
                        { ucElCurr, "V", "Volt" },
                        { ucElCurr, "C", "Coulomb" },
                        { ucElCurr, "ohm", "Ohm" },
                        { ucElCurr, "F", "Farad" },
                        { ucElCurr, "Fdy", "Faraday" },
                        { ucElCurr, "H", "Henry" },
                        { ucElCurr, "S", "Siemens" },
                        { ucElCurr, "T", "Tesla" },
                        { ucElCurr, "Wb", "Weber" },

                        { ucAmtOfSubst, "mol", "Mole" },

                        { ucLuminous, "cd", "Candela" },
                        { ucLuminous, "lx", "Lux" },
                        { ucLuminous, "ph", "Phot" },
                        { ucLuminous, "fc", "Foot-candle" },
                        { ucLuminous, "flam", "Foot-lambert" },

                        { ucRadiation, "R", "Roentgen" },

                        { ucUnknown, "?", "?" }
                     };
/*
TMeasureUnitsCnv OldUnitsCnv[] = {
                           { muMm, 1, muCm, 1, 0.1 },
                           { muMm, 1, muInch, 1, 1.0 / 25.4 },
                           { muMm, 1, muFeet, 1, 1.0 / 304.8 },
                           { muMm, 1, muYard, 1, 1.0 / 914.4 },
                           { muMm, 1, muM, 1, 1.0 / 1000.0 },
                           { muMm, 1, muKm, 1, 1.0 / ( 1000.0 * 1000.0 ) },
                           { muMm, 1, muMi, 1, 1.0 / ( 1000.0 * 1609.344 ) },
                           { muMm, 1, muNMi, 1, 1.0 / ( 1000.0 * 1852.0 ) },

                           { muCm, 1, muMm, 1, 10.0 },
                           { muCm, 1, muInch, 1, 10.0 / 25.4 },
                           { muCm, 1, muFeet, 1, 10.0 / 304.8 },
                           { muCm, 1, muYard, 1, 10.0 / 914.4 },
                           { muCm, 1, muM, 1, 10.0 / 1000.0 },
                           { muCm, 1, muKm, 1, 10.0 / ( 1000.0 * 1000.0 ) },
                           { muCm, 1, muMi, 1, 10.0 / ( 1000.0 * 1609.344 ) },
                           { muCm, 1, muNMi, 1, 10.0 / ( 1000.0 * 1852.0 ) },

                           { muInch, 1, muMm, 1, 25.4 },
                           { muInch, 1, muCm, 1, 2.54 },
                           { muInch, 1, muFeet, 1, 25.4 / 304.8 },
                           { muInch, 1, muYard, 1, 25.4 / 914.4 },
                           { muInch, 1, muM, 1, 25.4 / 1000.0 },
                           { muInch, 1, muKm, 1, 25.4 / ( 1000.0 * 1000.0 ) },
                           { muInch, 1, muMi, 1, 25.4 / ( 1000.0 * 1609.344 ) },
                           { muInch, 1, muNMi, 1, 25.4 / ( 1000.0 * 1852.0 ) },

                           { muFeet, 1, muMm, 1, 304.0 },
                           { muFeet, 1, muCm, 1, 30.4 },
                           { muFeet, 1, muInch, 1, 304.8 / 25.4 },
                           { muFeet, 1, muYard, 1, 304.8 / 914.4 },
                           { muFeet, 1, muM, 1, 0.3048 },
                           { muFeet, 1, muKm, 1, 304.8 / ( 1000.0 * 1000.0 ) },
                           { muFeet, 1, muMi, 1, 304.8 / ( 1000.0 * 1609.344 ) },
                           { muFeet, 1, muNMi, 1, 304.8 / ( 1000.0 * 1852.0 ) },

                           { muYard, 1, muMm, 1, 914.4 },
                           { muYard, 1, muCm, 1, 91.44 },
                           { muYard, 1, muInch, 1, 914.4 / 25.4 },
                           { muYard, 1, muFeet, 1, 914.4 / 304.8 },
                           { muYard, 1, muM, 1, 0.9144 },
                           { muYard, 1, muKm, 1, 914.4 / ( 1000.0 * 1000.0 ) },
                           { muYard, 1, muMi, 1, 914.4 / ( 1000.0 * 1609.344 ) },
                           { muYard, 1, muNMi, 1, 914.4 / ( 1000.0 * 1852.0 ) },

                           { muM, 1, muMm, 1, 1000.0 },
                           { muM, 1, muCm, 1, 100.0 },
                           { muM, 1, muInch, 1, 1000.0 / 25.4 },
                           { muM, 1, muFeet, 1, 1000.0 / 304.8 },
                           { muM, 1, muYard, 1, 1000.0 / 914.4 },
                           { muM, 1, muKm, 1, 0.001 },
                           { muM, 1, muMi, 1, 1000.0 / ( 1000.0 * 1609.344 ) },
                           { muM, 1, muNMi, 1, 1000.0 / ( 1000.0 * 1852.0 ) },
                           { muM, 2, muHa, 1, 1.0 / 10000.0 },
                           { muM, 2, muAcr, 1.0 / 4046.856422 },
                           { muM, 3, muL, 1, 1000.0 },

                           { muKm, 1, muMm, 1, 1000.0 * 1000.0 },
                           { muKm, 1, muCm, 1, 1000.0 * 100.0 },
                           { muKm, 1, muInch, 1, ( 1000.0 * 1000.0 ) / 25.4 },
                           { muKm, 1, muFeet, 1, ( 1000.0 * 1000.0 ) / 304.8 },
                           { muKm, 1, muYard, 1, ( 1000.0 * 1000.0 ) / 914.4 },
                           { muKm, 1, muM, 1, 1000.0 },
                           { muKm, 1, muMi, 1, 1000.0 / 1609.344 },
                           { muKm, 1, muNMi, 1, 1000.0 / 1852.0 },

                           { muMi, 1, muMm, 1, 1609.344 * 1000.0 },
                           { muMi, 1, muCm, 1, 1609.344 * 100.0 },
                           { muMi, 1, muInch, 1, ( 1609.344 * 1000.0 ) / 25.4 },
                           { muMi, 1, muFeet, 1, ( 1609.344 * 1000.0 ) / 304.8 },
                           { muMi, 1, muYard, 1, ( 1609.344 * 1000.0 ) / 914.4 },
                           { muMi, 1, muM, 1, 1609.344 },
                           { muMi, 1, muKm, 1, 1609.344 / 1000.0 },
                           { muMi, 1, muNMi, 1, 1609.344 / 1852.0 },

                           { muNMi, 1, muMm, 1, 1852.0 * 1000.0 },
                           { muNMi, 1, muCm, 1, 1852.0 * 100.0 },
                           { muNMi, 1, muInch, 1, ( 1852.0 * 1000.0 ) / 25.4 },
                           { muNMi, 1, muFeet, 1, ( 1852.0 * 1000.0 ) / 304.8 },
                           { muNMi, 1, muYard, 1, ( 1852.0 * 1000.0 ) / 914.4 },
                           { muNMi, 1, muM, 1, 1852.0 },
                           { muNMi, 1, muKm, 1, 1852.0 / 1000.0 },
                           { muNMi, 1, muMi, 1, 1852.0 / 1609.344 },

                           { muG, 1, muLbm, 1, 1.0 / 453.59231 },
                           { muG, 1, muKg, 1, 0.001 },
                           { muG, 1, muTon, 1, 0.000001 },

                           { muLbm, 1, muG, 1, 453.59231 },
                           { muLbm, 1, muKg, 1, 453.59231 / 1000.0 },
                           { muLbm, 1, muTon, 1, 453.59231 / ( 1000.0 * 1000.0 ) },

                           { muTon, 1, muG, 1, 1000.0 * 1000.0 },
                           { muTon, 1, muLbm, 1, ( 1000.0 * 1000.0 ) / 453.59231 },
                           { muTon, 1, muKg, 1, 1000.0 },

                           { muSec, 1, muMin, 1, 1.0 / 60.0 },
                           { muSec, 1, muHour, 1, 1.0 / ( 60.0 * 60.0 ) },

                           { muMin, 1, muSec, 1, 60.0 },
                           { muMin, 1, muHour, 1, 1.0 / 60.0 },

                           { muHour, 1, muSec, 1, 60.0 * 60.0 },
                           { muHour, 1, muMin, 1, 60.0 },

                           { muHa, 1, muM, 2, 10000.0 },

                           { muAcr, 1, muM, 2, 4046.856422 },

                           { muL, 1, muM, 3, 0.001 },

                           { muUnknown, 0, muUnknown, 0, 0.0 }
                           };
TMeasureUnitsCnv UnitsCnv[] = {
                           { muMm, 1, muM, 1, 0.001 },
                           { muCm, 1, muM, 1, 0.01 },
                           { muInch, 1, muM, 1, 25.4 / 1000.0 },
                           { muDm, 1, muM, 1, 0.1 },
                           { muFoot, 1, muM, 1, 0.3048 },
                           { muYard, 1, muM, 1, 0.9144 },
                           { muChain, 1, muM, 1, 20.1168 },
                           { muKm, 1, muM, 1, 1000.0 },
                           { muMi, 1, muM, 1, 1609.344 },
                           { muNMi, 1, muM, 1, 1852.0 },

                           { muG, 1, muKg, 1, 0.001 },
                           { muLb, 1, muKg, 1, 453.59231 / 1000.0 },
                           { muTon, 1, muKg, 1, 1000.0 },

                           { muMin, 1, muSec, 1, 60.0 },
                           { muHour, 1, muSec, 1, 60.0 * 60.0 },
                           { muHz, 1, muSec, -1, 1.0 },

                           { muHa, 1, muM, 2, 10000.0 },

                           { muAcre, 1, muM, 2, 4046.856422 },

                           { muL, 1, muM, 3, 0.001 },
                           { muGal, 1, muM, 3, 0.0037854 },

                           { muHorsePower, 1, muWatt, 1, 746.0 },

                           { muUnknown, 0, muUnknown, 0, 0.0 }
                           };
*/
//---------------------------------------------------------------------------
class TMeasureUnitCnv2
{
   public:
   TMeasureUnitCnv2( void )
   {
      from = CUnit();
      to = CUnit();
      coef = 1.0;
   }
   
   TMeasureUnitCnv2( const CUnit& af, const CUnit& at, double ac )
   {
      from = af;
      to = at;
      coef = ac;
   }
   
   TMeasureUnitCnv2( const TMeasureUnitCnv2& uc )
   {
      from = uc.from;
      to = uc.to;
      coef = uc.coef;
   }

   const TMeasureUnitCnv2& operator=( const TMeasureUnitCnv2& uc )
   {
      from = uc.from;
      to = uc.to;
      coef = uc.coef;
      return *this;
   }

   CUnit from;
   CUnit to;
   double coef;
};

const TMeasureUnitCnv2* UnitsCnv2[] = {
                           new TMeasureUnitCnv2( CUnit( "ang" ), CUnit( "m" ), 1E-10 ),
                           new TMeasureUnitCnv2( CUnit( "nm" ), CUnit( "m" ), 1E-9 ),
                           new TMeasureUnitCnv2( CUnit( "mm" ), CUnit( "m" ), 0.001 ),
                           new TMeasureUnitCnv2( CUnit( "cm" ), CUnit( "m" ), 0.01 ),
                           new TMeasureUnitCnv2( CUnit( "in" ), CUnit( "m" ), 25.4 / 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "dm" ), CUnit( "m" ), 0.1 ),
                           new TMeasureUnitCnv2( CUnit( "ft" ), CUnit( "m" ), 0.3048 ),
                           new TMeasureUnitCnv2( CUnit( "yd" ), CUnit( "m" ), 0.9144 ),
                           new TMeasureUnitCnv2( CUnit( "fth" ), CUnit( "m" ), 1.8288 ),
                           new TMeasureUnitCnv2( CUnit( "rd" ), CUnit( "m" ), 5.02921005842 ),
                           new TMeasureUnitCnv2( CUnit( "ch" ), CUnit( "m" ), 20.1168 ),
                           new TMeasureUnitCnv2( CUnit( "fur" ), CUnit( "m" ), 201.168 ),
                           new TMeasureUnitCnv2( CUnit( "km" ), CUnit( "m" ), 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "mi" ), CUnit( "m" ), 1609.344 ),
                           new TMeasureUnitCnv2( CUnit( "nmi" ), CUnit( "m" ), 1852.0 ),
                           new TMeasureUnitCnv2( CUnit( "nmiUK" ), CUnit( "m" ), 1853.994768 ),
                           new TMeasureUnitCnv2( CUnit( "au" ), CUnit( "m" ), 149598550000.0 ),
                           new TMeasureUnitCnv2( CUnit( "lyr" ), CUnit( "m" ), 9460536207068016.0 ),
                           new TMeasureUnitCnv2( CUnit( "pc" ), CUnit( "m" ), 30856770000000000.0 ),

                           new TMeasureUnitCnv2( CUnit( "ct" ), CUnit( "kg" ), 0.0002 ),
                           new TMeasureUnitCnv2( CUnit( "gr" ), CUnit( "kg" ), 0.0000648 ),
                           new TMeasureUnitCnv2( CUnit( "g" ), CUnit( "kg" ), 0.001 ),
                           new TMeasureUnitCnv2( CUnit( "dwt" ), CUnit( "kg" ), 0.0015552 ),
                           new TMeasureUnitCnv2( CUnit( "dr" ), CUnit( "kg" ), 0.0017718 ),
                           new TMeasureUnitCnv2( CUnit( "oz" ), CUnit( "kg" ), 0.0283495 ),
                           new TMeasureUnitCnv2( CUnit( "ozt" ), CUnit( "kg" ), 0.0311035 ),
                           new TMeasureUnitCnv2( CUnit( "lbt" ), CUnit( "kg" ), 0.3732417 ),
                           new TMeasureUnitCnv2( CUnit( "lb" ), CUnit( "kg" ), 0.45359231 ),
                           new TMeasureUnitCnv2( CUnit( "st" ), CUnit( "kg" ), 6.3502932 ),
                           new TMeasureUnitCnv2( CUnit( "slug" ), CUnit( "kg" ), 14.5939035919985 ),
                           new TMeasureUnitCnv2( CUnit( "cwt" ), CUnit( "kg" ), 45.359237 ),
                           new TMeasureUnitCnv2( CUnit( "cwtUK" ), CUnit( "kg" ), 50.8023454 ),
                           new TMeasureUnitCnv2( CUnit( "t" ), CUnit( "kg" ), 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "tonUS" ), CUnit( "kg" ), 907.18474 ),
                           new TMeasureUnitCnv2( CUnit( "tonUK" ), CUnit( "kg" ), 1016.0469088 ),

                           new TMeasureUnitCnv2( CUnit( "min" ), CUnit( "s" ), 60.0 ),
                           new TMeasureUnitCnv2( CUnit( "h" ), CUnit( "s" ), 60.0 * 60.0 ),
                           new TMeasureUnitCnv2( CUnit( "d" ), CUnit( "s" ), 24.0 * 60.0 * 60.0 ),
                           new TMeasureUnitCnv2( CUnit( "Hz" ), CUnit( "1/s" ), 1.0 ),
                           new TMeasureUnitCnv2( CUnit( "week" ), CUnit( "s" ), 7.0 * 24.0 * 60.0 * 60.0 ),

                           new TMeasureUnitCnv2( CUnit( "ha" ), CUnit( "m^2" ), 10000.0 ),
                           new TMeasureUnitCnv2( CUnit( "a" ), CUnit( "m^2" ), 100.0 ),
                           new TMeasureUnitCnv2( CUnit( "ac" ), CUnit( "m^2" ), 4046.856422 ),

                           new TMeasureUnitCnv2( CUnit( "l" ), CUnit( "m^3" ), 0.001 ),
                           new TMeasureUnitCnv2( CUnit( "gal" ), CUnit( "m^3" ), 0.003784984752 ),
                           new TMeasureUnitCnv2( CUnit( "galD" ), CUnit( "m^3" ), 0.0044088 ),
                           new TMeasureUnitCnv2( CUnit( "galUK" ), CUnit( "m^3" ), 0.0045456 ),
                           new TMeasureUnitCnv2( CUnit( "ozfl" ), CUnit( "m^3" ), 0.000029570193 ),
                           new TMeasureUnitCnv2( CUnit( "ozflUK" ), CUnit( "m^3" ), 0.00002841 ),
                           new TMeasureUnitCnv2( CUnit( "pt" ), CUnit( "m^3" ), 0.000473123094 ),
                           new TMeasureUnitCnv2( CUnit( "ptD" ), CUnit( "m^3" ), 0.0005511 ),
                           new TMeasureUnitCnv2( CUnit( "ptUK" ), CUnit( "m^3" ), 0.0005682 ),
                           new TMeasureUnitCnv2( CUnit( "qt" ), CUnit( "m^3" ), 0.000946246188 ),
                           new TMeasureUnitCnv2( CUnit( "qtD" ), CUnit( "m^3" ), 0.0011022 ),
                           new TMeasureUnitCnv2( CUnit( "qtUK" ), CUnit( "m^3" ), 0.0011364 ),
                           new TMeasureUnitCnv2( CUnit( "fbm" ), CUnit( "m^3" ), 0.002359737216 ),
                           new TMeasureUnitCnv2( CUnit( "bu" ), CUnit( "m^3" ), 0.0352704 ),
                           new TMeasureUnitCnv2( CUnit( "buUK" ), CUnit( "m^3" ), 0.0363648 ),
                           new TMeasureUnitCnv2( CUnit( "bo" ), CUnit( "m^3" ), 0.158969359584 ),
                           new TMeasureUnitCnv2( CUnit( "bbl" ), CUnit( "m^3" ), 0.1156271 ),
                           new TMeasureUnitCnv2( CUnit( "bblUK" ), CUnit( "m^3" ), 0.1636592 ),
                           new TMeasureUnitCnv2( CUnit( "pk" ), CUnit( "m^3" ), 0.0088176 ),
                           new TMeasureUnitCnv2( CUnit( "pkUK" ), CUnit( "m^3" ), 0.0090912 ),

                           new TMeasureUnitCnv2( CUnit( "N" ), CUnit( "kg*m/s^2" ), 1.0 ),
                           new TMeasureUnitCnv2( CUnit( "kN" ), CUnit( "kg*m/s^2" ), 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "dyn" ), CUnit( "kg*m/s^2" ), 0.00001 ),
                           new TMeasureUnitCnv2( CUnit( "lbf" ), CUnit( "kg*m/s^2" ), 4.44822161526 ),
                           new TMeasureUnitCnv2( CUnit( "pdl" ), CUnit( "kg*m/s^2" ), 0.138254954376 ),

                           new TMeasureUnitCnv2( CUnit( "J" ), CUnit( "kg*m^2/s^2" ), 1.0 ),
                           new TMeasureUnitCnv2( CUnit( "kJ" ), CUnit( "kg*m^2/s^2" ), 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "cal" ), CUnit( "kg*m^2/s^2" ), 4.19002 ),
                           new TMeasureUnitCnv2( CUnit( "kcal" ), CUnit( "kg*m^2/s^2" ), 4190.02 ),
                           new TMeasureUnitCnv2( CUnit( "eV" ), CUnit( "kg*m^2/s^2" ), 0.000000000000000000160206 ),
                           new TMeasureUnitCnv2( CUnit( "MeV" ), CUnit( "kg*m^2/s^2" ), 0.000000000000160206 ),
                           new TMeasureUnitCnv2( CUnit( "GeV" ), CUnit( "kg*m^2/s^2" ), 0.000000000160206 ),
                           new TMeasureUnitCnv2( CUnit( "Btu" ), CUnit( "kg*m^2/s^2" ), 1055.87 ),
                           new TMeasureUnitCnv2( CUnit( "erg" ), CUnit( "kg*m^2/s^2" ), 1.0E-7 ),

                           new TMeasureUnitCnv2( CUnit( "W" ), CUnit( "kg*m^2/s^3" ), 1.0 ),
                           new TMeasureUnitCnv2( CUnit( "kW" ), CUnit( "kg*m^2/s^3" ), 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "hp" ), CUnit( "kg*m^2/s^3" ), 746.0 ),
                           new TMeasureUnitCnv2( CUnit( "hpm" ), CUnit( "kg*m^2/s^3" ), 735.49875 ),

                           new TMeasureUnitCnv2( CUnit( "kt" ), CUnit( "m/s" ), 0.514444 ),
                           new TMeasureUnitCnv2( CUnit( "mph" ), CUnit( "m/s" ), 0.44704 ),
                           new TMeasureUnitCnv2( CUnit( "c" ), CUnit( "m/s" ), 299792458.0 ),

                           new TMeasureUnitCnv2( CUnit( "Pa" ), CUnit( "kg/m*s^2" ), 1.0 ),
                           new TMeasureUnitCnv2( CUnit( "kPa" ), CUnit( "kg/m*s^2" ), 1000.0 ),
                           new TMeasureUnitCnv2( CUnit( "bar" ), CUnit( "kg/m*s^2" ), 100000.0 ),
                           new TMeasureUnitCnv2( CUnit( "mbar" ), CUnit( "kg/m*s^2" ), 100.0 ),
                           new TMeasureUnitCnv2( CUnit( "atm" ), CUnit( "kg/m*s^2" ), 101325.0 ),
                           new TMeasureUnitCnv2( CUnit( "psi" ), CUnit( "kg/m*s^2" ), 6894.75729316836134 ),
                           new TMeasureUnitCnv2( CUnit( "psf" ), CUnit( "kg/m*s^2" ), 47.8802589803358426 ),
                           new TMeasureUnitCnv2( CUnit( "mmHg" ), CUnit( "kg/m*s^2" ), 133.322368421052632 ),
                           new TMeasureUnitCnv2( CUnit( "inHg" ), CUnit( "kg/m*s^2" ), 3386.3881579 ),
                           new TMeasureUnitCnv2( CUnit( "torr" ), CUnit( "kg/m*s^2" ), 133.322368421052632 ),

                           new TMeasureUnitCnv2( CUnit( "ga" ), CUnit( "m/s^2" ), 9.80665 ),

                           new TMeasureUnitCnv2( CUnit( "sb" ), CUnit( "cd/m^2" ), 10000.0 ),

                           new TMeasureUnitCnv2( CUnit( "ph" ), CUnit( "cd*sr/m^2" ), 10000.0 ),
                           new TMeasureUnitCnv2( CUnit( "lx" ), CUnit( "cd*sr/m^2" ), 1.0 ),
                           new TMeasureUnitCnv2( CUnit( "fc" ), CUnit( "cd*sr/m^2" ), 10.7639104167 ),

                           new TMeasureUnitCnv2( CUnit( "flam" ), CUnit( "cd/m^2" ), 3.42625909964 ),

                           new TMeasureUnitCnv2( CUnit( "V" ), CUnit( "kg*m^2/A*s^3" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "Wb" ), CUnit( "kg*m^2/A*s^2" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "T" ), CUnit( "kg/A*s^2" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "S" ), CUnit( "A^2*s^3/kg*m^2" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "R" ), CUnit( "A*s/kg" ), 0.000258 ),

                           new TMeasureUnitCnv2( CUnit( "P" ), CUnit( "kg/m*s" ), 0.1 ),

                           new TMeasureUnitCnv2( CUnit( "C" ), CUnit( "A*s" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "F" ), CUnit( "A^2*s^4/kg*m^2" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "ohm" ), CUnit( "kg*m^2/A^2*s^3" ), 1.0 ),

                           new TMeasureUnitCnv2( CUnit( "Gy" ), CUnit( "m^2/s^2" ), 1.0 ),
                            
                           new TMeasureUnitCnv2( CUnit( "H" ), CUnit( "kg*m^2/A^2*s^2" ), 1.0 ),
                           
                           new TMeasureUnitCnv2( CUnit( "Fdy" ), CUnit( "A*s" ), 96487.0 ),
                           
                           new TMeasureUnitCnv2( CUnit( "?" ), CUnit( "?" ), 0.0 )
                           
                           };
//---------------------------------------------------------------------------
void ShowMessage( char* lpszMsg )
{
   //MessageBox( 0, lpszMsg, "Message", MB_OK );
}
//---------------------------------------------------------------------------
bool EqualSign( int a, int b )
{
   return( ( a > 0 && b > 0 ) || ( a < 0 && b < 0 ) );
}
//---------------------------------------------------------------------------
int GetUnit( AnsiString AUnit )
{
   int j;
   int u = muUnknown;
   bool lExit;

   j = 0;
   lExit = false;
   while( Units[ j ].unit != muUnknown && !lExit )
   {
      if( !strcmp( AUnit.c_str(), Units[ j ].text ) )
      {
         u = Units[ j ].unit;
         //ShowMessage( "Founded: " + AUnit );
         lExit = true;
      }
      else
      {
         j++;
      }
   }
   return u;
}
//---------------------------------------------------------------------------
AnsiString GetUnitString( int AUnit )
{
   int j;
   AnsiString p = "?";
   bool lExit;

   j = 0;
   lExit = false;
   while( Units[ j ].unit != muUnknown && !lExit )
   {
      if( AUnit == Units[ j ].unit )
      {
         p = AnsiString( Units[ j ].text );
         lExit = true;
      }
      else
      {
         j++;
      }
   }
   return p;
}
//---------------------------------------------------------------------------
int* GetUnitKind( int AUnit )
{
   int j;
   //int k = mukUnknown;
   int* ikind = NULL;
   bool lExit = false;

   j = 0;
   while( Units[ j ].unit != muUnknown && !lExit )
   {
      if( Units[ j ].unit == AUnit )
      {
         //k = Units[ j ].kind;
         ikind = Units[ j ].ikind;
         lExit = true;
      }
      else
      {
         j++;
      }
   }

   if( !ikind )
   {
      ShowMessage( "NULL Kind!" );
   }
   return ikind;
}
//---------------------------------------------------------------------------
int GetUnitSI( int AUnit )
{
   int* k = GetUnitKind( AUnit );
   int u, j, index, count;

   index = -1;
   count = 0;
   for( j = 0; j < UnitKindCount && k; j++ )
   {
      if( k[ j ] != 0 )
      {
         index = j;
         count++;
      }
   }
   if( index != -1 && count == 1 )
   {
      u = SIUnits[ index ];
   }
   else
   {
      u = -1;
   }
   return u;
}
//---------------------------------------------------------------------------
bool SimpleUnit( int AUnit )
{
   int j, simple;
   bool lExit;

   j = 0;
   lExit = false;
   //ShowMessage( "Check unit's simple..." );
   while( Units[ j ].unit != muUnknown && !lExit )
   {
      if( AUnit == Units[ j ].unit )
      {
         simple = Units[ j ].simple;
         lExit = true;
      }
      else
      {
         j++;
      }
   }
   return simple ? true : false;
}
//---------------------------------------------------------------------------
CUnit JoinUnits( CUnit l, CUnit r )
{
   CUnit u = CUnit();
   int j;

   //ShowMessage( "Before Join: l=<" + l.ToString() + ">; r=<" + r.ToString() + ">" );
   for( j = 0; j < l.count; j++ )
   {
      u.IncUnit( l.units[ j ].unit, l.units[ j ].count );
   }
   for( j = 0; j < r.count; j++ )
   {
      u.IncUnit( r.units[ j ].unit, r.units[ j ].count );
   }
   //ShowMessage( "After Join: u=<" + u.ToString() + ">" );
   return u;
}
//---------------------------------------------------------------------------
CUnit Simplify( CUnit left, CUnit right )
{
   CUnit u;
   int i, j;
   int unit;
   bool lExit;
   bool lFound;

   u = JoinUnits( left, right );

   return u;
}
//---------------------------------------------------------------------------
bool CompareKind( CUnit left, CUnit right )
{
   bool lRes = true;
   int j;

   for( j = 0; j < UnitKindCount && lRes; j++ )
   {
      if( left.Kind[ j ] == right.Kind[ j ] )
      {
      }
      else
      {
         lRes = false;
      }
   }
   return lRes;
}
//---------------------------------------------------------------------------
CUnit GetDecomposedUnit( int unit )
{
   CUnit u;

   switch( unit )
   {  /*
      case muNewton:
      u = CUnit( "kg*m/s^2" );
      break;
      case muJoule:
      u = CUnit( "kg*m^2/s^2" );
      break;
      case muWatt:
      u = CUnit( "kg*m^2/s^3" );
      break;
      case muPascal:
      u = CUnit( "kg/m*s^2" );
      break;*/
      default:
      u = CUnit();
      break;
   }
   return u;
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
CUnit::CUnit( void )
{
   int j;

   units = NULL;
   count = 0;

   for( j = 0; j < UnitKindCount; j++ )
   {
      Kind[ j ] = 0;
   }
}
//---------------------------------------------------------------------------
CUnit::CUnit( AnsiString AText )
{
   int j;

   units = NULL;
   count = 0;

   for( j = 0; j < UnitKindCount; j++ )
   {
      Kind[ j ] = 0;
   }

   if( AText.Length() > 0 )
   {
      FromString( AText );
   }
}
//---------------------------------------------------------------------------
CUnit::CUnit( const CUnit& AUnit )
{
   int j;

   if( AUnit.count )
   {
      count = AUnit.count;
      units = new TMeasureUnitEx[ count ];
      memcpy( units, AUnit.units, count * sizeof( TMeasureUnitEx ) );
      memcpy( Kind, AUnit.Kind, UnitKindCount * sizeof( int ) );
   }
   else
   {
      count = 0;
      units = NULL;
      for( j = 0; j < UnitKindCount; j++ )
      {
         Kind[ j ] = 0;
      }
   }
}
//---------------------------------------------------------------------------
CUnit::CUnit( CUnit* AUnit )
{
   int j;
   bool lEmpty;

   if( !AUnit )
   {
      lEmpty = true;
   }
   else
   {
      if( AUnit->count )
      {
         lEmpty = false;
      }
      else
      {
         lEmpty = true;
      }
   }

   if( !lEmpty )
   {
      count = AUnit->count;
      units = new TMeasureUnitEx[ count ];
      memcpy( units, AUnit->units, count * sizeof( TMeasureUnitEx ) );
      memcpy( Kind, AUnit->Kind, UnitKindCount * sizeof( int ) );
   }
   else
   {
      count = 0;
      units = NULL;
      for( j = 0; j < UnitKindCount; j++ )
      {
         Kind[ j ] = 0;
      }
   }
}
//---------------------------------------------------------------------------
CUnit::~CUnit( void )
{
   Clear();
}
//---------------------------------------------------------------------------
bool CUnit::ZeroKind( void )
{
   int j;
   bool lRes;

   lRes = true;
   for( j = 0; j < UnitKindCount && lRes; j++ )
   {
      if( Kind[ j ] != 0 )
      {
         lRes = false;
      }
   }
   return lRes;
}
//---------------------------------------------------------------------------
void CUnit::Clear( void )
{
   int j;

   if( units && count )
   {
      delete units;
   }
   units = NULL;
   count = 0;

   for( j = 0; j < UnitKindCount; j++ )
   {
      Kind[ j ] = 0;
   }
}
//---------------------------------------------------------------------------
void CUnit::AddUnit( int AUnit, int alo )
{
   TMeasureUnitEx* pom;
   int kind;
   int* ikind;
   int j;

   //ShowMessage( "Dodaje jednostk: " + GetUnitString( AUnit ) );

   pom = new TMeasureUnitEx[ count + 1 ];
   if( units && count )
   {
      for( j = 0; j < count; j++ )
      {
         pom[ j ].unit  = units[ j ].unit;
         pom[ j ].count = units[ j ].count;
      }
      delete units;
   }

   pom[ count ].unit = AUnit;
   pom[ count ].count = alo;

   ikind = GetUnitKind( AUnit );
   for( j = 0; j < UnitKindCount && ikind; j++ )
   {
      Kind[ j ] += ( alo * ikind[ j ] ); //1;
   }

   units = pom;
   count++;

   //ShowMessage( "Teraz count = " + AnsiString( count ) );
}
//---------------------------------------------------------------------------
void CUnit::AddUnit( AnsiString AUnit, int alo )
{
   int u;

   if( AUnit.Length() > 0 )
   {
      u = GetUnit( AUnit );
      if( u != muUnknown )
      {
         AddUnit( u, alo );
      }
   }
}
//---------------------------------------------------------------------------
void CUnit::DeleteUnit( int Index, int alo )
{
   TMeasureUnitEx* pom;
   int i, j, k;
   int* ikind;

   if( Index >= 0 && Index < count && units )
   {
      if( count > 1 )
      {
         pom = new TMeasureUnitEx[ count - 1 ];
         for( j = 0, i = 0; j < count; j++ )
         {
            if( j != Index )
            {
               pom[ i ].unit  = units[ j ].unit;
               pom[ i ].count = units[ j ].count;
               i++;
            }
            else
            {
               ikind = GetUnitKind( units[ j ].unit );
               for( k = 0; k < UnitKindCount && ikind; k++ )
               {
                  Kind[ k ] -= ( alo * ikind[ k ] ); //1;
               }
            }
         }
         delete units;

         units = pom;
         count--;
      }
      else
      {
         delete units;
         units = NULL;
         count = 0;
      }
   }
}
//---------------------------------------------------------------------------
int CUnit::UnitExists( int AUnit )
{
   int iFound = -1;
   int j;

   if( units && count )
   {
      for( j = 0; j < count && iFound == -1; j++ )
      {
         //ShowMessage( "Sprawdzam " + GetUnitString( AUnit ) + "; j = " + AnsiString( j ) );
         if( units[ j ].unit == AUnit )
         {
            iFound = j;
         }
      }
   }
   return iFound;
}
//---------------------------------------------------------------------------
void CUnit::IncUnit( int AUnit, int alo )
{
   int i, k;
   int* ikind;

   if( units && count )
   {
      i = UnitExists( AUnit );
      if( i != -1 )
      {
         //ShowMessage( "Istnieje: i=" + AnsiString( i ) );
         units[ i ].count += alo;
         ikind = GetUnitKind( AUnit );
         for( k = 0; k < UnitKindCount && ikind; k++ )
         {
            Kind[ k ] += ( alo * ikind[ k ] );//1;
         }
         if( units[ i ].count == 0 )
         {
            DeleteUnit( i, 0 );
         }
      }
      else
      {
         //ShowMessage( "Nie istnieje: i=" + AnsiString( i ) );
         AddUnit( AUnit, alo );
      }
   }
   else
   {
      //ShowMessage( "Pusty zbior!" );
      AddUnit( AUnit, alo );
   }
}
//---------------------------------------------------------------------------
void CUnit::IncUnit( AnsiString AUnit, int alo )
{
   int u;

   if( AUnit.Length() > 0 )
   {
      u = GetUnit( AUnit );
      if( u != muUnknown )
      {
         IncUnit( u, alo );
      }
   }
}
//---------------------------------------------------------------------------
void CUnit::DecUnit( int AUnit, int alo )
{
   int i, k;
   int* ikind;

   if( units && count )
   {
      i = UnitExists( AUnit );
      if( i != -1 )
      {
         if( units[ i ].count == alo )
         {
            DeleteUnit( i, alo );
         }
         else
         {
            units[ i ].count -= alo;
            ikind = GetUnitKind( AUnit );
            for( k = 0; k < UnitKindCount && ikind; k++ )
            {
               Kind[ k ] -= ( alo * ikind[ k ] );// 1;
            }
         }
      }
   }
}
//---------------------------------------------------------------------------
void CUnit::DecUnit( AnsiString AUnit, int alo )
{
   int u;

   if( AUnit.Length() > 0 )
   {
      u = GetUnit( AUnit );
      if( u != muUnknown )
      {
         DecUnit( u, alo );
      }
   }
}
//---------------------------------------------------------------------------
bool CUnit::Contains( CUnit AUnit )
{
   bool lAllPassed;
   bool lFound;
   int i, j;

   lAllPassed = true;
   for( j = 0; j < AUnit.count && lAllPassed; j++ )
   {
      for( i = 0, lFound = false; i < count && !lFound; i++ )
      {
         if( AUnit.units[ j ].unit == units[ i ].unit )
         {
            if( units[ i ].count > 0 && AUnit.units[ j ].count > 0 &&
                AUnit.units[ j ].count <= units[ i ].count )
            {
               lFound = true;
            }
            else if( units[ i ].count < 0 && AUnit.units[ j ].count < 0 &&
                     AUnit.units[ j ].count >= units[ i ].count )
            {
               lFound = true;
            }
            else
            {
            }
         }
      }
      if( !lFound )
      {
         lAllPassed = false;
      }
   }
   return lAllPassed;
}
//---------------------------------------------------------------------------
bool CUnit::Contains2( CUnit AUnit )
{
   bool lAllPassed;
   bool lFound;
   int i, j;

   lAllPassed = true;
   for( j = 0; j < AUnit.count && lAllPassed; j++ )
   {
      for( i = 0, lFound = false; i < count && !lFound; i++ )
      {
         if( AUnit.units[ j ].unit == units[ i ].unit )
         {
            lFound = true;
         }
      }
      if( !lFound )
      {
         lAllPassed = false;
      }
   }
   return lAllPassed;
}
//---------------------------------------------------------------------------
bool CUnit::ContainsTemperature( void )
{
   //"K", "Kelvin"
   //"C", "Celsius"
   //"F", "Fahrenheit"
   return Contains( CUnit( "K" ) ) ||
          Contains( CUnit( "C" ) ) ||
          Contains( CUnit( "F" ) );
}
//---------------------------------------------------------------------------
void CUnit::Append( CUnit AUnit )
{
   int j;

   for( j = 0; j < AUnit.count; j++ )
   {
      IncUnit( AUnit.units[ j ].unit, AUnit.units[ j ].count );
   }
}
//---------------------------------------------------------------------------
void CUnit::Remove( CUnit AUnit )
{
   int j;

   if( Contains( AUnit ) )
   {
      for( j = 0; j < AUnit.count; j++ )
      {
         IncUnit( AUnit.units[ j ].unit, -( AUnit.units[ j ].count ) );
      }
   }
}
//---------------------------------------------------------------------------
void CUnit::Remove2( CUnit AUnit )
{
   int j;

   if( Contains2( AUnit ) )
   {
      for( j = 0; j < AUnit.count; j++ )
      {
         IncUnit( AUnit.units[ j ].unit, -( AUnit.units[ j ].count ) );
      }
   }
}
//---------------------------------------------------------------------------
void CUnit::FromString( AnsiString Text )
{
   AnsiString u, s, p, shi, slo, test;
   int pos, pos2, pow;
   int j;

   Clear();

   pos = Text.Pos( "/" );
   if( pos )
   {
      shi = Text.SubString( 1, pos - 1 ) + "*";
      slo = Text.SubString( pos + 1, Text.Length() ) + "*";
   }
   else
   {
      shi = Text + "*";
      slo = "";
   }

   if( shi.Length() > 0 && shi != "1" )
   {
      pos = -1;
      p = shi;
      while( pos )
      {
         pos = p.Pos( "*" );
         if( pos )
         {
            s = p.SubString( 1, pos - 1 );
            p = p.SubString( pos + 1, p.Length() );

            pos2 = s.Pos( "^" );
            if( pos2 )
            {
               u = s.SubString( 1, pos2 - 1 );
               //if( s.SubString( pos2 + 1, s.Length() ).IsInteger() )
               if( isintstr( s.SubString( pos2 + 1, s.Length() ).c_str() ) )
               {
                  pow = s.SubString( pos2 + 1, s.Length() ).ToInt();
               }
               else
               {
                  pow = 1;
               }
            }
            else
            {
               u = s;
               pow = 1;
            }
            IncUnit( u, pow );
         }
      }
   }

   if( slo.Length() > 0 )
   {
      pos = -1;
      p = slo;
      while( pos )
      {
         pos = p.Pos( "*" );
         if( pos )
         {
            s = p.SubString( 1, pos - 1 );
            p = p.SubString( pos + 1, p.Length() );

            pos2 = s.Pos( "^" );
            if( pos2 )
            {
               u = s.SubString( 1, pos2 - 1 );
               if( isdoublestr( s.SubString( pos2 + 1, s.Length() ).c_str() ) )
               {
                  pow = s.SubString( pos2 + 1, s.Length() ).ToInt();
               }
               else
               {
                  pow = 1;
               }
            }
            else
            {
               u = s;
               pow = 1;
            }
            IncUnit( u, -pow );
         }
      }
   }
}
//---------------------------------------------------------------------------
CUnit CUnit::Reverse( void ) const
{
   int j;
   CUnit u = CUnit();

   if( count )
   {
      for( j = 0; j < count; j++ )
      {
         u.IncUnit( units[ j ].unit, -( units[ j ].count ) );
      }
   }
   else
   {
   }
   return u;
}
//---------------------------------------------------------------------------
AnsiString CUnit::ToString( void )
{
   int j;
   AnsiString p1 = "";
   AnsiString p2 = "";
   AnsiString p;

   if( count )
   {
      for( j = 0; j < count; j++ )
      {
         if( units[ j ].count > 0 )
         {
            if( p1.Length() > 0 ) // > "" )
            {
               p1 += "*";
            }
            p1 += GetUnitString( units[ j ].unit );
            if( units[ j ].count > 1 )
            {
               p1 += ( "^" + IntToStr( units[ j ].count ) );
            }
         }
         else if( units[ j ].count < 0 )
         {
            if( p2.Length() > 0 ) // > "" )
            {
               p2 += "*";
            }
            p2 += GetUnitString( units[ j ].unit );
            if( units[ j ].count < -1 )
            {
               p2 += ( "^" + IntToStr( -1 * units[ j ].count ) );
            }
         }
      }
   }

   if( p1 == "" && p2 != "" )
   {
      p1 = "1";
   }

   p = p1;
   if( p2 != "" )
   {
      p += ( "/" + p2 );
   }
   /*
   p += " [";
   for( j = 0; j < UnitKindCount; j++ )
   {
      p += AnsiString( Kind[ j ] );
      if( j < UnitKindCount - 1 )
      {
         p += ";";
      }
   }
   p += "]";
   */
   return p;
}
//---------------------------------------------------------------------------
int CUnit::GetSize( void )
{
   return sizeof( int ) + UnitKindCount * sizeof( int ) + count * sizeof( TMeasureUnitEx );
}
//---------------------------------------------------------------------------
int CUnit::Save( FILE* f )
{
   int written = 0;
   if( f )
   {
      int j;
      int size = sizeof( int ) + UnitKindCount * sizeof( int ) + count * sizeof( TMeasureUnitEx );
      
      //lprintf( " (sizeof(TMeasureUnitEx)=%d), count=%d ", sizeof( TMeasureUnitEx ), count );
      
      written += fwrite( &size, 1, sizeof( int ), f );
      written += fwrite( Kind, 1, sizeof( int ) * UnitKindCount, f );
      for( j = 0; j < count; j++ )
      {
         written += fwrite( units + j, 1, sizeof( TMeasureUnitEx ), f );
      }
   }
   return written;
}
//---------------------------------------------------------------------------
int CUnit::Load( FILE* f )
{
   int readed = 0;
   if( f )
   {
      int size, j;
      
      readed += fread( &size, 1, sizeof( int ), f );
      readed += fread( Kind, 1, sizeof( int ) * UnitKindCount, f );

      count = size - ( sizeof( int ) + UnitKindCount * sizeof( int ) );
      if( count % sizeof( TMeasureUnitEx ) )
      {
         return 0;
      }
      else
      {
         count /= sizeof( TMeasureUnitEx );
         //lprintf( "(sizeof(TMeasUnitEx)=%d),count=%d)", sizeof( TMeasureUnitEx ), count );
      
         units = new TMeasureUnitEx[ count ];
         for( j = 0; j < count; j++ )
         {
            readed += fread( units + j, 1, sizeof( TMeasureUnitEx ), f );
         }
      }
   }
   return readed;
}
//---------------------------------------------------------------------------
bool CUnit::BelongToSI( void )
{
   int i, j;
   bool lRes = true;
   bool lFound;

   for( j = 0; j < count && lRes; j++ )
   {
      lFound = false;
      for( i = 0; i < SIUnitCount && !lFound; i++ )
      {
         if( units[ j ].unit == SIUnits[ i ] )
         {
            lFound = true;
         }
      }
      if( !lFound )
      {
         lRes = false;
      }
   }
   return lRes;
}
//---------------------------------------------------------------------------
CUnit CUnit::UnitToSI( void )
{
   int j;
   CUnit u = CUnit();

   for( j = 0; j < UnitKindCount; j++ )
   {
      if( Kind[ j ] != 0 )
      {
         u.IncUnit( SIUnits[ j ], Kind[ j ] );
      }
   }
   return u;
}
//---------------------------------------------------------------------------
bool CUnit::AllowSqrt( void )
{
   int j;
   bool lPassed = true;

   for( j = 0; j < count; j++ )
   {
      if( units[ j ].count != 0 )
      {
         if( units[ j ].count % 2 )
         {
            lPassed = false;
         }
      }
   }
   return lPassed;
}
//---------------------------------------------------------------------------
bool CUnit::AllowXRoot( int power )
{
   int j;
   bool lPassed = true;

   if( power == 0 || power == 1 )
   {
      return true;
   }

   for( j = 0; j < count; j++ )
   {
      if( units[ j ].count != 0 )
      {
         if( units[ j ].count % power )
         {
            lPassed = false;
         }
      }
   }
   return lPassed;
}
//---------------------------------------------------------------------------
const CUnit& CUnit::operator=( const CUnit& AUnit )
{
   int j;

   if( AUnit.count )
   {
      count = AUnit.count;
      units = new TMeasureUnitEx[ count ];
      memcpy( units, AUnit.units, count * sizeof( TMeasureUnitEx ) );
      memcpy( Kind, AUnit.Kind, UnitKindCount * sizeof( int ) );
   }
   else
   {
      units = NULL;
      count = 0;
      for( j = 0; j < UnitKindCount; j++ )
      {
         Kind[ j ] = 0;
      }
   }
   return *this;
}
//---------------------------------------------------------------------------
CUnit operator*( CUnit& a, CUnit& b )
{
   CUnit u = Simplify( a, b );

   return u;
}
//---------------------------------------------------------------------------
CUnit operator/( CUnit& a, CUnit& b )
{
   CUnit u = Simplify( a, b.Reverse() );

   return u;
}
//---------------------------------------------------------------------------
bool operator==( CUnit a, CUnit b )
{
   bool lRes = true;
   int i, j;

   if( a.count == b.count )
   {
      for( j = 0; j < a.count && lRes; j++ )
      {
         i = b.UnitExists( a.units[ j ].unit );
         if( i >= 0 )
         {
            if( a.units[ j ].count == b.units[ i ].count )
            {
            }
            else
            {
               lRes = false;
            }
         }
         else
         {
            lRes = false;
         }
      }
   }
   else
   {
      lRes = false;
   }
   return lRes;
}
//---------------------------------------------------------------------------
bool operator!=( CUnit a, CUnit b )
{
   return !( a == b );
}
//---------------------------------------------------------------------------
CUnit pow( CUnit& a, int power )
{
   int j;
   CUnit u = a;

   for( j = 1; j < power; j++ )
   {
      u = u * a;
   }
   return u;
}
//---------------------------------------------------------------------------
CUnit sqrt( CUnit& a )
{
   CUnit u;

   if( a.AllowSqrt() )
   {
      int j;

      u = a;
      for( j = 0; j < a.count; j++ )
      {
         u.units[ j ].count = a.units[ j ].count / 2;
      }
   }
   else
   {
      //throw Exception( "Cannot execute sqrt on unit " + a.ToString() + "!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CUnit xroot( CUnit a, int power )
{
   CUnit u;

   if( a.AllowXRoot( power ) )
   {
      int j;

      u = a;
      for( j = 0; j < a.count; j++ )
      {
         u.units[ j ].count = a.units[ j ].count / power;
      }
   }
   else
   {
      ///throw Exception( "Cannot execute XRoot on unit " + a.ToString() + "!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CUnit CUnit::Decompose( void )
{
   int i, j;
   CUnit tmp;
   int currunit, currcount;
   CUnit u = *this;

   j = 0;
   //ShowMessage( "Before decompose: " + u.ToString() );
   while( j < u.count )
   //for( j = 0; j < count; j++ )
   {
      currunit = u.units[ j ].unit;
      currcount = u.units[ j ].count;
      if( !SimpleUnit( currunit ) )
      {
         tmp = GetDecomposedUnit( currunit );
         for( i = 0; i < tmp.count; i++ )
         {
            u.IncUnit( tmp.units[ i ].unit,
                       tmp.units[ i ].count * currcount );
         }
         u.DecUnit( currunit, currcount );
      }
      else
      {
         j++;
      }
   }
   //ShowMessage( "After decompose: " + u.ToString() );
   return u;
}
//---------------------------------------------------------------------------
CUnit CUnit::Compose( void )
{
   CUnit u;

   u = *this;
   /*
   //ShowMessage( "Before compose: " + u.ToString() );
   while( u.Contains( CUnit( "kg*m^2/s^3" ) ) )
   {
      u.Remove( CUnit( "kg*m^2/s^3" ) );
      u.Append( CUnit( "W" ) );
   }
   while( u.Contains( CUnit( "kg*m^2/s^2" ) ) )
   {
      u.Remove( CUnit( "kg*m^2/s^2" ) );
      u.Append( CUnit( "J" ) );
   }
   while( u.Contains( CUnit( "kg*m/s*s" ) ) )
   {
      u.Remove( CUnit( "kg*m/s*s" ) );
      u.Append( CUnit( "N" ) );
   }
   while( u.Contains( CUnit( "kg/m*s*s" ) ) )
   {
      u.Remove( CUnit( "kg/m*s*s" ) );
      u.Append( CUnit( "Pa" ) );
   }
   //ShowMessage( "After compose: " + u.ToString() );
   */
   return u;
}
//---------------------------------------------------------------------------
CUnit Decompose( CUnit a )
{
   return a.Decompose();
}
//---------------------------------------------------------------------------
CUnit Compose( CUnit a )
{
   return a.Compose();
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
CMeasure::CMeasure( void )
{
   Unit = CUnit();
   Kind = 0;
   Value = 0.0;
   UseExpo = false;
}
//---------------------------------------------------------------------------
CMeasure::CMeasure( double AValue, CUnit AUnit )
{
   Unit = AUnit;
   Value = AValue;
   Kind = 0;
   UseExpo = false;
}
//---------------------------------------------------------------------------
CMeasure::CMeasure( double AValue, AnsiString AUnit )
{
   Unit = CUnit();
   Unit.FromString( AUnit );
   Value = AValue;
   Kind = 0;
   UseExpo = false;
}
//---------------------------------------------------------------------------
CMeasure::CMeasure( const CMeasure& AValue )
{
   Unit = AValue.Unit;
   Kind = AValue.Kind;
   Value = AValue.Value;
   UseExpo = AValue.UseExpo;
}
//---------------------------------------------------------------------------
CMeasure::~CMeasure()
{
}
//---------------------------------------------------------------------------
double CMeasure::GetValue( void )
{
   return Value;
}
//---------------------------------------------------------------------------
CUnit CMeasure::GetUnit( void )
{
   return Unit;
}
//---------------------------------------------------------------------------
const CMeasure& CMeasure::operator=( const CMeasure& val )
{
   Unit = val.Unit;
   Value = val.Value;
   Kind = val.Kind;
   UseExpo = val.UseExpo;

   return *this;
}
//---------------------------------------------------------------------------
AnsiString CMeasure::ToString( void )
{
   AnsiString p;

   if( UseExpo )
   {
      p = DoubleToStrE( Value );
   }
   else
   {
      p = DoubleToStr( Value );
   }

   if( Unit.count > 0 )
   {
      p += AnsiString( "_" ) + Unit.ToString();
   }

   return p;
}
//---------------------------------------------------------------------------
bool CMeasure::BelongToSI( void )
{
   return Unit.BelongToSI();
}
//---------------------------------------------------------------------------
CMeasure CMeasure::ConvertToSI( void )
{
   //CMeasure tmp;
   CMeasure u;

   //tmp.Value = 0.0;
   //tmp.Unit = Unit.UnitToSI();

   u = ConvertMeasure( *this, Unit.UnitToSI(), 1 ); //tmp + ( *this );

   return u;
}
//---------------------------------------------------------------------------
CMeasure CMeasure::ConvertTo( CUnit AUnit )
{
   CMeasure tmp;
   CMeasure u;

   if( CompareKind( Unit, AUnit ) )
   {
      if( !Unit.BelongToSI() )
      {
         tmp = ConvertMeasure( *this, Unit.UnitToSI(), 1 );
      }
      else
      {
         tmp = *this;
      }
      if( AUnit.BelongToSI() )
      {
         u = tmp;
      }
      else
      {
         u = ConvertMeasure( tmp, AUnit, 0 );
      }
   }
   else
   {
      u = *this;
      //throw Exception( "Cannot convert " + ToString() + " to [" + AUnit.ToString() + "]!" );
   }
   return u;
}
//---------------------------------------------------------------------------
bool CMeasure::AllowSqrt( void )
{
   return Unit.AllowSqrt();
}
//---------------------------------------------------------------------------
bool CMeasure::AllowXRoot( int power )
{
   return Unit.AllowXRoot( power );
}
//---------------------------------------------------------------------------
int CMeasure::GetSize( void )
{
   return sizeof( double ) + Unit.GetSize();
}
//---------------------------------------------------------------------------
int CMeasure::Save( FILE* f )
{
   int written = 0;
   if( f )
   {
      written += fwrite( &Value, 1, sizeof( double ), f );
      written += Unit.Save( f );
   }
   return written;
}
//---------------------------------------------------------------------------
int CMeasure::Load( FILE* f )
{
   int readed = 0;
   if( f )
   {
      readed += fread( &Value, 1, sizeof( double ), f );
      readed += Unit.Load( f );
   }
   return readed;
}
//---------------------------------------------------------------------------
CMeasure operator+( CMeasure a, CMeasure b )
{
   CMeasure u;
   CMeasure aa, bb;
   double val;
   CUnit tmp;

   if( CompareKind( a.Unit, b.Unit ) )
   {
      if( a.Unit == b.Unit )
      {
         u.Value = a.Value + b.Value;
         u.Unit = a.Unit;
      }
      else
      {
         tmp = a.Unit;
         if( a.BelongToSI() )
         {
            aa = a;
         }
         else
         {
            aa = ConvertMeasure( a, a.Unit.UnitToSI(), 1 );
         }
         if( b.BelongToSI() )
         {
            bb = b;
         }
         else
         {
            bb = ConvertMeasure( b, b.Unit.UnitToSI(), 1 );
         }

         if( aa.Unit == bb.Unit )
         {
            u = aa + bb;
            if( a.BelongToSI() )
            {
            }
            else
            {
               u = ConvertMeasure( u, tmp, 0 );
            }
            u.Unit = u.Unit.Compose();
         }
         else
         {
            //throw Exception( "Cannot convert measures " + aa.Unit.ToString() +
            //                 " and " + bb.Unit.ToString() + "!" );
         }
      }
   }
   else
   {
      //throw Exception( "Cannot add " + a.ToString() + " and " + b.ToString() + "!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator-( CMeasure a, CMeasure b )
{
   CMeasure u;
   CMeasure aa, bb;
   double val;
   CUnit tmp;

   if( CompareKind( a.Unit, b.Unit ) )
   {
      if( a.Unit == b.Unit )
      {
         u.Value = a.Value - b.Value;
         u.Unit = a.Unit;
      }
      else
      {
         tmp = a.Unit;
         if( a.BelongToSI() )
         {
            aa = a;
         }
         else
         {
            aa = ConvertMeasure( a, a.Unit.UnitToSI(), 1 );
         }
         if( b.BelongToSI() )
         {
            bb = b;
         }
         else
         {
            bb = ConvertMeasure( b, b.Unit.UnitToSI(), 1 );
         }
         if( aa.Unit == bb.Unit )
         {
            u = aa - bb;
            if( a.BelongToSI() )
            {
            }
            else
            {
               u = ConvertMeasure( u, tmp, 0 );
            }
            u.Unit = u.Unit.Compose();
         }
         else
         {
            //throw Exception( "Cannot convert measures " + a.Unit.ToString() +
            //                 " and " + b.Unit.ToString() + "!" );
         }
      }
   }
   else
   {
      //throw Exception( "Cannot subtract " + a.ToString() + " and " + b.ToString() + "!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator*( CMeasure a, CMeasure b )
{
   CMeasure u;
   CUnit tmp;
   CMeasure aa, bb;

   if( CompareKind( a.Unit, b.Unit ) )
   {
      if( a.Unit == b.Unit )
      {
         u.Value = a.Value * b.Value;
         u.Unit = a.Unit * b.Unit;
      }
      else
      {
         tmp = a.Unit * a.Unit;
         if( a.BelongToSI() )
         {
            aa = a;
         }
         else
         {
            aa = ConvertMeasure( a, a.Unit.UnitToSI(), 1 );
         }
         if( b.BelongToSI() )
         {
            bb = b;
         }
         else
         {
            bb = ConvertMeasure( b, b.Unit.UnitToSI(), 1 );
         }
         u = aa * bb;
         //ShowMessage( aa.ToString() + " * " + bb.ToString() +
         //             " = " + ( aa * bb ).ToString() + "\n( " + u.ToString() + " ) " );

         if( a.BelongToSI() )
         {
         }
         else
         {
            u = ConvertMeasure( u, tmp, 0 );
            //ShowMessage( u.ToString() + "(" + tmp.ToString() + ")" );
         }
         u.Unit = u.Unit.Compose();
      }
   }
   else
   {
      u.Value = a.Value * b.Value;
      u.Unit = a.Unit * b.Unit;
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator*( double a, CMeasure b )
{
   CMeasure u = b;
   u.Value *= a;
   
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator*( CMeasure a, double b )
{
   CMeasure u = a;
   u.Value *= b;
   
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator/( CMeasure a, CMeasure b )
{
   CMeasure u;
   CUnit tmp;
   CMeasure aa, bb;

   if( b.Value != 0.0 )
   {
      if( CompareKind( a.Unit, b.Unit ) )
      {
         if( a.Unit == b.Unit )
         {
            u.Value = a.Value / b.Value;
            u.Unit = a.Unit / b.Unit;
         }
         else
         {
            tmp = a.Unit / a.Unit;
            if( a.BelongToSI() )
            {
               aa = a;
            }
            else
            {
               aa = ConvertMeasure( a, a.Unit.UnitToSI(), 1 );
            }
            if( b.BelongToSI() )
            {
               bb = b;
            }
            else
            {
               bb = ConvertMeasure( b, b.Unit.UnitToSI(), 1 );
            }
            u = aa / bb;

            if( a.BelongToSI() )
            {
            }
            else
            {
               u = ConvertMeasure( u, tmp, 0 );
            }
            u.Unit = u.Unit.Compose();
         }
      }
      else
      {
         u.Value = a.Value / b.Value;
         u.Unit = a.Unit / b.Unit;
      }
   }
   else
   {
      //throw Exception( "Division by zero [" + b.ToString() + "]!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator/( double a, CMeasure b )
{
   CMeasure u = b;
   
   if( b.Value != 0.0 )
   {
      u.Value = ( a / b.Value );
      u.Unit = b.Unit.Reverse();
   }
   else
   {
      u.Value = 0.0;
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure operator/( CMeasure a, double b )
{
   CMeasure u = a;
   
   if( b != 0.0 )
   {
      u.Value /= b;
   }
   else
   {
      u.Value = 0.0;
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure pow( CMeasure a, int power )
{
   CMeasure u;
   double x;
   int j;

   if( power > 0 )
   {
      u = a;
      for( j = 1; j < power; j++ )
      {
         u = u * a;
      }
   }
   else if( power < 0 )
   {
      if( a.Value != 0.0 )
      {
         u = a;
         for( j = -1; j > power; j-- )
         {
            u = u * a;
         }
         u = CMeasure( 1.0, "" ) / u;
      }
      else
      {
         //throw Exception( "Cannot raise " + a.ToString() +
         //                 " to " + AnsiString( power ) + "!" );
      }
   }
   else
   {
      u = CMeasure( 1.0, "" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure sqrt( CMeasure a )
{
   CMeasure u;

   if( a.Unit.AllowSqrt() )
   {
      u.Value = sqrt( a.Value );
      u.Unit = sqrt( a.Unit );
   }
   else
   {
      //throw Exception( "Cannot execute sqrt on value=[" + a.ToString() + "]!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure xroot( CMeasure a, int power )
{
   CMeasure u;

   if( a.Unit.AllowXRoot( power ) )
   {
      u.Value = pow( a.Value, 1.0 / (double)( power ) );
      u.Unit = xroot( a.Unit, power );
   }
   else
   {
      //throw Exception( "Cannot execute xroot on value=[" + a.ToString() + "]!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure inv( CMeasure a )
{
   CMeasure u;

   if( a.Value != 0.0 )
   {
      u.Value = 1.0 / a.Value;
      u.Unit = a.Unit.Reverse();
   }
   else
   {
      //throw Exception( "Divide by zero (" + a.ToString() + ")!" );
   }
   return u;
}
//---------------------------------------------------------------------------
CMeasure StrToMeasure( AnsiString Text )
{
   CMeasure u;
   int pos;
   AnsiString p;

   pos = Text.Pos( "_" );
   if( pos )
   {
      p = Text.SubString( 1, pos - 1 );
      //try
      //{
         if( p == "" )
         {
            u.Value = 1.0;
         }
         else
         {
            if( IsDouble( p ) )
            {
               u.Value = StrToDouble( p.c_str() );
               u.UseExpo = false;
            }
            else if( IsEDouble( p ) )
            {
               u.Value = StrEToDouble( p.c_str() );
               u.UseExpo = true;
            }
            else
            {
               //MessageBox( 0, ( "Not double nor exponent text [" + p + "]" ).c_str(), "!!!", MB_OK );
               u.Value = 1.0;
            }
         }
         u.Unit = StrToUnit( Text.SubString( pos + 1, Text.Length() ) );
      //}
      //catch(...)
      //{
      //   #ifdef __BORLANDC__
      //   throw Exception( "Cannot convert [" + Text + "] to measure value!" );
      //   #endif
      //}
   }
   else
   {
      //try
      //{
         if( Text.Length() > 0 && isdoublestr( Text.c_str() ) ) // NumericString( Text ) )
         {
            u.Value = StrToDouble( Text.c_str() );
         }
         else
         {
            u.Value = 0.0;
         }
         u.Unit = CUnit();
      //}
      //catch(...)
      //{
      //   #ifdef __BORLANDC__
      //   throw Exception( "Cannot convert [" + Text + "] to measure value!" );
      //   #endif
      //}
   }
   return u;
}
//---------------------------------------------------------------------------
bool ConvertUnit( ucnvstr* str, int From, int FCount, int To, int TCount, int ToSI = 1 )
{
   bool Convertable = false;
/*
   int i;
   bool lExit;

   i = 0;
   if( str )
   {
      str->coef = 0.0;
   }
   while( UnitsCnv[ i ].from != muUnknown && !lExit )
   {
      if( ToSI && UnitsCnv[ i ].from == From && UnitsCnv[ i ].to == To &&
          UnitsCnv[ i ].fcount <= FCount && UnitsCnv[ i ].tcount <= TCount )
      {
         Convertable = true;
         if( str )
         {
            str->coef = UnitsCnv[ i ].coef;
            str->fcount = UnitsCnv[ i ].fcount;
            str->tcount = UnitsCnv[ i ].tcount;
         }
         lExit = true;
      }
      else if( !ToSI && UnitsCnv[ i ].to == From && UnitsCnv[ i ].from == To &&
               UnitsCnv[ i ].tcount <= FCount && UnitsCnv[ i ].fcount <= TCount )
      {
         Convertable = true;
         if( str )
         {
            str->coef = 1.0 / UnitsCnv[ i ].coef;
            str->fcount = UnitsCnv[ i ].tcount;
            str->tcount = UnitsCnv[ i ].fcount;
         }
         lExit = true;
      }
      else
      {
         i++;
      }
   }
*/
   return Convertable;
}
//---------------------------------------------------------------------------
bool ConvertUnit2( double& coef, CUnit From, CUnit To, int ToSI = 1 )
{
   bool Convertable = false;
   int i;
   bool lExit;

   i = 0;
   coef = 0.0;
   while( UnitsCnv2[ i ]->from != CUnit() && !lExit )
   {
      if( ToSI && UnitsCnv2[ i ]->from == From && UnitsCnv2[ i ]->to == To )
      {
         Convertable = true;
         coef = UnitsCnv2[ i ]->coef;
         lExit = true;
      }
      else if( !ToSI && UnitsCnv2[ i ]->to == From && UnitsCnv2[ i ]->from == To )
      {
         Convertable = true;
         coef = 1.0 / UnitsCnv2[ i ]->coef;
         lExit = true;
      }
      else
      {
         i++;
      }
   }
   return Convertable;
}
//---------------------------------------------------------------------------
/*
CMeasure ConvertMeasure( CMeasure SrcVal, CUnit To, bool ToSI )
{
   CMeasure DstVal;
   CMeasure x, z;
   CUnit ftmp, ttmp;
   CUnit u;
   TMeasureUnitEx* pom;
   bool converted;
   int fc, tc;
   int i, j, oldSrcCount;
   int tmpu;
   ucnvstr cnv;
   AnsiString p;

   if( CompareKind( SrcVal.Unit, To ) )
   {
      //ftmp = SrcVal.Unit;
      if( ToSI )
      {
         ftmp = SrcVal.Unit.Decompose();
      }
      else
      {
         ftmp = SrcVal.Unit;
      }
      ttmp = To;

      DstVal.Value = SrcVal.Value;
      j = 0;
      while( j < ftmp.count )//&& ttmp.count > 0 )
      {
         converted = false;
         for( i = 0; i < ttmp.count && !converted; i++ )
         {
            fc = ftmp.units[ j ].count;
            if( fc < 0 )
            {
               fc *= -1;
            }
            tc = ttmp.units[ i ].count;
            if( tc < 0 )
            {
               tc *= -1;
            }

            if( ConvertUnit( &cnv,
                             ftmp.units[ j ].unit, fc,
                             ttmp.units[ i ].unit, tc, ToSI ) )
            {

               //p = "Converting j=" + AnsiString( j ) + ";i=" + AnsiString( i ) +
               //    "from " + GetUnitString( ftmp.units[ j ].unit ) +
               //                AnsiString( fc ) +
               //                AnsiString( " to " ) + GetUnitString( ttmp.units[ i ].unit ) +
               //                AnsiString( tc ) +
               //                AnsiString( "; coef=" ) + FloatToStr( cnv.coef );
               //ShowMessage( p );

               if( ftmp.units[ j ].count < 0 )
               {
                  DstVal.Value /= cnv.coef;
                  DstVal.Unit.IncUnit( ttmp.units[ i ].unit, -( cnv.tcount ) );
                  ftmp.DecUnit( ftmp.units[ j ].unit, -cnv.fcount );
                  ttmp.DecUnit( ttmp.units[ i ].unit, -cnv.tcount );
               }
               else
               {
                  DstVal.Value *= cnv.coef;
                  DstVal.Unit.IncUnit( ttmp.units[ i ].unit, cnv.tcount );
                  ftmp.DecUnit( ftmp.units[ j ].unit, cnv.fcount );
                  ttmp.DecUnit( ttmp.units[ i ].unit, cnv.tcount );
               }
               converted = true;
            }
         }
         if( !converted )
         {
            fc = ftmp.units[ j ].count;
            if( fc < 0 )
            {
               fc *= -1;
            }
            tmpu = GetUnitSI( ftmp.units[ j ].unit );
            if( ConvertUnit( &cnv,
                             ftmp.units[ j ].unit, fc,
                             tmpu, fc, ToSI ) )
            {
               if( ftmp.units[ j ].count < 0 )
               {
                  DstVal.Value /= cnv.coef;
                  DstVal.Unit.IncUnit( tmpu, -( cnv.tcount ) );
                  ftmp.DecUnit( ftmp.units[ j ].unit, -cnv.fcount );
               }
               else
               {
                  DstVal.Value *= cnv.coef;
                  DstVal.Unit.IncUnit( tmpu, cnv.tcount );
                  ftmp.DecUnit( ftmp.units[ j ].unit, cnv.fcount );
               }
               converted = true;
            }
         }
         if( !converted )
         {
            DstVal.Unit.IncUnit( ftmp.units[ j ].unit, ftmp.units[ j ].count );
            j++;
         }
      }
      //ShowMessage( "After conversion: ," + DstVal.Unit.ToString() + ">" );
   }
   else
   {
      DstVal.Value = 0.0;
      DstVal.Unit = CUnit();
   }
   return DstVal;
}
*/
//---------------------------------------------------------------------------
/*
CMeasure ConvertMeasure( CMeasure SrcVal, CUnit To, bool ToSI )
{
   CMeasure DstVal;
   CUnit ftmp, ttmp;
   TMeasureUnitEx* pom;
   bool converted;
   bool samekind;
   bool lMakeSimple;
   double coef;
   int fc, tc;
   int i, j, k, l, oldSrcCount;
   int* kind1;
   int *kind2;
   ucnvstr cnv;
   AnsiString p;

   if( CompareKind( SrcVal.Unit, To ) )
   {
      if( ToSI )
      {
         ftmp = SrcVal.Unit.Decompose();
         ttmp = To.Decompose();
      }
      else
      {
         ftmp = SrcVal.Unit;
         ttmp = To;
      }

      DstVal.Value = SrcVal.Value;
      DstVal.Unit = CUnit();
      j = 0;
      //ShowMessage( "Converting from " + ftmp.ToString() +
      //             " to " + ttmp.ToString() );
      while( UnitsCnv2[ j ].coef != 0.0 )
      {
         //ShowMessage( "Sprawdzam j=" + AnsiString( j ) +
         //             ";From=" + UnitsCnv2[ j ].from.ToString() +
         //             ";To=" + UnitsCnv2[ j ].to.ToString() );

         if( ToSI && ftmp.Contains( UnitsCnv2[ j ].from ) &&
                     ttmp.Contains( UnitsCnv2[ j ].to )
           )
         {
            //ShowMessage( "Converting TO SI from " + UnitsCnv2[ j ].from.ToString() +
            //             " to " + UnitsCnv2[ j ].to.ToString() );
            DstVal.Value *= UnitsCnv2[ j ].coef;
            //DstVal.Unit.Remove( UnitsCnv2[ j ].from );
            DstVal.Unit.Append( UnitsCnv2[ j ].to );
            ftmp.Remove( UnitsCnv2[ j ].from );
            ttmp.Remove( UnitsCnv2[ j ].to );
         }
         else if( ToSI && ftmp.Contains( UnitsCnv2[ j ].from.Reverse() ) &&
                     ttmp.Contains( UnitsCnv2[ j ].to.Reverse() )
           )
         {
            //ShowMessage( "Converting TO SI from " + UnitsCnv2[ j ].from.Reverse().ToString() +
            //             " to " + UnitsCnv2[ j ].to.Reverse().ToString() );
            DstVal.Value /= UnitsCnv2[ j ].coef;
            //DstVal.Unit.Remove( UnitsCnv2[ j ].from.Reverse() );
            DstVal.Unit.Append( UnitsCnv2[ j ].to.Reverse() );
            ftmp.Remove( UnitsCnv2[ j ].from.Reverse() );
            ttmp.Remove( UnitsCnv2[ j ].to.Reverse() );
         }
         else if( !ToSI && ftmp.Contains( UnitsCnv2[ j ].to ) &&
                           ttmp.Contains( UnitsCnv2[ j ].from )
                )
         {
            //ShowMessage( "Converting FROM SI from " + UnitsCnv2[ j ].to.ToString() +
            //             " to " + UnitsCnv2[ j ].from.ToString() );
            DstVal.Value /= UnitsCnv2[ j ].coef;
            //DstVal.Unit.Remove( UnitsCnv2[ j ].to );
            DstVal.Unit.Append( UnitsCnv2[ j ].from );
            ftmp.Remove( UnitsCnv2[ j ].to );
            ttmp.Remove( UnitsCnv2[ j ].from );
         }
         else if( !ToSI && ftmp.Contains( UnitsCnv2[ j ].to.Reverse() ) &&
                           ttmp.Contains( UnitsCnv2[ j ].from.Reverse() )
                )
         {
            //ShowMessage( "Converting FROM SI from " + UnitsCnv2[ j ].to.Reverse().ToString() +
            //             " to " + UnitsCnv2[ j ].from.Reverse().ToString() );
            DstVal.Value *= UnitsCnv2[ j ].coef;
            //DstVal.Unit.Remove( UnitsCnv2[ j ].to.Reverse() );
            DstVal.Unit.Append( UnitsCnv2[ j ].from.Reverse() );
            ftmp.Remove( UnitsCnv2[ j ].to.Reverse() );
            ttmp.Remove( UnitsCnv2[ j ].from.Reverse() );
         }
         else
         {
            j++;
         }
      }
      if( ftmp != CUnit() )
      {
         DstVal.Unit.Append( ftmp );
      }
      //ShowMessage( "After convert from " + SrcVal.Unit.ToString() +
      //             " to " + DstVal.Unit.ToString() );
   }
   return DstVal;
}
*/
//---------------------------------------------------------------------------
CMeasure ConvertTemperature( CMeasure src, CUnit To, bool ToSI )
{
   //"K", "Kelvin"
   //"C", "Celsius"
   //"F", "Fahrenheit"
   CMeasure dst;
   CUnit u;

   if( ToSI )
   {
      dst.Unit = CUnit( "K" );

      if( src.Unit.Contains( CUnit( "C" ) ) )
      {
         dst.Value = src.Value + 273.15;
      }
      else if( src.Unit.Contains( CUnit( "F" ) ) )
      {
         dst.Value = ( ( ( src.Value - 32.0 ) * 5.0 ) / 9.0 ) + 273.15;
      }
      else
      {
         dst.Value = src.Value;
      }
   }
   else
   {
      dst.Unit = To;
      if( To.Contains( CUnit( "C" ) ) )
      {
         dst.Value = src.Value - 273.15;
      }
      else if( To.Contains( CUnit( "F" ) ) )
      {
         dst.Value = ( ( ( src.Value - 273.15  ) * 9.0 ) / 5.0 ) + 32.0;
      }
      else
      {
         dst.Value = src.Value;
      }
   }
   return dst;
}
//---------------------------------------------------------------------------

CMeasure ConvertMeasure( CMeasure src, CUnit To, bool ToSI )
{
   CMeasure dst;
   double x;
   CUnit u, From;
   int tmpu, i, j;
   bool converted;

   if( CompareKind( src.Unit, To ) )
   {
      if( ToSI )
      {
         x = src.Value;
         u = src.Unit.Decompose(); //JoinUnits( src.Unit.Decompose(), To.Decompose() );

         if( u == CUnit( "F" ) || u == CUnit( "C" ) )
         {
            return ConvertTemperature( src, CUnit( "K" ), true );
         }

         //ShowMessage( "After join: " + u.ToString() );
         j = 0;
         while( j < u.count )
         {
            converted = false;
            i = 0;
            while( UnitsCnv2[ i ]->coef != 0.0 && !converted )
            {
               if( u.Contains( UnitsCnv2[ i ]->from ) )
               {
                  //ShowMessage( "Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->from.ToString() +
                  //             " with " + UnitsCnv2[ i ]->to.ToString() );
                  x *= UnitsCnv2[ i ]->coef;
                  u.Remove( UnitsCnv2[ i ]->from );
                  u.Append( UnitsCnv2[ i ]->to );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }
               else if( u.Contains( UnitsCnv2[ i ]->from.Reverse() ) )
               {
                  //ShowMessage( "Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->from.Reverse().ToString() +
                  //             " with " + UnitsCnv2[ i ]->to.Reverse().ToString() );
                  x /= UnitsCnv2[ i ]->coef;
                  u.Remove( UnitsCnv2[ i ]->from.Reverse() );
                  u.Append( UnitsCnv2[ i ]->to.Reverse() );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }
               i++;
            }
            if( converted )
            {
            }
            else
            {
               j++;
            }
         }

         dst.Value = x;
         dst.Unit = u;
         /*
         if( u.Contains( CUnit( "F" ) ) || u.Contains( CUnit( "C" ) ) )
         {
            dst = ConvertTemperature( dst, CUnit( "K" ), true );
         }
         */
      }
      else
      {
         x = src.Value;
         From = src.Unit; //JoinUnits( src.Unit.Decompose(), To.Decompose() );
         u = CUnit();
         //ShowMessage( "After join: " + u.ToString() );
         j = 0;
         while( j < From.count )
         {
            converted = false;
            i = 0;
            while( UnitsCnv2[ i ]->coef != 0.0 && !converted )
            {
               if( From.Contains( UnitsCnv2[ i ]->to ) && To.Contains( UnitsCnv2[ i ]->from ) )
               {
                  //ShowMessage( "1. Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->to.ToString() +
                  //             " with " + UnitsCnv2[ i ]->from.ToString() );
                  x /= UnitsCnv2[ i ]->coef;
                  //u.Remove( UnitsCnv2[ i ]->to );
                  From.Remove( UnitsCnv2[ i ]->to );
                  u.Append( UnitsCnv2[ i ]->from );
                  To.Remove( UnitsCnv2[ i ]->from );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }
               else if( From.Contains( UnitsCnv2[ i ]->to.Reverse() ) &&
                        To.Contains( UnitsCnv2[ i ]->from.Reverse() ) )
               {
                  //ShowMessage( "2. Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->to.Reverse().ToString() +
                  //             " with " + UnitsCnv2[ i ]->from.Reverse().ToString() );
                  x *= UnitsCnv2[ i ]->coef;
                  //u.Remove( UnitsCnv2[ i ]->to.Reverse() );
                  From.Remove( UnitsCnv2[ i ]->to.Reverse() );
                  u.Append( UnitsCnv2[ i ]->from.Reverse() );
                  To.Remove( UnitsCnv2[ i ]->from.Reverse() );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }

               else if( From.Contains( UnitsCnv2[ i ]->to ) &&
                        To.Contains( UnitsCnv2[ i ]->from.Reverse() ) )
               {
                  //ShowMessage( "3. Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->to.ToString() +
                  //             " with " + UnitsCnv2[ i ]->from.Reverse().ToString() );
                  x *= UnitsCnv2[ i ]->coef; // bylo *
                  //u.Append( UnitsCnv2[ i ]->to );
                  From.Append( UnitsCnv2[ i ]->to );
                  u.Append( UnitsCnv2[ i ]->from.Reverse() );
                  To.Remove( UnitsCnv2[ i ]->from.Reverse() );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }
               else if( From.Contains( UnitsCnv2[ i ]->to.Reverse() ) &&
                        To.Contains( UnitsCnv2[ i ]->from ) )
               {
                  //ShowMessage( "4. Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->to.Reverse().ToString() +
                  //             " with " + UnitsCnv2[ i ]->from.Reverse().ToString() );
                  x /= UnitsCnv2[ i ]->coef;  // bylo /
                  //u.Append( UnitsCnv2[ i ]->to.Reverse() );
                  From.Append( UnitsCnv2[ i ]->to.Reverse() );
                  u.Append( UnitsCnv2[ i ]->from );
                  To.Remove( UnitsCnv2[ i ]->from );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }

               else if( From.Contains( UnitsCnv2[ i ]->to ) &&
                        To.Contains( UnitsCnv2[ i ]->to.Reverse() ) )
               {
                  //ShowMessage( "5. Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->to.ToString() +
                  //             " with " + UnitsCnv2[ i ]->to.Reverse().ToString() );
                  //x *= UnitsCnv2[ i ]->coef; // bylo *
                  //u.Append( UnitsCnv2[ i ]->to );
                  From.Append( UnitsCnv2[ i ]->to );
                  u.Append( UnitsCnv2[ i ]->to.Reverse() );
                  To.Remove( UnitsCnv2[ i ]->to.Reverse() );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }
               else if( From.Contains( UnitsCnv2[ i ]->to.Reverse() ) &&
                        To.Contains( UnitsCnv2[ i ]->to ) )
               {
                  //ShowMessage( "6. Replace in " + u.ToString() +
                  //             " unit " + UnitsCnv2[ i ]->to.Reverse().ToString() +
                  //             " with " + UnitsCnv2[ i ]->to.ToString() );
                  //x /= UnitsCnv2[ i ]->coef;  // bylo /
                  //u.Append( UnitsCnv2[ i ]->to.Reverse() );
                  From.Append( UnitsCnv2[ i ]->to.Reverse() );
                  u.Append( UnitsCnv2[ i ]->to );
                  To.Remove( UnitsCnv2[ i ]->to );
                  converted = true;
                  //ShowMessage( "After replace " + u.ToString() );
               }

               i++;
            }
            if( converted )
            {
            }
            else
            {
               j++;
            }
         }
         dst.Value = x;
         if( From != CUnit() )
         {
            u.Append( From );
            //ShowMessage( "After append rest of From=[" + From.ToString() + "]\nu=[" +
            //             u.ToString() + "]" );
         }
         dst.Unit = u;

         if( To.Contains( CUnit( "F" ) ) &&
             u.Contains( CUnit( "K" ) ) )
         {
            dst = ConvertTemperature( dst, CUnit( "F" ), false );
         }
         else if( To.Contains( CUnit( "C" ) ) &&
                  u.Contains( CUnit( "K" ) ) )
         {
            dst = ConvertTemperature( dst, CUnit( "C" ), false );
         }
      }
   }
   else
   {
      dst.Value = 0.0;
      dst.Unit = To;
   }
   return dst;
}

//---------------------------------------------------------------------------
CMeasure round( CMeasure Src, int Precision )
{
   CMeasure w;

   w.Value = dround( Src.Value, Precision );
   w.Unit = Src.Unit;

   return w;
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
CUnit StrToUnit( AnsiString Text )
{
   CUnit u = CUnit( Text );

   return u;
}
//---------------------------------------------------------------------------
int GetUnitCount( void )
{
   int j, count;

   j = 0;
   count = 0;
   while( Units[ j ].unit != muUnknown )
   {
      count++;
      j++;
   }
   return count;
}
//---------------------------------------------------------------------------
void SaveConversionTable( AnsiString FName )
{
   FILE* f;
   int i, j;
   AnsiString p;
   bool lFound;
   CUnit From;
   CUnit To;

   f = fopen( FName.c_str(), "wt" );
   if( f )
   {
      j = 0;
      while( UnitsCnv2[ j ]->coef != 0.0 )
      {
         i = 0;
         lFound = false;
         p = "?";
         while( !lFound && Units[ i ].unit != muUnknown )
         {
            if( CUnit( AnsiString( Units[ i ].text ) ) == UnitsCnv2[ j ]->from )
            {
               p = AnsiString( Units[ i ].desc );
               lFound = true;
            }
            else
            {
               i++;
            }
         }
         From = UnitsCnv2[ j ]->from;
         To = UnitsCnv2[ j ]->to;
         
         fprintf( f, "1 %-20s\t\t[%s]\t\t\t= %30.06G [%s]\n",
                  p.c_str(),
                  From.ToString().c_str(),
                  UnitsCnv2[ j ]->coef,
                  To.ToString().c_str() );
         j++;
      }
      fclose( f );
   }
}
//---------------------------------------------------------------------------
bool ConsistentUnits( CMeasure a, CMeasure b )
{
   return CompareKind( a.Unit, b.Unit );
}
//---------------------------------------------------------------------------
AnsiString MeasureToStr( CMeasure a )
{
   return a.ToString();
}
//---------------------------------------------------------------------------
AnsiString MeasureToStrF( CMeasure a, int prec )
{
   AnsiString p;
   
   if( prec < 0 )
   {
      prec = 6;
   }
   if( a.UseExpo )
   {
      p = DoubleToStrE( a.Value, prec ) + AnsiString( "_" ) + a.Unit.ToString();
   }
   else
   {
      p = DoubleToStr( a.Value, prec ) + AnsiString( "_" ) + a.Unit.ToString();
   }
   return p;
}
//---------------------------------------------------------------------------
AnsiString MeasureToStrE( CMeasure a, int prec )
{
   AnsiString p;

   if( prec < 0 )
   {
      prec = 6;
   }
   p = DoubleToStrE( a.Value, prec ) + AnsiString( "_" ) + a.Unit.ToString();
   return p;
}
//---------------------------------------------------------------------------
//
// Help function to get categories of measures and measure units 
// in categories
//
//---------------------------------------------------------------------------
int GetMeasureCategories( TStrings* CatStr, TStrings* CatDsc )
{
   int j = 0;
   if( CatStr && CatDsc )
   {
      CatStr->Clear();
      CatDsc->Clear();
      while( _measureCategories[ j ].category != ucUnknown )
      {
         CatStr->Add( IntToStr( _measureCategories[ j ].category ) );
         CatDsc->Add( _measureCategories[ j ].desc );
         j++;
      }
   }
   return j;   
}
//---------------------------------------------------------------------------
int GetMeasuresInCategory( int Category, TStrings* MeasStr, TStrings* MeasDsc )
{
   int j = 0;
   int count = 0;
   if( MeasStr && MeasDsc )
   {
      MeasStr->Clear();
      MeasDsc->Clear();
      while( _measureInCategory[ j ].category != ucUnknown )
      {
         if( _measureInCategory[ j ].category == Category )
         {
            MeasStr->Add( _measureInCategory[ j ].sdesc );
            MeasDsc->Add( _measureInCategory[ j ].ldesc );
            count++;
         }
         j++;
      }
   }
   return count;
}
//---------------------------------------------------------------------------

