#ifndef _ASTACK_H
#define _ASTACK_H

#include <astring.h>
#include <atom.h>
#include <atomlist.h>

#ifdef __YACAS__
#include <yacas.h>
#endif

//------------------------------------------------------------------------------------------------
enum TStackFunc {
                sfUnknown,
                sfAdd, sfSub, sfMul, sfDiv, 
                sfPercent, sfPercentT, sfPercentCH,
                sfNeg, sfPow, sfPow2, sf1perX, sfSign, sfFactorial,
                sfSqrt, sfRootN, sfAbs, sfExp, sfLn, sfLog10, sfALog, 
                sfLnp1, sfExpm,
                sfSin, sfSinH, sfASin, sfASinH,
                sfCos, sfCosH, sfACos, sfACosH,
                sfTan, sfTanH, sfATan, sfATanH,
                sfCtg, sfCtgH, sfACtg, sfACtgH,
                sfSec, sfSecH, sfASec, sfASecH,
                sfCsc, sfCscH, sfACsc, sfACscH,
                sfSetRad, sfSetDeg, sfDeg2Rad, sfRad2Deg,
                sfReal, sfImag, sfArg, sfConj, sfNorm, sfPolar,
                sfIp, sfFp,
                sfSum, sfMax, sfMin, sfAvg,
                sfEq, sfNEq, sfGreat, sfGreatEq, sfLess, sfLessEq,
                sfConvert,
                sfCross, sfDot, 
                sfLength,
                sfBin, sfDec, sfHex, sfOct, sfAnd, sfOr, sfXor, sfNot,
                sfIntDiv, sfIntMod, sfSlb, sfSrb, sfRlb, sfRrb,
                sfIsPrime, sfGamma, sfPsi,
                sfReal2Complex, sfReal2Exponent, sfExponent2Real,
                sfReal2Vector2, sfReal2Vector3,
                sfEvalExp, sfNum, sfDeriv, sfDervx, sfInteg, sfIntvx, sfIntegN,
                sfSolve, sfSolvx, sfLimit, sfLimvx,
                sfPV, sfPMT, sfFV,
                sfUnknownEnd
                };
//------------------------------------------------------------------------------------------------
enum TStackAngleMeasure { samUnknown, samRadian, samDegree };
//------------------------------------------------------------------------------------------------
#ifdef __YACAS__
class PGLispOutput : public LispOutput
{
   public:
   PGLispOutput( void ) : LispOutput() {}
   void PutChar( LispChar aChar ) {}
};
#endif
//------------------------------------------------------------------------------------------------
class atomstack
{
   private:
	#ifdef __YACAS__
   CYacas* _yacas;
   PGLispOutput* _yacas_out;
   LispString* stringout;
   StringOutput* output;
   FILE* _yacas_file;
	#endif
	
   bool _yacas_valid;
   atom** _atoms;
   atomlist* _vars;
   atomlist* _const;
   int _count;
   int _ptr;
   int _size;
   int _errcode;
   int _prec;
   char _errmsg[ 256 ];
   TStackAngleMeasure _anglemeasure;
   
   void create_errmsg( TStackFunc func );
   void create_errmsg( const char* lpszErr );
   
   int getargc( TStackFunc func );
   bool evaltokens( TStringList* Tokens );
   
   atom Deg2Rad( atom& a );
   atom Rad2Deg( atom& a );
   
   public:
   atomstack( int size = 255 );
   ~atomstack();
   
   bool init_yacas( void );
   bool init_yacas( char* archive );

   void set_precision( int aprec );
   void set_anglemeasure( TStackAngleMeasure aanglemeasure );

   void assignConstants( atomlist* AList );
   void assignVariables( atomlist* AList );
   
   atomlist* getConstants( void ) { return _const; }
   atomlist* getVariables( void ) { return _vars; }
   
   bool isempty( void );
   void clear( void );
   void push( atom& a );
   atom pop( void );
   atom get( int index );
   bool drop( int index );
   bool totop( int index );
   bool swap( int i1, int i2 );
   
   int isfunc( const char* funcname, bool caseSens = true );
   int isconst( const char* constname, bool caseSens = true );
   
   bool eval( TStackFunc func );
   bool eval( char* funcname, bool caseSens = true );
   bool evalcmd( char* cmdline, bool caseSens = true );

   #ifdef __YACAS__
   atom evalexp( atom e );
   atom evalnum( atom e );

   atom deriv( atom e, atom v );
   atom dervx( atom e );
   atom integ( atom e, atom v );
   atom intvx( atom e );
   atom integn( atom e, atom v, atom b1, atom b2 );
   atom solve( atom e, atom v );
   atom solvx( atom e );
   atom limit( atom e, atom lim, atom v );
   atom limvx( atom e, atom lim );
   #endif
   
   int errcode( void ) { return _errcode; }
   int count( void ) { return _count; }
   int size( void ) { return _size; }
   int prec( void ) { return _prec; }
	TStackAngleMeasure angleMeasure( void ) { return _anglemeasure; }

   const char* errmsg( void );

   bool save( FILE* f );
   bool load( FILE* f );  
};
//------------------------------------------------------------------------------------------------
#endif // _ASTACK_H
