#include <math.h>
#include <astring.h>

#ifdef __WIN32__
#include <windows.h>
#include <winuser.h>
#endif
//---------------------------------------------------------------------------------
//
//
//------------------------------------------------------------------------------------------------
int strtrim( char* dst, const char* src )
{
   int start = 0;
   int stop = 0;
   int count = 0;
   int len;
   
   if( src && dst )
   {
      len = strlen( src );

      while( src[ start ] == ' ' && start < len )
      {
         start++;
      }
   
      stop = len - 1;
      while( src[ stop ] == ' ' && stop > start )
      {
         stop--;
      }
      count = stop - start + 1;
      strncpy( dst, src + start, count );
      dst[ count ] = '\0';
   }
   return count;
}
//---------------------------------------------------------------------------------
int strpos( const char* str, char chr, int start )
{
   int index = -1;
   int len = strlen( str );
   
   if( str && start < len )
   {
      int j = start;   
      
      while( index == -1 && j < len )
      {
         if( str[ j ] == chr )
         {
            index = j;
         }
         else
         {
            j++;
         }
      }
   }
   return index;
}
//---------------------------------------------------------------------------------
#ifndef _WIN32
void CharUpperBuff( char* Buffer, int Length )
{
   if( Buffer )
   {
      int j;
      
      for( j = 0; j < Length; j++ )
      {
         if( Buffer[ j ] >= 'a' && Buffer[ j ] <= 'z' )
         {
            Buffer[ j ] = Buffer[ j ] - 'a' + 'A';
         }
      }
   }
}
//---------------------------------------------------------------------------------
void CharLowerBuff( char* Buffer, int Length )
{
   if( Buffer )
   {
      int j;

      for( j = 0; j < Length; j++ )
      {
         if( Buffer[ j ] >= 'A' && Buffer[ j ] <= 'Z' )
         {
            Buffer[ j ] = Buffer[ j ] - 'A' + 'z';
         }
      }
   }
}
#endif
//---------------------------------------------------------------------------------
//namespace XStrings
//{
//---------------------------------------------------------------------------------
//
//
//---------------------------------------------------------------------------------
#ifndef __BORLANDC__
XString::XString( void )
    : Buffer(NULL)
{
}
//---------------------------------------------------------------------------------
XString::XString( const char* FText )
    : Buffer(NULL)
{
    if( FText )
    {
        Buffer = new char[ strlen( FText ) + 1 ];
        strcpy( Buffer, FText );
    }
}
//---------------------------------------------------------------------------------
XString::XString( const char FChar )
    : Buffer(NULL)
{
   if( FChar != '\0' )
   {
      Buffer = new char[ 2 ];
      Buffer[ 0 ] = FChar;
      Buffer[ 1 ] = '\0';
   }
}
//---------------------------------------------------------------------------------
XString::XString( const char* src, unsigned int len )
   : Buffer(NULL)
{
   if( src )
   {
      Buffer = new char[ len + 1 ];
      memcpy( Buffer, src, len );
      Buffer[ len ] = '\0';
   }
}
//---------------------------------------------------------------------------------
XString::XString( const XString& FText )
    : Buffer(NULL)
{
   if( FText.Buffer )
   {
      int len = strlen( FText.Buffer );
      Buffer = new char[ len + 1 ];
      memcpy( Buffer, FText.Buffer, len );
      Buffer[ len ] = '\0';
   }
}
//---------------------------------------------------------------------------------
XString::~XString()
{
   EmptyBuffer();
}
//---------------------------------------------------------------------------------
void XString::EmptyBuffer( void )
{
    if( Buffer )
    {
        delete [] Buffer;
        Buffer = NULL;
    }
}
//---------------------------------------------------------------------------------
int XString::Length( void ) const
{
    int length;
    
    if( !Buffer )
    {
        length = 0;
    }
    else
    {
        length = strlen( Buffer );
    }
    return length;
}
//---------------------------------------------------------------------------------
char* XString::c_str( void ) const
{
    return Buffer;
}
//---------------------------------------------------------------------------------
int XString::Pos( XString Tmpl, int Start ) const
{
    int pos = 0;
    
    if( !Buffer || !Tmpl.Buffer || Start <= 0 || Start > (int)( strlen( Buffer ) ) )
    {
    }
    else if( strlen( Buffer ) > 0 )
    {
       char* s = strstr( Buffer + Start - 1, Tmpl.Buffer );
       if( s )
       {
           pos = s - Buffer + 1;
        }
    }
    return pos;
}
//---------------------------------------------------------------------------------
XString XString::Insert( const XString& str, int pos )
{
    XString res;
    if( pos >= 1 && pos <= Length() )
    {
        res = SubString( 1, pos - 1 );
        res += str;
        res += SubString( pos, Length() );
    }   
    return res;
}
//---------------------------------------------------------------------------------
XString XString::Delete( int index, int count )
{
    XString res;
    if( index >= 1 && index <= Length() )
    {
        res = SubString( 1, index - 1 );
        if( index + count <= Length() )
        {
            res += SubString( index + count, Length() );
        }
    }  
    return res;
}
//---------------------------------------------------------------------------------
XString XString::SubString( int index, int count ) const
{
   // Emulate Pascal's _LStrCopy: if 'index' is bogus, or the 'count' is negative,
   // return an empty string.
   if (index < 1 || index > Length() || count < 0)
      return XString();

    // If 'count' is too large, copy the rest of the string.
    int n = Length() - index + 1;
    if( n > count )
       n = count;
    return XString( Buffer + index - 1, n );
}
//---------------------------------------------------------------------------------
/*
XString XString::SubString( int index, int count ) 
{
    XString res = "";
    
    if( index >= 1 && index <= Length() )
    {
        int j, i;
        char* tmp = new char[ count + 1 ];
        for( j = 0, i = index - 1; j < count && i < strlen( Buffer ); j++ )
        {
            tmp[ j ] = Buffer[ i ];
            i++;
        }
        tmp[ j ] = '\0';
        res = XString( tmp );
        delete tmp;
    }
    return res;
}*/
//---------------------------------------------------------------------------------
XString XString::UpperCase( void ) const
{
    XString res = *this;

    CharUpperBuff( res.Buffer, res.Length() );
    return res;
}
//---------------------------------------------------------------------------------
XString XString::LowerCase( void ) const
{
    XString res = *this;
    CharLowerBuff( res.Buffer, res.Length() );
    return res;
}
//---------------------------------------------------------------------------------
XString XString::Trim( void ) const
{
   char* buf;
   XString res = "";

   if( Length() )
   {
      buf = new char[ Length() + 1 ];
      strtrim( buf, Buffer );
      res = XString( buf );
      delete [] buf;
   }
   return res;
}
//---------------------------------------------------------------------------------
bool XString::IsInteger() const
{
   int j, value;
   bool lCorrect = true;

   for( j = 0; j < (int)strlen( Buffer ) && lCorrect; j++ )
   {
      if( ( Buffer[ j ] >= '0' && Buffer[ j ] <= '9' ) || ( j == 0 && Buffer[ j ] == '-' ) )
      {
      }
      else
      {
         lCorrect = false;
      }
   }
   return lCorrect;
}
//---------------------------------------------------------------------------------
bool XString::IsDouble() const
{
   int j, len;
   bool lCorrect = true;
   bool lDot = false;
   char buf[ 10 ];

   if( Buffer )
   {
      len = (int)strlen( Buffer );
      for( j = 0; j < len && lCorrect; j++ )
      {
         if( j == 0 && ( Buffer[ j ] == '-' || Buffer[ j ] == '+' ) )
         {
         }
         else if( Buffer[ j ] >= '0' && Buffer[ j ] <= '9' )
         {
         }
         else if( Buffer[ j ] == '.' )
         {
            if( !lDot )
            {
               lDot = true;
            }
            else
            {
               //MessageBox( 0, Buffer, "2", MB_OK );
               lCorrect = false;
            }
         }
         else
         {
            //MessageBox( 0, Buffer, "1", MB_OK );
            lCorrect = false;
         }
      }
   }
   else
   {
      lCorrect = false;
   }
   return lCorrect;
}
//---------------------------------------------------------------------------------
bool XString::IsEDouble( void ) const
{
   int j, len, e_pos;
   bool lCorrect = false;
   
   if( Buffer )
   {
      len = strlen( Buffer );
      for( j = 1, e_pos = -1; j <= len && e_pos == -1; j++ )
      {
         if( Buffer[ j - 1 ] == 'E' || Buffer[ j - 1 ] == 'e' )
         {
            e_pos = j;
         }
      }
      if( e_pos > 1 && e_pos < len )
      {
         XString p1 = SubString( 1, e_pos - 1 );
         XString p2 = SubString( e_pos + 1, len );
         
         lCorrect = ( p1.IsDouble() && p2.IsInteger() );
         //MessageBox( 0, ( "[" + p1 + "] (" + ( p1.IsDouble() ? "OK" : "Err" ) + "), " +
         //                 "[" + p2 + "] (" + ( p2.IsInteger() ? "OK" : "Err" ) + ") = " +
         //                 ( lCorrect ? "OK" : "Err" ) ).c_str(), "XString", MB_OK );
      }
   }
   return lCorrect;
}
//---------------------------------------------------------------------------------
int XString::ToInt( void ) const
{
   int value;
   
   if( IsInteger() && Buffer )
   {
      int j, start, sign, len;
      
      if( Buffer[ 0 ] == '-' )
      {
         start = 1;
         sign = -1;
      }
      else
      {
         start = 0;
         sign = 1;
      }
      value = 0;
      len = strlen( Buffer );
      for( j = start; j < len; j++ )
      {
         value = ( value * 10 ) + (int)( Buffer[ j ] - 48 );
      }
      value *= sign;
   }
   else
   {
      value = 0;
   }
   return value;
}
//---------------------------------------------------------------------------------
double XString::ToDouble( void ) const
{
   int j, start, e_pos, len;
   double value;

   if( IsDouble() )
   {
      double v1 = 0.0;
      double v2 = 0.0;
      double t;
      double sign;
      bool lExit;
      char buf[ 1000 ];

      if( Buffer[ 0 ] == '-' )
      {
         start = 1;
         sign = -1.0;
      }
      else
      {
         start = 0;
         sign = 1.0;
      }
      
      j = start;
      len = strlen( Buffer );
      lExit = false;
      while( j < len && !lExit )
      {
         if( Buffer[ j ] == '.' )
         {
            lExit = true;
         }
         else
         {
            v1 = ( v1 * 10.0 ) + (double)( Buffer[ j ] - 48 );
            j++;
         }
      }
      //sprintf( buf, "v1=%f, j=%d", v1, j );
      //MessageBox( 0, buf, "Buffer", MB_OK );      
      
      j++;
      t = 10.0;
      lExit = false;
      while( !lExit && j < len )
      {
         v2 += ( (double)( Buffer[ j ] - 48 ) / t );
         t *= 10.0;
         j++;
      }

      //sprintf( buf, "v2=%f, j=%d", v2, j );
      //MessageBox( 0, buf, "Buffer", MB_OK );      

      value = sign * ( v1 + v2 );      
   }
   else if( IsEDouble() )
   {
      len = strlen( Buffer );
      for( j = 1, e_pos = -1; j <= len && e_pos == -1; j++ )
      {
         if( Buffer[ j - 1 ] == 'E' || Buffer[ j - 1 ] == 'e' )
         {
            e_pos = j;
         }
      }
      if( e_pos > 1 && e_pos < len )
      {
         XString p1 = SubString( 1, e_pos - 1 );
         XString p2 = SubString( e_pos + 1, len );

         if( p1.IsDouble() && p2.IsInteger() )
         {
            value = p1.ToDouble() * pow( 10.0, (double)( p2.ToInt() ) );
         }
         else
         {
            value = 0.0;
         }
      }
   }
   else
   {
      value = 0.0;
   }
   return value;
}
//---------------------------------------------------------------------------------
const XString& XString::operator=( const XString& val )
{
    EmptyBuffer();
    if( val.Buffer )
    {
        Buffer = new char[ val.Length() + 1 ];
        strcpy( Buffer, val.Buffer );
    }
    return *this;
}
//---------------------------------------------------------------------------------
const XString& XString::operator=( const char* val )
{
    EmptyBuffer();
    if( val )
    {
        Buffer = new char[ strlen( val ) + 1 ];
        strcpy( Buffer, val );
    }
    return *this;
}
//---------------------------------------------------------------------------------
const XString& XString::operator+=( const XString& val )
{
    char* tmp = new char[ Length() + val.Length() + 1 ];
    if( Buffer )
    {
        strcpy( tmp, Buffer );
    }
    if( val.Buffer )
    {
        strcat( tmp, val.Buffer );
    }
    EmptyBuffer();
    Buffer = tmp;
    return *this;
}
//---------------------------------------------------------------------------------
const XString& XString::operator+=( const char* val )
{
    char* tmp = new char[ Length() + strlen( val ) + 1 ];
    if( Buffer )
    {
        strcpy( tmp, Buffer );
    }
    if( val )
    {
        strcat( tmp, val );
    }
    EmptyBuffer();
    Buffer = tmp;
    return *this;
}
//---------------------------------------------------------------------------------
const char XString::operator[]( int index )
{
    if( index >= 1 && index <= Length() )
    {
        return Buffer[ index - 1 ];
    }
    else
    {
        return '\0';
    }
}
//---------------------------------------------------------------------------------
XString operator+( const XString& a, const XString& b )
{
   XString res;
   
   res = a;
   res += b;
   
   return res;
}
//---------------------------------------------------------------------------------
XString operator+( const XString& a, const char* b )
{
   XString res;
   XString tmp;
   
   tmp = XString( b );
   
   res = a;
   res += tmp;
   
   return res;
}
//---------------------------------------------------------------------------------
XString operator+( const char* a, const XString& b )
{
   XString res = XString( a );

   res += b;

   return res;
}
//---------------------------------------------------------------------------------
bool operator==( const XString& a, const XString& b )
{
   return ( strcmp( a.Buffer, b.Buffer ) == 0 );
}
//---------------------------------------------------------------------------------
bool operator==( const XString& a, const char* b )
{
   return ( a == XString( b ) );
}
//---------------------------------------------------------------------------------
bool operator==( const char* a, const XString& b )
{
   return ( XString( a ) == b );
}
//---------------------------------------------------------------------------------
bool operator!=( const XString& a, const XString& b )
{
   return !( a == b );
}
//---------------------------------------------------------------------------------
bool operator!=( const XString& a, const char* b )
{
   return !( a == XString( b ) );
}
//---------------------------------------------------------------------------------
bool operator!=( const char* a, const XString& b )
{
   return !( XString( a ) == b );
}
//---------------------------------------------------------------------------------
bool operator>( const XString& a, const XString& b )
{
   return ( strcmp( a.Buffer, b.Buffer ) > 0 );
}
//---------------------------------------------------------------------------------
bool operator>( const XString& a, const char* b )
{
   return ( a > XString( b ) );
}
//---------------------------------------------------------------------------------
bool operator>( const char* a, const XString& b )
{
   return ( XString( a ) > b );
}
//---------------------------------------------------------------------------------
bool operator>=( const XString& a, const XString& b )
{
   return ( strcmp( a.Buffer, b.Buffer ) >= 0 );
}
//---------------------------------------------------------------------------------
bool operator>=( const XString& a, const char* b )
{
   return ( a >= XString( b ) );
}
//---------------------------------------------------------------------------------
bool operator>=( const char* a, const XString& b )
{
   return ( XString( a ) >= b );
}
//---------------------------------------------------------------------------------
bool operator<( const XString& a, const XString& b )
{
   return ( strcmp( a.Buffer, b.Buffer ) < 0 );
}
//---------------------------------------------------------------------------------
bool operator<( const XString& a, const char* b )
{
   return ( a < XString( b ) );
}
//---------------------------------------------------------------------------------
bool operator<( const char* a, const XString& b )
{
   return ( XString( a ) < b );
}
//---------------------------------------------------------------------------------
bool operator<=( const XString& a, const XString& b )
{
   return ( strcmp( a.Buffer, b.Buffer ) <= 0 );
}
//---------------------------------------------------------------------------------
bool operator<=( const XString& a, const char* b )
{
   return ( a <= XString( b ) );
}
//---------------------------------------------------------------------------------
bool operator<=( const char* a, const XString& b )
{
   return ( XString( a ) <= b );
}
#endif
//---------------------------------------------------------------------------------
XString IntToStr( int Value )
{
   char buf[ 100 ];

   sprintf( buf, "%d", Value );
   return XString( buf );
}
//---------------------------------------------------------------------------------
XString FloatToStr( double Value )
{
   char buf[ 100 ];

   sprintf( buf, "%f", Value );
   return XString( buf );
}
//---------------------------------------------------------------------------------
XString DoubleToStr( double Value, int Prec )
{
   bool lExit;
   char buf[ 100 ];
   if( Prec < 0 )
   {
      Prec = 12;
   }
   sprintf( buf, "%40.*f", Prec, Value );
   for( int j = strlen( buf ) - 1, lExit = false; j >= 0 && !lExit; j-- )
   {
      if( buf[ j ] == '0' || buf[ j ] == '\0' || buf[ j ] == ' ' )
      {
         buf[ j ] = '\0';
      }
      else if( buf[ j ] == '.' )
      {
         buf[ j ] = '\0';
         lExit = true;
      }
      else
      {
         lExit = true;
      }
   }
   return XString( buf ).Trim();
}
//---------------------------------------------------------------------------------
XString DoubleToStrF( double Value, int Prec )
{
   if( Prec < 0 )
   {
      Prec = 6;
   }
   return DoubleToStr( Value, Prec );
}
//---------------------------------------------------------------------------------
XString DoubleToStrE( double Value, int Prec )
{
   XString p;
   double mant;
   double sign;
   int expo;

   if( Prec < -1 )
   {
      Prec = 6;
   }
   
   mant = Value;
   expo = 0;
   if( mant < 0.0 )
   {
      sign = -1.0;
      mant = -mant;
   }
   else
   {
      sign = 1.0;
   }

   if( mant >= 10.0 )
   {
      while( mant >= 10.0 )
      {
         mant /= 10.0;
         expo++;
      }
   }
   else if( mant > 0.0 && mant < 1.0 )
   {
      while( mant < 1.0 )
      {
         mant *= 10.0;
         expo--;
      }
   }
   if( mant >= 1.0 && mant < 10.0 )
   {
      #ifdef __BORLANDC__
      p = DoubleToStr( sign * mant, Prec ) + "E" + Sysutils::IntToStr( expo );
      #else
      p = DoubleToStr( sign * mant, Prec ) + "E" + IntToStr( expo );
      #endif
   }
   else
   {
      p = DoubleToStr( sign * mant, Prec );
   }
   return p;
}
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
double StrToDouble( XString Str )
{
   return Str.ToDouble();
}
//---------------------------------------------------------------------------------
int HexStrToInt( XString Str )
{
   bool res;
   int j, x;
   
   x = 0;
   Str = Str.UpperCase();
   if( Str.Length() > 2 )
   {
      res = ( Str.SubString( 1, 2 ) == "#H" );
      for( j = 3; j <= Str.Length() && res; j++ )
      {
         res = ( ( Str[ j ] >= '0' && Str[ j ] <= '9' ) ||
                 ( Str[ j ] >= 'A' && Str[ j ] <= 'F' )
               );
      }
      if( res )
      {
         for( j = 3; j <= Str.Length(); j++ )
         {
            if( Str[ j ] >= '0' && Str[ j ] <= '9' )
            {
               x = x * 16 + Str[ j ] - 48;
            }
            else
            {
               x = x * 16 + Str[ j ] - 55;
            }
         }
      }
   }
   return x;
}
//---------------------------------------------------------------------------------
int OctStrToInt( XString Str )
{
   bool res;
   int j, x;

   x = 0;
   Str = Str.UpperCase();
   if( Str.Length() > 2 )
   {
      res = ( Str.SubString( 1, 2 ) == "#O" );
      for( j = 3; j <= Str.Length() && res; j++ )
      {
         res = ( Str[ j ] >= '0' && Str[ j ] <= '7' );
      }
      if( res )
      {
         for( j = 3; j <= Str.Length(); j++ )
         {
            x = x * 8 + Str[ j ] - 48;
         }
      }
   }
   return x;
}
//---------------------------------------------------------------------------------
int BinStrToInt( XString Str )
{
   bool res;
   int j, x;

   x = 0;
   Str = Str.UpperCase();
   if( Str.Length() > 2 )
   {
      res = ( Str.SubString( 1, 2 ) == "#B" );
      for( j = 3; j <= Str.Length() && res; j++ )
      {
         res = ( Str[ j ] == '0' || Str[ j ] == '1' );
      }
      if( res )
      {
         for( j = 3; j <= Str.Length(); j++ )
         {
            x = x * 2 + Str[ j ] - 48;
         }
      }
   }
   return x;
}
//---------------------------------------------------------------------------------
bool IsInteger( XString Str )
{
   int j, len, value;
   bool lCorrect = true;

   len = Str.Length();
   for( j = 1; j <= len && lCorrect; j++ )
   {
      if( ( Str[ j ] >= '0' && Str[ j ] <= '9' ) || ( j == 1 && Str[ j ] == '-' ) )
      {
      }
      else
      {
         lCorrect = false;
      }
   }
   return lCorrect;
}
//---------------------------------------------------------------------------------
bool IsDouble( XString Str )
{
   int j, len;
   bool lCorrect = true;
   bool lDot = false;
   char buf[ 10 ];

   if( Str.Length() > 0 )
   {
      len = Str.Length(); //(int)strlen( Buffer );
      for( j = 1; j <= len && lCorrect; j++ )
      {
         if( j == 0 && ( Str[ j ] == '-' || Str[ j ] == '+' ) )
         {
         }
         else if( Str[ j ] >= '0' && Str[ j ] <= '9' )
         {
         }
         else if( Str[ j ] == '.' ) //buf[ 0 ] )
         {
            if( !lDot )
            {
               lDot = true;
            }
            else
            {
               //MessageBox( 0, Buffer, "2", MB_OK );
               lCorrect = false;
            }
         }
         else
         {
            //MessageBox( 0, Buffer, "1", MB_OK );
            lCorrect = false;
         }
      }
   }
   else
   {
      lCorrect = false;
   }
   return lCorrect;
}
//---------------------------------------------------------------------------------
bool IsEDouble( XString Str )
{
   int j, len, e_pos;
   bool lCorrect = false;

   if( Str.Length() > 0 ) // Buffer )
   {
      len = Str.Length(); //strlen( Buffer );
      for( j = 1, e_pos = -1; j <= len && e_pos == -1; j++ )
      {
         if( Str[ j ] == 'E' || Str[ j ] == 'e' )
         {
            e_pos = j;
         }
      }
      if( e_pos > 1 && e_pos < len )
      {
         XString p1 = Str.SubString( 1, e_pos - 1 );
         XString p2 = Str.SubString( e_pos + 1, len );

         lCorrect = ( IsDouble( p1 ) && IsInteger( p2 ) );
         //MessageBox( 0, ( "[" + p1 + "] (" + ( p1.IsDouble() ? "OK" : "Err" ) + "), " +
         //                 "[" + p2 + "] (" + ( p2.IsInteger() ? "OK" : "Err" ) + ") = " +
         //                 ( lCorrect ? "OK" : "Err" ) ).c_str(), "XString", MB_OK );
      }
   }
   return lCorrect;
}
//---------------------------------------------------------------------------------
//} // end namespace XStrings
//---------------------------------------------------------------------------------

