#ifndef _ANSISTRING_H
#define _ANSISTRING_H

#include <stdio.h>
#include <string.h>
#ifdef __BORLANDC__
#include <vcl.h>
#endif

#ifdef __BORLANDC__
typedef AnsiString XString; // for Borland compatibilities
XString DoubleToStr( double Value, int Prec = -1 );
XString DoubleToStrF( double Value, int Prec = -1 );
XString DoubleToStrE( double Value, int Prec = -1 );
#else
class XString;
typedef XString AnsiString;

XString IntToStr( int Value );
XString FloatToStr( double Value );
XString DoubleToStr( double Value, int Prec = -1 );
XString DoubleToStrF( double Value, int Prec = -1 );
XString DoubleToStrE( double Value, int Prec = -1 );

//namespace XStrings
//{
//---------------------------------------------------------------------------------
class XString
{
    private:
    void EmptyBuffer( void );

    protected:
    char* Buffer;
    
    public:
    XString( void );
    XString( const char* FText );
    XString( const char* src, unsigned int len );
    XString( const char FChar );
    XString( const XString& FText );
    ~XString();
    
    int Length( void ) const;
    char* c_str( void ) const;
    int Pos( XString Template, int Start = 1 ) const;

    XString Insert( const XString& str, int pos );
    XString Delete( int index, int count );
    XString SubString( int index, int count ) const;
    XString UpperCase( void ) const;
    XString LowerCase( void ) const;
    XString Trim( void ) const;

    int ToInt( void ) const;
    double ToDouble( void ) const;
    
    const XString& operator=( const XString& val );
    const XString& operator=( const char* val );
    const XString& operator+=( const XString& val );
    const XString& operator+=( const char* val );
    const char operator[]( int index );
    
    operator const char*() { return (const char*)( Buffer ); }

    friend XString operator+( const XString& a, const XString& b );
    friend XString operator+( const XString& a, const char* b );
    friend XString operator+( const char* a, const XString& b );
    
    friend bool operator==( const XString& a, const XString& b );
    friend bool operator==( const char* a, const XString& b );
    friend bool operator==( const XString& a, const char* b );

    friend bool operator!=( const XString& a, const XString& b );
    friend bool operator!=( const char* a, const XString& b );
    friend bool operator!=( const XString& a, const char* b );

    friend bool operator>( const XString& a, const XString& b );
    friend bool operator>( const char* a, const XString& b );
    friend bool operator>( const XString& a, const char* b );

    friend bool operator>=( const XString& a, const XString& b );
    friend bool operator>=( const char* a, const XString& b );
    friend bool operator>=( const XString& a, const char* b );

    friend bool operator<( const XString& a, const XString& b );
    friend bool operator<( const char* a, const XString& b );
    friend bool operator<( const XString& a, const char* b );

    friend bool operator<=( const XString& a, const XString& b );
    friend bool operator<=( const char* a, const XString& b );
    friend bool operator<=( const XString& a, const char* b );

    #ifndef __BORLANDC__
    friend XString IntToStr( int Value );
    friend XString FloatToStr( double Value );
    #endif
    friend XString DoubleToStr( double Value, int Prec );
    friend XString DoubleToStrF( double Value, int Prec );
    friend XString DoubleToStrE( double Value, int Prec );

    bool IsEmpty() const { return Buffer == NULL; }
    bool IsInteger( void ) const;
    bool IsDouble( void ) const;
    bool IsEDouble( void ) const;
};
#endif
//---------------------------------------------------------------------------------
int strtrim( char* dst, const char* src );
int strpos( const char* str, char chr, int start = 0 );
//---------------------------------------------------------------------------------
double StrToDouble( XString Str );
int HexStrToInt( XString Str );
int OctStrToInt( XString Str );
int BinStrToInt( XString Str );
//---------------------------------------------------------------------------------
bool IsInteger( XString Str );
bool IsDouble( XString Str );
bool IsEDouble( XString Str );
//---------------------------------------------------------------------------------

//} // end namespace XString
//---------------------------------------------------------------------------------

#endif // _XString_H

