#include "atomlist.h"

#ifdef __WIN32__
#include "windows.h"
#endif
//------------------------------------------------------------------------------------------------
atomlist::atomlist( void )
   : _atoms( NULL ),
     _descs( NULL ),
     _count( 0 )
{
   //_atoms = NULL;
   //_descs = NULL;
   //_count = 0;
   //nullatom = new atom();
}
//------------------------------------------------------------------------------------------------
atomlist::~atomlist()
{
   clear();
}
//------------------------------------------------------------------------------------------------
void atomlist::clear( void )
{
   if( _atoms && _descs && _count )
   {
      int j;
      
      for( j = 0; j < _count; j++ )
      {
         delete _atoms[ j ];
         delete [] _descs[ j ];
      }
      delete [] _atoms;
      delete [] _descs;
      
      _atoms = NULL;
      _descs = NULL;
      _count = 0;
   }
}
//------------------------------------------------------------------------------------------------
void atomlist::addatom( atom* a, const char* name, const char* desc )
{
   atom** tmp;
   char** tmpdesc;
   int j;

   if( !a )
   {
      return;
   }

   tmp = new atom*[ _count + 1 ];
   tmpdesc = new char*[ _count + 1 ];
   if( _atoms && _descs && _count )
   {
      for( j = 0; j < _count; j++ )
      {
         tmp[ j ] = _atoms[ j ];
         tmpdesc[ j ] = _descs[ j ];
      }
      delete [] _atoms;
      delete [] _descs;
   }

   if( name )
   {
      a->setname( name );
   }

   if( desc )
   {
      int len = strlen( desc );
      tmpdesc[ _count ] = new char[ len + 1 ];
      memcpy( tmpdesc[ _count ], desc, len );
      tmpdesc[ _count ][ len ] = 0;
   }
   else
   {
      tmpdesc[ _count ] = NULL;
   }
   tmp[ _count ] = a;

   _count++;
   _atoms = tmp;
   _descs = tmpdesc;
}
//------------------------------------------------------------------------------------------------
void atomlist::replaceatom( int index, atom* a, 
                            const char* name, 
                            const char* desc )
{
   if( index >= 0 && index < _count && a )
   {
      delete _atoms[ index ];
      delete [] _descs[ index ];
      
      if( name )
      {
         a->setname( name );
      }
      _atoms[ index ] = a;
      if( desc )
      {
         unsigned int len = strlen( desc );
         _descs[ index ] = new char[ len + 1 ];
         memcpy( _descs[ index ], desc, len );
         _descs[ index ][ len ] = 0;
      }
      else
      {
         _descs[ index ] = NULL;
      }
   }
}
//------------------------------------------------------------------------------------------------
void atomlist::delatom( int index )
{
   atom** tmp;
   char** tmpdesc;
   int i, j;

   if( index >= 0 && index < _count )
   {
      if( _count == 1 )
      {
         clear();
      }
      else
      {
         tmp = new atom*[ _count - 1 ];
         tmpdesc = new char*[ _count - 1 ];
         for( j = 0, i = 0; j < _count; j++ )
         {
            if( j != index )
            {
               tmp[ i ] = _atoms[ j ];
               tmpdesc[ i ] = _descs[ j ];
               i++;
            }
         }
         delete [] _atoms;
         delete [] _descs;
         
         _atoms = tmp;
         _descs = tmpdesc;
         _count--;
      }
   }
}
//------------------------------------------------------------------------------------------------
atom& atomlist::operator[]( int index )
{
   if( index >= 0 && index < _count && _atoms )
   {
      return *( _atoms[ index ] );
   }
   else
   {
      return nullatom;
   }
}
//------------------------------------------------------------------------------------------------
atom& atomlist::getAtom( int index )
{
   if( index >= 0 && index < _count && _atoms )
   {
      return *( _atoms[ index ] );
   }
   else
   {
      return nullatom;
   }
}
//------------------------------------------------------------------------------------------------
atom& atomlist::atomByName( const char* name )
{
   int index;

   index = findAtom( name );
   if( index != -1 )
   {
      return *( _atoms[ index ] );
   }
   return nullatom;
}
//------------------------------------------------------------------------------------------------
int atomlist::findAtom( const char* name, bool casesens )
{
   int j;
   int index = -1;

   if( name )
   {
      for( j = 0; j < _count && index == -1; j++ )
      {
         if( strcmp( name, _atoms[ j ]->name() ) == 0 )
         {
            index = j;
         }
      }
   }
   return index;
}
//------------------------------------------------------------------------------------------------
char* atomlist::getDesc( int Index )
{
   char* buf = NULL;
   
   if( Index >= 0 && Index < _count )
   {
      buf = _descs[ Index ];
   }
   return buf;
}
//------------------------------------------------------------------------------------------------

