#ifndef _ATOMLIST_H
#define _ATOMLIST_H

#include "atom.h"

//------------------------------------------------------------------------------------------------
class atomlist
{
   private:
   atom** _atoms;
   char** _descs;
   int _count;
   
   public:
   atomlist( void );
   ~atomlist();
   
   int count( void ) { return _count; }
   atom& operator[]( int index );
   
   void clear( void );
   void addatom( atom* a, const char* name = NULL, const char* desc = NULL );
	void replaceatom( int index, atom* a, const char* name = NULL, const char* desc = NULL );
   void delatom( int index );
   atom& getAtom( int index );
   atom& atomByName( const char* name );
   int findAtom( const char* name, bool casesens = true );
   
   char* getDesc( int Index );
};
//------------------------------------------------------------------------------------------------
#endif // _ATOMLIST_H

