#include <stdio.h>
#include <stdarg.h>
#include <math.h>
#include <errno.h>

#ifdef _WIN32
#include <windows.h>
#endif

#include "primes.h"
#include "atomutil.h"

//------------------------------------------------------------------------------------------------
double StrToDouble( const char* Value )
{
   double sign = 1.0;
   double x1 = 0.0;
   double x2 = 0.0;
   int pos;
   int len;
   double dec;
   bool lExit;
   bool lError = false;
   char buf[ 100 ];
   
   strtrim( buf, Value );
   //Value = Value.Trim();
   len = strlen( buf );
   if( len == 0 )
   {
      lError = true;
   }
   
   pos = 0;
   lExit = false;
   while( !lExit && !lError )
   {
      if( buf[ pos ] == '\0' )
      {
         lExit = true;
      }
      else
      {
         if( buf[ pos ] >= '0' && buf[ pos ] <= '9' )
         {
            x1 = ( x1 * 10.0 ) + (double)( buf[ pos ] - 48 );
         }
         else if( buf[ pos ] == '.' )//|| buf[ pos ] == ',' )
         {
            lExit = true;
         }
         else if( pos == 0 && buf[ 0 ] == '-' )
         {
            sign = -1.0;
         }
         else
         {
            lError = true;
         }
         pos++;
      }
   }

   lExit = false;
   dec = 10.0;
   while( !lExit && !lError )
   {
      if( buf[ pos ] == '\0' ) //pos > Value.Length() )
      {
         lExit = true;
      }
      else
      {
         if( buf[ pos ] >= '0' && buf[ pos ] <= '9' )
         {
            x2 += ( (double)( buf[ pos ] - 48 ) / dec );
            dec *= 10.0;
         }
         else
         {
            lError = true;
         }
         pos++;
      }
   }
   return sign * ( x1 + x2 );
}
//------------------------------------------------------------------------------------------------
double StrEToDouble( const char* Value )
{
   char buf[ 100 ];
   char b1[ 100 ];
   char b2[ 100 ];
   int j, e_pos, len;
   double res, mant;
   int expo;
   bool lError = false;
   
   strtrim( buf, Value );
   len = strlen( buf );
   if( len == 0 )
   {
      lError = true;
   }
   
   if( !lError )
   {
      for( j = 0, e_pos = -1; j < len && e_pos == -1; j++ )
      {
         if( buf[ j ] == 'E' || buf[ j ] == 'e' )
         {
            e_pos = j;
         }
      }
      if( e_pos == -1 )
      {
         lError = true;
      }
   }
   if( !lError && e_pos > 0 && e_pos < len - 1 )
   {
      strncpy( b1, buf, e_pos );
      b1[ e_pos ] = '\0';
      strcpy( b2, buf + e_pos + 1 );
      
      if( isdoublestr( b1 ) && isnumericstr( b2 ) )
      {
         mant = StrToDouble( b1 );
         expo = AnsiString( b2 ).ToInt();

         res = mant * pow( 10.0, (double)expo );
      }
      else
      {
         res = 0.0;
      }
   }
   else
   {
      res = 0.0;
   }
   return res;
}
//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------
/*
AnsiString DoubleToStrE( double Value, int prec )
{
   AnsiString p;
   double mant;
   double sign;
   int expo;
   
   mant = Value;
   expo = 0;
   if( mant < 0.0 )
   {
      sign = -1.0;
      mant = -mant;
   }
   else
   {
      sign = 1.0;
   }
   
   if( mant >= 10.0 )
   {
      while( mant >= 10.0 )
      {
         mant /= 10.0;
         expo++;
      }
   }
   else if( mant < 1.0 )
   {
      while( mant < 1.0 )
      {
         mant *= 10.0;
         expo--;
      }
   }
   if( mant >= 1.0 && mant < 10.0 )
   {
      p = DoubleToStr( dround( sign * mant, prec ) ) + "E" + IntToStr( expo );
   }
   else
   {
      p = DoubleToStr( dround( sign * mant, prec ) );
   }
   return p;
}
*/
//------------------------------------------------------------------------------------------------
bool isnumericstr( const char* str )
{
   bool res;
   int len = strlen( str );
   if( len > 0 )
   {
      int j;
      for( j = 0, res = true; j < len && res; j++ )
      {
         if( str[ j ] >= '0' && str[ j ] <= '9' )
         {
         }
         else if( j == 0 && ( str[ j ] == '-' || str[ j ] == '+' ) )
         {
         }
         else
         {
            res = false;
         }
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isintstr( const char* str )
{
   return isnumericstr( str ) || ishexstr( str ) || isoctstr( str ) || isbinstr( str );
}
//-----------------------------------------------------------------------------
bool ishexstr( const char* str )
{
   bool res;
   int len = strlen( str );
   if( len > 2 )
   {
      int j;
      res = ( !strncmp( str, "#h", 2 ) || !strncmp( str, "#H", 2 ) );
      
      for( j = 2; j < len && res; j++ )
      {
         res = ( ( str[ j ] >= '0' && str[ j ] <= '9' ) ||
                 ( str[ j ] >= 'A' && str[ j ] <= 'F' ) ||
                 ( str[ j ] >= 'a' && str[ j ] <= 'f' )
               );
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isoctstr( const char* str )
{
   bool res;
   int len = strlen( str );
   if( len > 2 )
   {
      int j;
      res = ( !strncmp( str, "#o", 2 ) || !strncmp( str, "#O", 2 ) );
      for( j = 2; j < len && res; j++ )
      {
         res = ( str[ j ] >= '0' && str[ j ] <= '7' );
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isbinstr( const char* str )
{
   bool res;
   int len = strlen( str );
   if( len > 2 )
   {
      int j;
      res = ( !strncmp( str, "#b", 2 ) || !strncmp( str, "#B", 2 ) );
      for( j = 2; j < len && res; j++ )
      {
         res = ( str[ j ] == '0' || str[ j ] == '1' );
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isdoublestr( const char* str )
{
   bool res;
   int len = strlen( str );
   if( len > 0 )
   {
      int j;
      bool dot = false;
      
      for( j = 0, res = true; j < len && res; j++ )
      {
         if( str[ j ] >= '0' && str[ j ] <= '9' )
         {
         }
         else if( j == 0 && str[ j ] == '-' )
         {
         }
         else if( str[ j ] == '.' )
         {
            if( !dot )
            {
               dot = true;
            }
            else
            {
               res = false;
            }
         }
         else
         {
            res = false;
         }
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isexponentstr( const char* str )
{
   bool res;
   
   if( str )
   {
      int j, len, e_pos;
      
      len = strlen( str );
      for( j = 0, e_pos = -1; j < len && e_pos == -1; j++ )
      {
         if( str[ j ] == 'E' || str[ j ] == 'e' )
         {
            e_pos = j;
         }
      }
      if( e_pos > 0 && e_pos < len - 1 )
      {
         char b1[ 100 ];
         char b2[ 100 ];
         
         strncpy( b1, str, e_pos );
         b1[ e_pos ] = '\0';
         strcpy( b2, str + e_pos + 1 );
         res = ( isdoublestr( b1 ) && isnumericstr( b2 ) );
      }
      else
      {
         res = false;
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isrealstr( const char* str )
{
   return isdoublestr( str ) || isexponentstr( str );
}
//-----------------------------------------------------------------------------
bool iscomplexstr( const char* str )
{
   bool res = false;
   char buf[ 100 ];
   int len;
   
   len = strlen( str );
   if( len >= 5 )
   {
      int sep;
      
      sep = strpos( str, ';' );
      if( sep == -1 )
      {
         sep = strpos( str, ',' );
      }

      if( str[ 0 ] == '(' && str[ len - 1 ] == ')' && sep > 0 && sep < len - 1 )
      {
         char cre[ 100 ];
         char cim[ 100 ];

         strncpy( cre, str + 1, sep - 1 );
         cre[ sep - 1 ] = '\0';
         if( str[ len - 2 ] == 'i' )
         {
            strncpy( cim, str + sep + 1, len - sep - 3 );
            cim[ len - sep - 3 ] = '\0';
         }
         else
         {
            strncpy( cim, str + sep + 1, len - sep - 2 );
            cim[ len - sep - 2 ] = '\0';
         }
         
         res = (
                 ( isdoublestr( cre ) || isexponentstr( cre ) )
                 &&
                 ( isdoublestr( cim ) || isexponentstr( cim ) )
               );
      }
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isstringstr( const char* str )
{
   bool res = false;
   int len = strlen( str );
   
   if( len )
   {
      if( str[ 0 ] == '\"' && str[ len - 1 ] == '\"' )
      {
         res = true;
      }
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isexprstr( const char* str )
{
   bool res = false;
   int len = strlen( str );
   
   if( len )
   {
      if( str[ 0 ] == '\'' && str[ len - 1 ] == '\'' )
      {
         res = true;
      }
   }
   return res;
}
//-----------------------------------------------------------------------------
bool issymbolstr( const char* str )
{
   bool res = true;
   unsigned int j;

   if( str )
   {
      for( j = 0; j < strlen( str ); j++ )
      {
         if( ( str[ j ] >= 'a' && str[ j ] <= 'z' ) || ( str[ j ] >= 'A' && str[ j ] <= 'Z' ) )
         {
         }
         else
         {
            res = false;
         }
      }
   }
   else
   {
      res = false;
   }
   return res;
}
//-----------------------------------------------------------------------------
bool isvectorstr( const char* str )
{ 
   bool res = false;
   int len = strlen( str );
   
   if( len > 2 )
   {
      #ifndef __BORLANDC__
      if( str[ 0 ] == '[' && str[ 1 ] != '[' && str[ len - 1 ] == ']' and str[ len - 2 ] != ']' )
      {
         res = true;
      }
      #endif
   }
   return res;
}
//-----------------------------------------------------------------------------
bool ismatrixstr( const char* str )
{
   bool res = false;
   int len = strlen( str );

   if( len > 4 )
   {
      #ifndef __BORLANDC__
      if( str[ 0 ] == '[' && str[ 1 ] == '[' && str[ len - 1 ] == ']' and str[ len - 2 ] == ']' )
      {
         res = true;
      }
      #endif
   }
   return res;
}
//-----------------------------------------------------------------------------
bool ismeasurestr( const char* str )
{
   bool res = false;
   char buf1[ 100 ];
   char buf2[ 100 ];

   int len = strlen( str );
   int pos = strpos( str, '_' );

   if( len > 1 && pos != -1 )
   {
      strncpy( buf1, str, pos );
      buf1[ pos ] = '\0';
      res = ( ( isdoublestr( buf1 ) || isexponentstr( buf1 ) ) && pos < len - 1 );
   }
   return res;
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//  gamma.cpp -- computation of gamma function.
//      Algorithms and coefficient values from "Computation of Special
//      Functions", Zhang and Jin, John Wiley and Sons, 1996.
//
//  (C) 2003, C. Bond. All rights reserved.
//
// Returns gamma function of argument 'x'.
//
// NOTE: Returns 1e308 if argument is a negative integer or 0,
//      or if argument exceeds 171.
//
//-----------------------------------------------------------------------------
double gamma( double x )
{
    int i,k,m;
    double ga,gr,r,z;

    static double g[] = {
        1.0,
        0.5772156649015329,
       -0.6558780715202538,
       -0.420026350340952e-1,
        0.1665386113822915,
       -0.421977345555443e-1,
       -0.9621971527877e-2,
        0.7218943246663e-2,
       -0.11651675918591e-2,
       -0.2152416741149e-3,
        0.1280502823882e-3,
       -0.201348547807e-4,
       -0.12504934821e-5,
        0.1133027232e-5,
       -0.2056338417e-6,
        0.6116095e-8,
        0.50020075e-8,
       -0.11812746e-8,
        0.1043427e-9,
        0.77823e-11,
       -0.36968e-11,
        0.51e-12,
       -0.206e-13,
       -0.54e-14,
        0.14e-14};

    if (x > 171.0) return 1e308;    // This value is an overflow flag.
    if (x == (int)x) {
        if (x > 0.0) {
            ga = 1.0;               // use factorial
            for (i=2;i<x;i++) {
               ga *= i;
            }
         }
         else
            ga = 1e308;
     }
     else {
        if (fabs(x) > 1.0) {
            z = fabs(x);
            m = (int)z;
            r = 1.0;
            for (k=1;k<=m;k++) {
                r *= (z-k);
            }
            z -= m;
        }
        else
            z = x;
        gr = g[24];
        for (k=23;k>=0;k--) {
            gr = gr*z+g[k];
        }
        ga = 1.0/(gr*z);
        if (fabs(x) > 1.0) {
            ga *= r;
            if (x < 0.0) {
                ga = -M_PI/(x*ga*sin(M_PI*x));
            }
        }
    }
    return ga;
}
//-----------------------------------------------------------------------------
// psi.cpp -- psi function for real arguments.
//      Algorithms and coefficient values from "Computation of Special
//      Functions", Zhang and Jin, John Wiley and Sons, 1996.
//
//  (C) 2003, C. Bond. All rights reserved.
//
//  Returns psi function for real argument 'x'.
//  NOTE: Returns 1e308 for argument 0 or a negative integer.
//
#define el 0.5772156649015329

double psi( double x )
{
    double s,ps,xa,x2;
    int n,k;
    static double a[] = {
        -0.8333333333333e-01,
         0.83333333333333333e-02,
        -0.39682539682539683e-02,
         0.41666666666666667e-02,
        -0.75757575757575758e-02,
         0.21092796092796093e-01,
        -0.83333333333333333e-01,
         0.4432598039215686};

    xa = fabs(x);
    s = 0.0;
    if ((x == (int)x) && (x <= 0.0)) {
        ps = 1e308;
        return ps;
    }
    if (xa == (int)xa) {
        n = (int)xa;
        for (k=1;k<n;k++) {
            s += 1.0/k;
        }
        ps =  s-el;
    }
    else if ((xa+0.5) == ((int)(xa+0.5))) {
        n = (int)( xa-0.5 );
        for (k=1;k<=n;k++) {
            s += 1.0/(2.0*k-1.0);
        }
        ps = 2.0*s-el-1.386294361119891;
    }
    else {
        if (xa < 10.0) {
            n = 10-(int)xa;
            for (k=0;k<n;k++) {
                s += 1.0/(xa+k);
            }
            xa += n;
        }
        x2 = 1.0/(xa*xa);
        ps = log(xa)-0.5/xa+x2*(((((((a[7]*x2+a[6])*x2+a[5])*x2+
            a[4])*x2+a[3])*x2+a[2])*x2+a[1])*x2+a[0]);
        ps -= s;
    }
    if (x < 0.0)
        ps = ps - M_PI*cos(M_PI*x)/sin(M_PI*x)-1.0/x;
        return ps;
}
//---------------------------------------------------------------------------
//
// Few financial functions
//
//---------------------------------------------------------------------------
double fin_fv( double N, double I, double PV, double PMT, double M, double G )
{
   double x;

   x = -PV * pow( ( 1.0 + I / 100.0 ), ( M + N ) ) + ( ( PMT + G / ( I / 100.0 ) ) * ( pow( ( 1.0 + I / 100.0 ), N ) - 1.0 )- G * N ) / ( I / 100.0 );

   return x;
}
//---------------------------------------------------------------------------
double fin_pmt( double N, double I, double PV, double FV, double M, double G )
{
   double x;

   x = ( ( -FV - PV * pow( ( 1.0 + I / 100.0 ), ( M + N ) ) ) *  ( I / 100.0 ) + G * N ) /  ( pow( ( 1.0 + I / 100.0 ), N ) - 1.0 ) - G / ( I / 100.0 );

   return x;
}
//---------------------------------------------------------------------------
double fin_pv( double N, double I, double FV, double PMT, double M, double G )
{
   double x;

   x =  ( -( ( PMT + G / ( I / 100.0 ) ) * ( pow( ( 1.0 + I / 100.0 ), N ) - 1.0 ) - G * N ) / ( I / 100.0 ) - FV ) / pow( ( 1.0 + I / 100.0 ), ( M + N ) );

   return x;
}
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
//
// Extended: pval * pow( 1 + rate/100.0, nper ) + paymt * ( 1 + (rate/100.0) * ptype ) * ( pow( 1 + (rate/100.0), nper ) - 1 ) / (rate/100.0) + fval = 0
//
//---------------------------------------------------------------------------
double finance_fvex( double nper, double rate, double pval, double paymt, double ptype )
{
   double fval;

   fval = -pval * pow( 1 + rate/100.0, nper ) - paymt * ( 1 + (rate/100.0) * ptype ) * ( pow( 1 + rate/100.0, nper ) - 1 ) / ( rate / 100.0 );

   return fval;
}
//---------------------------------------------------------------------------
double finance_pvex( double nper, double rate, double fval, double paymt, double ptype )
{
   double pval;

   pval = ( - paymt * ( 1 + (rate/100.0) * ptype ) * ( pow( 1 + rate/100.0, nper ) - 1 ) / (rate/100.0) - fval ) / pow( 1 + rate/100.0, nper );

   return pval;
}
//---------------------------------------------------------------------------
double finance_paymtex( double nper, double rate, double pval, double fval, double ptype )
{
   double paymt;

   paymt = ( ( -fval - pval * pow( ( 1 + rate/100.0 ), nper ) ) *  ( rate/100.0 ) ) /  ( ( 1 + (rate/100.0) * ptype ) * ( pow( ( 1.0 + rate/100.0 ), nper ) - 1.0 ) );
   return paymt;
}
//-----------------------------------------------------------------------------
double finance_nper( double rate, double paymt, double pval, double fval, double ptype )
{
   double nper;
 
   nper = log10((paymt*(1+(rate/100.0)*ptype)-fval*(rate/100.0))/(paymt*(1+(rate/100.0)*ptype)+pval*(rate/100.0)))/
          log10(1+(rate/100.0));
   return nper;
}   
//-----------------------------------------------------------------------------
double finance_rate( double nper, double paymt, double pval, double fval, double ptype )
{
   // Start with an arbitrary 1% Interest rate
   double IntRate = 1.00 / 1200.00;

   if( pval < 0.0 )
   {
      pval *= -1.0;
   }
   if( paymt > 0.0 )
   {
      paymt *= -1.0;
   }

   double iPer = log((paymt + paymt*IntRate*ptype - fval*IntRate) /
                 (pval*IntRate + paymt + paymt*IntRate*ptype) ) /
                 log (1 + IntRate);

   if( iPer > nper )
   {
      while( iPer > nper )
      {
         IntRate -= 0.000001;
         iPer = log((paymt + paymt*IntRate*ptype - fval*IntRate) /
                    (pval*IntRate + paymt + paymt*IntRate*ptype) ) /
                log (1 + IntRate);
      }
   }
   else
   {
      while( iPer < nper )
      {
         IntRate += 0.000001;
         iPer = log((paymt + paymt*IntRate*ptype - fval*IntRate) /
                    (pval*IntRate + paymt + paymt*IntRate*ptype) ) /
                log (1 + IntRate);
      }
   }
   return IntRate * 1200.00;
}         
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Return the logarithm of x to the base n.
//---------------------------------------------------------------------------
double logn( double x, double n )
{
  errno = 0;
  double log_x = log(x);
  if( errno == ERANGE )
  {
     return log_x;    // should be HUGE_VAL
  }   
  else if( errno != 0 )
  {
     return log_x;    // implementation defined
  }
     
  double log_n = log( n );
  if( errno == ERANGE )
  {
     return log_n;    // should be HUGE_VAL
  }   
  else if( errno != 0 )
  {
     return log_n;    // implementation defined
  }   
  if( log_n == 0 ) 
  {
     errno = EDOM;
     return 0;
  }
  return ( log_x / log_n );
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
double dround( const double x, int prec )
{
    int i;
    double j = 1.0;
    double res, f;
    double sign;

    sign = ( x < 0.0 ? -1.0 : 1.0 );

    for( i = 0; i < prec; i++ )
    {
        j *= 10.0;
    }

    res = x * j * sign;
    f = fmod( res, 1.0 );
    res -= f;
    if( f >= 0.5 )
    {
      res += 1.00;
    }

    res = ( j != 0.0 ? sign * ( res / j ) : 0.0 );

    return res;
}
//-----------------------------------------------------------------------------
AnsiString bin2str( int value )
{
   AnsiString p;
   int x;
   
   if( value > 0 )
   {
      x = value;
      p = "";
      while( x )
      {
         p = IntToStr( x % 2 ) + p;
         x = x / 2;
      }
   }
   else
   {
      p = "0";
   }
   return p;
}
//-----------------------------------------------------------------------------
AnsiString oct2str( int value )
{
   AnsiString p;
   int x;

   if( value > 0 )
   {
      x = value;
      p = "";
      while( x )
      {
         p = IntToStr( x % 8 ) + p;
         x = x / 8;
      }
   }
   else
   {
      p += "0";
   }
   return p;
}
//-----------------------------------------------------------------------------
#ifndef __YACAS__
unsigned primes_table_check( unsigned long p )
{
	unsigned long index;
	unsigned field;
	if (p==0) return primes_table_limit;
	if (p==2) return 1;
	if (p<2 || p>primes_table_limit || (p & 1) == 0) return 0;
	p >>= 1;
	// get index in 8-bit chunks
	index = p >> 3;
	field = p & 7;
	return ((primes_table[index] & (1 << field))==0) ? 0 : 1;
}
#endif
//-----------------------------------------------------------------------------
bool isprimenumber( int value )
{
   return ( primes_table_check( value ) == 1 );
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//
//
//
//-----------------------------------------------------------------------------
void MsgBox( AnsiString Message, int Params )
{
   #ifdef _WIN32
   if( !Params )
   {
      Params = MB_OK;
   }
   MessageBox( 0, Message.c_str(), "AStack", Params );
   #endif
}
//-----------------------------------------------------------------------------

