#ifndef _ATOMUTIL_H
#define _ATOMUTIL_H

//#include <astring.h>
#include <acomplex.h>
//------------------------------------------------------------------------------------------------
bool isnumericstr( const char* str );
bool isintstr( const char* str );
bool ishexstr( const char* str );
bool isoctstr( const char* str );
bool isbinstr( const char* str );
bool isdoublestr( const char* str );
bool isexponentstr( const char* str );
bool isrealstr( const char* str );
bool iscomplexstr( const char* str );
bool isstringstr( const char* str );
bool isexprstr( const char* str );
bool issymbolstr( const char* str );
bool isvectorstr( const char* str );
bool ismatrixstr( const char* str );
bool ismeasurestr( const char* str );
//-----------------------------------------------------------------------------
bool isprimenumber( int value );
//-----------------------------------------------------------------------------
double gamma( double x );
double psi( double x );
//----------Financial functions -------------------------------------------------------------------
double fin_fv( double N, double I, double PV, double PMT = 0.0, double M = 0.0, double G = 0.0 );
double fin_pmt( double N, double I, double PV, double FV = 0.0, double M = 0.0, double G = 0.0 );
double fin_pv( double N, double I, double FV, double PMT = 0.0, double M = 0.0, double G = 0.0 );
//------------------------------------------------------------------------------------------------
// Extended financial functions
//------------------------------------------------------------------------------------------------
double finance_fvex( double nper, double rate, double pval, double paymt, double ptype = 0.0 );
double finance_pvex( double nper, double rate, double fval, double paymt, double ptype = 0.0 );
double finance_paymtex( double nper, double rate, double pval, double fval, double ptype = 0.0 );
double finance_nper( double rate, double paymt, double pval, double fval, double ptype = 0.0 );
double finance_rate( double nper, double paymt, double pval, double fval, double ptype = 0.0 );
//------------------------------------------------------------------------------------------------
// Return the logarithm of x to the base n.
//------------------------------------------------------------------------------------------------
double logn( double x, double n );
//------------------------------------------------------------------------------------------------
double dround( const double x, int prec );
double StrToDouble( const char* Value );
double StrEToDouble( const char* Value );
//------------------------------------------------------------------------------------------------
//AnsiString DoubleToStrE( double Value, int prec = 6 );
//------------------------------------------------------------------------------------------------
AnsiString bin2str( int value );
AnsiString oct2str( int value );
unsigned primes_table_check( unsigned long p );
//------------------------------------------------------------------------------------------------
void MsgBox( AnsiString Message, int Params = 0 );
//------------------------------------------------------------------------------------------------
#endif // _ATOMUTIL_H
