#include "keycodetr.h"

TKeyCodesTr KeyCodesTr[] =
   { // { WinCode, LinuxCode }
   {   8, 4099 }, // BACKSPACE
   {  13, 4100 }, // ENTER
   //{  13, 4101 }, // NUMPAD ENTER
   {  16, 4128 }, // LEFT SHIFT
   {  17, 4129 }, // LEFT CTRL
   {  18, 4131 }, // LEFT ALT
   {  27, 4096 }, // ESC
   {  37, 4114 }, // LEFT ARROW
   {  38, 4115 }, // UP ARROW
   {  39, 4116 }, // RIGHT ARROW
   {  40, 4117 }, // DOWN ARROW
   { 106, 42 }, // MULTIPLICATION
   { 107, 43 }, // ADDITION
   { 109, 45 }, // SUBTRACTION
   { 111, 47 }, // DIVIDE
   { 110, 4103 }, // NUMERIC DOT
   { 32, 32 }, // SPACE
   {  96, 48 }, // 0
   {  97, 49 }, // 1
   {  98, 50 }, // 2
   {  99, 51 }, // 3
   { 100, 52 }, // 4
   { 101, 53 }, // 5
   { 102, 54 }, // 6
   { 103, 55 }, // 7
   { 104, 56 }, // 8
   { 105, 57 }, // 8
	{ 192, 96 }, // ~
   { -1, -1 }
   };


int WinKeyToLinux( int keycode )
{
   int x = -1;
   int j = 0;

   while( KeyCodesTr[ j ].wincode != -1 && x == -1 )
   {
      if( KeyCodesTr[ j ].wincode == keycode )
      {
         x = KeyCodesTr[ j ].linuxcode;
      }
      else
      {
         j++;
      }
   }
   return x;
}

int LinuxKeyToWin( int keycode )
{
   int x = -1;
   int j = 0;

   while( KeyCodesTr[ j ].linuxcode != -1 && x == -1 )
   {
      if( KeyCodesTr[ j ].linuxcode == keycode )
      {
         x = KeyCodesTr[ j ].wincode;
      }
      else
      {
         j++;
      }
   }
   return x;
}
