//---------------------------------------------------------------------------

#ifdef __BORLANDC__
#include <dir.h>
#include <vcl.h>
#else
//#include <io.h>
#endif

#include <astring.h>
//#pragma hdrstop

#include "pgxml.h"

//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
xmlattr::xmlattr( void )
{
   FName = "";
   FValue = "";
   FType = xmlaNone;
}
//---------------------------------------------------------------------------
xmlattr::xmlattr( AnsiString AName, AnsiString AValue )
{
   FName = AName;
   setValue( AValue );
}
//---------------------------------------------------------------------------
xmlattr::xmlattr( AnsiString AString )
{
   AnsiString p = AString;

   if( p.Length() > 0 )
   {
      int pos = p.Pos( "=" );
      if( pos )
      {
         FName = p.SubString( 1, pos - 1 );
         setValue( p.SubString( pos + 1, p.Length() ) );
      }
      else
      {
         FName = p;
         FValue = "";
         FType = xmlaNone;
      }
   }
}
//---------------------------------------------------------------------------
xmlattr::xmlattr( const xmlattr& ASource )
{
   FName = ASource.FName;
   setValue( ASource.FValue );
}
//---------------------------------------------------------------------------
xmlattr::xmlattr( xmlattr* ASource )
{
   if( ASource )
   {
      FName = ASource->FName;
      setValue( ASource->FValue );
   }
   else
   {
      FName = "";
      FValue = "";
      FType = xmlaNone;
   }
}
//---------------------------------------------------------------------------
xmlattr::~xmlattr()
{
}
//---------------------------------------------------------------------------
xmlattr& xmlattr::operator=( const xmlattr& source )
{
   FName = source.FName;
   FValue = source.FValue;
   FType = source.FType;

   return *this;
}
//---------------------------------------------------------------------------
void xmlattr::setValue( AnsiString AValue )
{
   int j;
   char z;

   AValue = AValue.Trim();
   FValue = "";
   for( j = 1; j <= AValue.Length(); j++ )
   {
      z = AValue[ j ];
      if( ( j == 1 || j == AValue.Length() ) && z == '\"' )
      {
      }
      else
      {
         FValue += AnsiString( z );
      }
   }
   setType();
}
//---------------------------------------------------------------------------
void xmlattr::setType( void )
{
   int j;
   int type;
   char z;
   bool lDot = false;

   if( FValue.UpperCase() == "TRUE" || FValue.UpperCase() == "FALSE" )
   {
      type = ( xmlaString | xmlaBoolean );
   }
   else
   {
      type = xmlaAllNB;

      for( j = 1; j <= FValue.Length() && type == xmlaAllNB; j++ )
      {
         z = FValue[ j ];
         if( z == '-' && j == 1 )
         {
         }
         else if( z >= '0' && z <= '9' )
         {
         }
         else if( z == '.' && !lDot )
         {
            type -= xmlaInteger;
            lDot = true;
         }
         else
         {
            type = xmlaString;
         }
      }
   }
   FType = type;
}
//---------------------------------------------------------------------------
AnsiString xmlattr::getTypeStr( void )
{
   AnsiString p = "";

   p += ( FType & xmlaString ? "S" : "-" );
   p += ( FType & xmlaInteger ? "I" : "-" );
   p += ( FType & xmlaDouble ? "D" : "-" );
   p += ( FType & xmlaBoolean ? "B" : "-" );

   return p;
}
//---------------------------------------------------------------------------
int xmlattr::getAsInteger( void )
{
   int value;

   if( FType == xmlaInteger )
   {
      value = FValue.ToInt();
   }
   else if( FType == xmlaDouble )
   {
      value = (int)( FValue.ToDouble() );
   }
   else if( FType == xmlaBoolean )
   {
      value = ( FValue.UpperCase() == "TRUE" ? 1 : 0 );
   }
   else
   {
      value = 0;
   }
   return value;
}
//---------------------------------------------------------------------------
double xmlattr::getAsDouble( void )
{
   double value;

   if( FType == xmlaInteger )
   {
      value = (double)( FValue.ToInt() );
   }
   else if( FType == xmlaDouble )
   {
      value = FValue.ToDouble();
   }
   else if( FType == xmlaBoolean )
   {
      value = ( FValue.UpperCase() == "TRUE" ? 1.0 : 0.0 );
   }
   else
   {
      value = 0.0;
   }
   return value;
}
//---------------------------------------------------------------------------
bool xmlattr::getAsBoolean( void )
{
   bool value;

   if( FType == xmlaInteger )
   {
      value = ( FValue.ToInt() != 0 ? true : false );
   }
   else if( FType == xmlaDouble )
   {
      value = ( FValue.ToDouble() != 0.0 ? true : false );
   }
   else if( FType == xmlaBoolean )
   {
      value = ( FValue.UpperCase() == "TRUE" ? true : false );
   }
   else
   {
      value = false;
   }
   return value;
}
//---------------------------------------------------------------------------
AnsiString xmlattr::getAsString( void )
{
   return FValue;
}
//---------------------------------------------------------------------------
static xmlattr __NULL_XML_Attr__;
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
xmlnode::xmlnode( void )
   : pnode( NULL )
{
   FName = "";
   FValue = "";
   FAttr = NULL;
   FAttrCount = 0;
}
//---------------------------------------------------------------------------
xmlnode::xmlnode( AnsiString AName, AnsiString AValue )
   : pnode( AName.c_str() )
{
   FName = AName;
   FValue = AValue;
   FAttr = NULL;
   FAttrCount = 0;
}
//---------------------------------------------------------------------------
xmlnode::~xmlnode()
{
   clearAttr();
}
//---------------------------------------------------------------------------
void xmlnode::clearAttr( void )
{
   if( FAttr && FAttrCount )
   {
      int j;

      for( j = 0; j < FAttrCount; j++ )
      {
         delete FAttr[ j ];
      }
      delete [] FAttr;
      FAttr = NULL;
      FAttrCount = 0;
   }
}
//---------------------------------------------------------------------------
void xmlnode::addAttr( xmlattr* Attr )
{
   xmlattr** tmp;
   int j;

   if( Attr )
   {
      if( !findAttr( Attr->getName() ) )
      {
         tmp = new xmlattr*[ FAttrCount + 1 ];
         if( FAttrCount > 0 )
         {
            for( j = 0; j < FAttrCount; j++ )
            {
               tmp[ j ] = FAttr[ j ];
            }
            delete [] FAttr;
         }
         tmp[ FAttrCount ] = Attr;
         FAttr = tmp;
         FAttrCount++;
      }
   }
}
//---------------------------------------------------------------------------
xmlattr* xmlnode::addAttr( AnsiString AName, AnsiString AValue )
{
   xmlattr* a = NULL;

   if( !findAttr( AName ) )
   {
      a = new xmlattr( AName, AValue );
      addAttr( a );
   }
   return a;
}
//---------------------------------------------------------------------------
AnsiString xmlnode::getName( void )
{
   return FName;
}
//---------------------------------------------------------------------------
AnsiString xmlnode::getValue( void )
{
   return FValue;
}
//---------------------------------------------------------------------------
void xmlnode::setName( AnsiString Value )
{
   FName = Value;
}
//---------------------------------------------------------------------------
void xmlnode::setValue( AnsiString Value )
{
   FValue = Value;
}
//---------------------------------------------------------------------------
void xmlnode::clear( void )
{
   clearAttr();
   pnode::clear();
}
//---------------------------------------------------------------------------
xmlattr* xmlnode::findAttr( AnsiString AName )
{
   int j;
   xmlattr* a = NULL;

   for( j = 0; j < FAttrCount && !a; j++ )
   {
      if( FAttr[ j ]->getName() == AName )
      {
         a = FAttr[ j ];
      }
   }
   return a;
}
//---------------------------------------------------------------------------
xmlattr* xmlnode::getAttr( int index )
{
   xmlattr* a = NULL;

   if( FAttr && index >= 0 && index < FAttrCount )
   {
      a = FAttr[ index ];
   }
   return a;
}
//---------------------------------------------------------------------------
xmlattr* xmlnode::setAttrValue( AnsiString AName, AnsiString AValue, bool AllowAdd )
{
   xmlattr* a = findAttr( AName );
   if( a )
   {
      a->setValue( AValue );
   }
   else
   {
      if( AllowAdd )
      {
         a = addAttr( AName, AValue );
      }
   }
   return a;
}
//---------------------------------------------------------------------------
xmlattr* xmlnode::setAttribute( AnsiString AName, AnsiString AValue, bool AllowAdd )
{
   return setAttrValue( AName, AValue, AllowAdd );
}
//---------------------------------------------------------------------------
AnsiString xmlnode::getAttrValue( AnsiString AName )
{
   xmlattr* a = findAttr( AName );
   AnsiString p = ( a ? a->getValue() : AnsiString( "" ) );

   return p;
}
//---------------------------------------------------------------------------
void xmlnode::delAttr( AnsiString AName )
{
   if( FAttrCount > 0 )
   {
      xmlattr* a = findAttr( AName );
      if( a )
      {
         xmlattr** tmp;
         int j, i;

         if( FAttrCount == 1 )
         {
            delete [] FAttr;
            FAttrCount = 0;
         }
         else
         {
            tmp = new xmlattr*[ FAttrCount - 1 ];
            for( j = 0, i = 0; j < FAttrCount; j++ )
            {
               if( FAttr[ j ] != a )
               {
                  tmp[ i ] = FAttr[ j ];
                  i++;
               }
            }
            delete [] FAttr;
            FAttr = tmp;
            FAttrCount--;
         }
      }
   }
}
//---------------------------------------------------------------------------
xmlattr* xmlnode::getAttrByName( AnsiString AName )
{
   xmlattr* a = findAttr( AName );
   if( !a )
   {
      a = &__NULL_XML_Attr__;
   }
   return a;
}
//---------------------------------------------------------------------------
xmlnode* xmlnode::getNodeByName( AnsiString AName )
{
   xmlnode* n = getFirstCh();
   xmlnode* p = NULL;

   while( n && !p )
   {
      if( n->getName() == AName )
      {
         p = n;
      }
      n = n->getNext();
   }
   return p;
}
//---------------------------------------------------------------------------
AnsiString xmlnode::getNodeValue( AnsiString AName, AnsiString ADefault )
{
   AnsiString p;
   xmlnode* n = getNodeByName( AName );
   if( n )
   {
      return n->getValue();
   }
   else
   {
      #ifdef __BORLANDC__
      throw Exception( "Node [" + AName + "] doens't exist under node [" + FName + "]..." );
      #endif
   }
}
//---------------------------------------------------------------------------
AnsiString xmlnode::readString( AnsiString ANodeName, AnsiString ADefault )
{
   return getNodeValue( ANodeName, ADefault );
}
//---------------------------------------------------------------------------
int xmlnode::readInteger( AnsiString ANodeName, int ADefault )
{
   AnsiString p = getNodeValue( ANodeName, IntToStr( ADefault ) );
   return p.ToInt();
}
//---------------------------------------------------------------------------
double xmlnode::readDouble( AnsiString ANodeName, double ADefault )
{
   AnsiString p = getNodeValue( ANodeName, FloatToStr( ADefault ) );
   return p.ToDouble();
}
//---------------------------------------------------------------------------
bool xmlnode::readBoolean( AnsiString ANodeName, bool ADefault )
{
   AnsiString p = getNodeValue( ANodeName, FloatToStr( ADefault ) );
   return ( p.UpperCase() == "TRUE" ? true : false );
}
//---------------------------------------------------------------------------
void xmlnode::saveToFile( FILE* File, int Level )
{
   if( File )
   {
      int j, type;
      xmlattr* a;
      xmlnode* n;

      for( j = 0; j < Level; j++ )
      {
         fprintf( File, "   " );
      }
      fprintf( File, "<%s", FName.c_str() );
      for( j = 0; j < FAttrCount; j++ )
      {
         a = FAttr[ j ];
         type = a->getType();
         fprintf( File, " %s=", a->getName().c_str() ); //\"%s\"", a->getName(), a->getValue() );
         //if( ( type & xmlaInteger ) || ( type & xmlaDouble ) || ( type & xmlaBoolean ) )
         //{
         //   fprintf( File, "%s", a->getValue().c_str() );
         //}
         //else
         //{
         fprintf( File, "\"%s\"", a->getValue().c_str() );
         //}
      }
      if( hasChildren() )
      {
         fprintf( File, ">%s\n", FValue.c_str() );
         n = getFirstCh();
         while( n )
         {
            n->saveToFile( File, Level + 1 );
            n = n->getNext();
         }
         for( j = 0; j < Level; j++ )
         {
            fprintf( File, "   " );
         }
         fprintf( File, "</%s>\n", FName.c_str() );
      }
      else
      {
         if( FValue.Length() > 0 )
         {
            fprintf( File, ">%s</%s>\n", FValue.c_str(), FName.c_str() );
         }
         else
         {
            if( FName[ 1 ] == '?' )
            {
               fprintf( File, "?>\n" );
            }
            else
            {
               fprintf( File, "/>\n" );
            }
         }
      }
   }
}
//---------------------------------------------------------------------------
AnsiString xmlnode::saveToString( int Level )
{
   AnsiString p, s;

      int j, type;
      xmlattr* a;
      xmlnode* n;

      for( j = 0; j < Level; j++ )
      {
         p += "   "; //fprintf( File, "   " );
      }
      p += ( "<" + FName ); //fprintf( File, "<%s", FName.c_str() );
      for( j = 0; j < FAttrCount; j++ )
      {
         a = FAttr[ j ];
         type = a->getType();
         p += ( " " + a->getName() + "=" ); //fprintf( File, " %s=\"%s\"", a->getName(), a->getValue() );
         //if( ( type & xmlaInteger ) || ( type & xmlaDouble ) || ( type & xmlaBoolean ) )
         //{
         //   p += a->getValue();
         //}
         //else
         //{
         p += ( "\"" + a->getValue() + "\"" );
         //}
      }

      if( hasChildren() )
      {
         p += ( ">" + FValue + "\r\n" ); //fprintf( File, ">%s\n", FValue.c_str() );
         n = getFirstCh();
         while( n )
         {
            p += n->saveToString( Level + 1 );
            n = n->getNext();
         }
         for( j = 0; j < Level; j++ )
         {
            p += "   "; //fprintf( File, "   " );
         }
         p += ( "</" + FName + ">\r\n" ); //fprintf( File, "</%s>\n", FName.c_str() );
      }
      else
      {
         if( FValue.Length() > 0 )
         {
            p += ( ">" + FValue + "</" + FName + ">\r\n" ); //fprintf( File, ">%s</%s>\n", FValue.c_str(), FName.c_str() );
         }
         else
         {
            if( FName[ 1 ] == '?' )
            {
               p += ( "?>\r\n" ); //fprintf( File, "?>\n" );
            }
            else
            {
               p += ( "/>\r\n" ); //fprintf( File, "/>\n" );
            }
         }
      }

   return p;
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
xmlsearchrec::xmlsearchrec( void )
{
   clear();
}
//---------------------------------------------------------------------------
xmlsearchrec::~xmlsearchrec()
{
}
//---------------------------------------------------------------------------
void xmlsearchrec::clear( void )
{
   FName = "";
   FValue = "";
   FAttrName = "";
   FAttrValue = "";
   FNode = NULL;
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
xmltree::xmltree( void )
   : ptree()
{
   _lastError = -1;
   _rootName = "";
   _root = NULL;
}
//---------------------------------------------------------------------------
xmltree::xmltree( AnsiString ARootName )
   : ptree()
{
   _lastError = 0;

   _version = new xmlnode( "?xml", "" ); // version=\"1.0\" encondig=\"windows-1251\"?", "" );
   _version->setAttribute( "version", "1.0", true );
   _version->setAttribute( "encoding", "windows-1250", true );
   ptree::addnode( _version, NULL );

   _rootName = ( ARootName.Length() > 0 ? ARootName : AnsiString( "XMLTree" ) );
   _root = new xmlnode( _rootName, "" );
   ptree::addnode( _root, NULL );
}
//---------------------------------------------------------------------------
xmltree::~xmltree()
{
}
//---------------------------------------------------------------------------
void xmltree::translateBuffer( char* Buffer )
{
   int pos, start, stop;
   int len, type;
   char z, z1, z2, z3;
   AnsiString n, v;
   xmlnode* node = NULL;
   xmlnode* parent;
   bool nodeEmpty;
   bool isComment;
   int quota;

   clear();

   if( Buffer )
   {
      len = (int)( strlen( Buffer ) );
      pos = 0;
      start = -1;
      stop = -1;
      type = 0;
      quota = 0;
      parent = NULL;
      n = "";
      v = "";
      while( pos < len )
      {
         z = Buffer[ pos ];
         z1 = ( pos < len - 1 ? Buffer[ pos + 1 ] : '\0' );
         z2 = ( pos < len - 2 ? Buffer[ pos + 2 ] : '\0' );
         z3 = ( pos < len - 3 ? Buffer[ pos + 3 ] : '\0' );

         if( type == 0 || type == 3 )// && z == '<' ) )
         {
            if( z == '<' )
            {
               if( type == 3 )
               {
                  if( node )//&& pos < len - 1 && Buffer[ pos + 1 ] != '/' )
                  {
                     if( node->getValue().Length() == 0 )
                     {
                        //ShowMessage( "Setting Value to Node=[" + node->getName() + "]; Value=[" + v + "]" );
                        node->setValue( v.Trim() );
                        v = "";
                     }
                  }
               }
               nodeEmpty = false;
               isComment = false;
               type = 1;
               start = pos;
            }
            else
            {
               //type = 3;
            }
         }
         else
         {
            if( type == 1 && z == '/' && pos == start + 1 )
            {
               type = 2;
            }
            else if( type == 1 && z == '!' && pos == start + 1 )
            {
               type = 4;
            }
            else if( type == 1 && z == '?' && pos == start + 1 )
            {
               type = 5;
            }
            else if( type == 1 && z == '>' )
            {
               //type = 3;
            }
            else if( type == 2 && z == '>' )
            {
               //type = 4;
            }
         }

         if( type == 1 ) //&& z != '<' && z != '>' )
         {
            if( z != '<' && z != '>' && z != '/' && z != '\"' )
            {
               n += AnsiString( z );
            }
            else if( z == '/' )
            {
               if( quota == 0 )
               {
                  nodeEmpty = true;
               }
               else
               {
                  n += "/";
               }
            }
            else if( z == '\"' )
            {
               //ShowMessage( "n=[" + n + "]; Quota=" + IntToStr( quota ) );
               if( quota == 1 )
               {
                  quota = 0;
               }
               else
               {
                  quota = 1;
               }
               n += "\"";
            }
            else if( z == '>' )
            {
               node = new xmlnode( n, "" );
               //ShowMessage( "Adding node [" + n + "]" );
               n = "";
               type = 3;
               addnode( node, parent );
               if( !nodeEmpty )
               {
                  parent = node;
               }
            }
         }
         else if( type == 2 )
         {
            if( z == '>' )
            {
               if( parent )
               {
                  parent = (xmlnode*)( parent->getparent() );
               }
               type = 0;
            }
         }
         else if( type == 3 )
         {
            v += AnsiString( z );
            //ShowMessage( v );
         }
         else if( ( type == 4 || type == 5 ) && z == '>' )
         {
            type = 0;
         }
         pos++;
      }
   }
   _root = getFirst();
}
//---------------------------------------------------------------------------
void xmltree::translateAttributes( xmlnode* Parent )
{
   xmlnode* n;
   AnsiString p;
   int pos;

   n = getFirstCh( Parent );
   while( n )
   {
      setAttributes( n );
      if( n->hasChildren() )
      {
         translateAttributes( n );
      }
      n = n->getNext();
   }
}
//---------------------------------------------------------------------------
void xmltree::setAttributes( xmlnode* Node )
{
   if( Node )
   {
      AnsiString p, s;
      int pos, j, start, quota;
      char z;
      xmlattr* a;

      p = Node->getName();
      pos = p.Pos( " " );
      if( pos )
      {
         s = p.SubString( pos + 1, p.Length() ).Trim() + ">";
         //ShowMessage( "AttrStr=[" + s + "]" );
         Node->setName( p.SubString( 1, pos ).Trim() );

         j = 1;
         start = 1;
         quota = 0;
         p = "";
         while( j <= s.Length() )
         {
            z = s[ j ];
            if( z == '\"' )
            {
               if( quota == 0 )
               {
                  quota = 1;
               }
               else
               {
                  quota = 0;
               }
               p += AnsiString( '\"' );
            }
            else if( z == ' ' || z == '>' )
            {
               if( quota )
               {
                  p += AnsiString( z );
               }
               else
               {
                  //p = s.SubString( start, j - 1 );
                  a = new xmlattr( p );
                  p = "";
                  Node->addAttr( a );

                  start = j + 1;
               }
            }
            else
            {
               p += AnsiString( z );
            }
            j++;
         }
      }
   }
}
//---------------------------------------------------------------------------
void xmltree::addNode( xmlnode* ANode, xmlnode* AParent )
{
   if( ANode )
   {
      if( !AParent )
      {
         AParent = _root;
      }
      ptree::addnode( ANode, AParent );
   }
}
//---------------------------------------------------------------------------
xmlnode* xmltree::addNode( AnsiString AName, AnsiString AValue, xmlnode* AParent )
{
   xmlnode* n = new xmlnode( AName, AValue );
   addNode( n, AParent );

   return n;
}
//---------------------------------------------------------------------------
void xmltree::clear( void )
{
   xmlnode* p = getFirst();
   xmlnode* n;

   while( p )
   {
      n = p->getNext();
      p->clear();
      delete p;
      p = n;
   }
   //nodes = NULL;
   ptree::clear();
}
//---------------------------------------------------------------------------
void xmltree::clearSearch( void )
{
   _search.clear();
}
//---------------------------------------------------------------------------
xmlnode* xmltree::findFirst( AnsiString AName, AnsiString AValue,
                             AnsiString AAttrName, AnsiString AAttrValue )
{
   xmlnode* n = NULL;
   xmlnode* res = NULL;

   _search.setName( AName );
   _search.setValue( AValue );
   _search.setAttrName( AAttrName );
   _search.setAttrValue( AAttrValue );

   n = getFirst();
   while( n && !res )
   {
      if( n->getName() == _search.getName() )
      {
         _search.setNode( n );
         res = n;
      }
      n = n->getNext();
   }
   return res;
}
//---------------------------------------------------------------------------
xmlnode* xmltree::findNext( void )
{
   xmlnode* n = NULL;
   xmlnode* res = NULL;

   n = _search.getNode()->getNext();
   while( n && !res )
   {
      if( n->getName() == _search.getName() )
      {
         res = n;
      }
      n = n->getNext();
   }
   return res;
}
//---------------------------------------------------------------------------
void xmltree::loadFromBuffer( char* Buffer )
{
   translateBuffer( Buffer );
   translateAttributes( NULL );
}
//---------------------------------------------------------------------------
void xmltree::loadFromFile( AnsiString FileName )
{
   #ifdef __BORLANDC__
   struct ffblk ffblk;

   if( !findfirst( FileName.c_str(), &ffblk, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH ) )
   {
      int size = ffblk.ff_fsize;
   #else
   //struct _finddata_t ffblk;
   
   //if( _findfirst( FileName.c_str(), &ffblk ) > -1 )
   //{
      int size = 64000; //ffblk.size;   
   #endif
   
      char z;
      int j;
      char* buf = new char[ size ];
      int readed;
      FILE* f = fopen( FileName.c_str(), "rt" );

      if( f )
      {
         _lastError = 0;
         j = 0;
         while( !feof( f ) )
         {
            z = fgetc( f );
            if( !feof( f ) )
            {
               if( z != '\n' && z != '\r' && z != '\t' && z != '\0' )
               {
                  buf[ j ] = z;
                  j++;
               }
            }
         }
         buf[ j ] = '\0';
         fclose( f );

         //ShowMessage( AnsiString( buf ) );
         translateBuffer( buf );
         translateAttributes( NULL );

         delete [] buf;
      }
      else
      {
         _lastError = 2;
      }
	#ifdef __BORLANDC__
   }
   else
   {
      _lastError = 3;
   }
	#endif
}
//---------------------------------------------------------------------------
void xmltree::saveToFile( AnsiString FileName )
{
   FILE* f = fopen( FileName.c_str(), "wt" );
   if( f )
   {
      int level = 0;
      xmlnode* n = getFirst();
      while( n )
      {
         n->saveToFile( f, level );
         n = n->getNext();
      }
      fclose( f );
   }
}
//---------------------------------------------------------------------------
AnsiString xmltree::saveToString( void )
{
   AnsiString p = "";
   int level = 0;

   xmlnode* n = getFirst();
   while( n )
   {
      p += n->saveToString( level );
      n = n->getNext();
   }
   return p;
}
//---------------------------------------------------------------------------
int xmltree::lastError( void )
{
   return _lastError;
}
//---------------------------------------------------------------------------
#ifdef __BORLANDC__
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
__fastcall TXMLNode::TXMLNode( AnsiString AName, AnsiString AValue )
   : xmlnode( AName, AValue )
{
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
__fastcall TXMLTree::TXMLTree( void )
   : xmltree()
{
}
//---------------------------------------------------------------------------
__fastcall TXMLTree::TXMLTree( AnsiString ARootName )
   : xmltree( ARootName )
{
}
//---------------------------------------------------------------------------
void __fastcall TXMLTree::AddNode( TXMLNode* Node, TXMLNode* Parent )
{
   xmltree::addNode( Node, Parent );
}
//---------------------------------------------------------------------------
TXMLNode* __fastcall TXMLTree::AddNode( AnsiString Name, AnsiString Value, TXMLNode* Parent )
{
   return (TXMLNode*)( xmltree::addNode( Name, Value, Parent ) );
}
//---------------------------------------------------------------------------
void __fastcall TXMLTree::LoadFromStream( TStream* Stream )
{
   char* buf;
   int size;

   if( Stream )
   {
      size = Stream->Size;
      buf = new char[ size + 1 ];
      try
      {
         Stream->ReadBuffer( buf, size );
         xmltree::loadFromBuffer( buf );
         delete [] buf;
      }
      catch( Exception& e )
      {
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TXMLTree::LoadFromFile( AnsiString FileName ) // { xmltree::loadFromFile( FileName ); }
{
   xmltree::loadFromFile( FileName );
   if( !xmltree::lastError() )
   {
   }
   else
   {
      throw Exception( "Error loading XML from file [" + FileName + "]; ErrorCode " + IntToStr( xmltree::lastError() ) );
   }
}
//---------------------------------------------------------------------------
void __fastcall TXMLTree::SaveToStream( TStream* Stream )
{
   if( Stream )
   {
      AnsiString p = xmltree::saveToString();
      try
      {
         Stream->WriteBuffer( p.c_str(), p.Length() );
      }
      catch( Exception& e )
      {
      }
   }
}
//---------------------------------------------------------------------------
#endif

#pragma package(smart_init)

