//---------------------------------------------------------------------------

#ifndef PGXMLH
#define PGXMLH
#include "ptree.h"
//---------------------------------------------------------------------------
class xmlattr;
class xmlnode;
class xmltree;
//---------------------------------------------------------------------------
const int
   xmlaNone       = 0x00000000,
   xmlaString     = 0x00000001,
   xmlaInteger    = 0x00000002,
   xmlaDouble     = 0x00000004,
   xmlaBoolean    = 0x00000008,

   xmlaAll        = ( xmlaString | xmlaInteger | xmlaDouble | xmlaBoolean ),
   xmlaAllNB      = ( xmlaString | xmlaInteger | xmlaDouble );
//---------------------------------------------------------------------------
class xmlattr
{
   friend class xmlnode;

   private:
   AnsiString FName;
   AnsiString FValue;
   int FType;

   void setName( AnsiString AName ) { FName = AName; }
   void setType( void );

   public:
   xmlattr( void );
   xmlattr( AnsiString AName, AnsiString AValue );
   xmlattr( AnsiString AString );
   xmlattr( const xmlattr& ASource );
   xmlattr( xmlattr* ASource );
   ~xmlattr();

   xmlattr& operator=( const xmlattr& source );

   AnsiString getName( void ) { return FName; }
   AnsiString getValue( void ) { return FValue; }
   int getType( void ) { return FType; }
   AnsiString getTypeStr( void );

   void setValue( AnsiString AValue );

   bool isEmpty( void ) { return ( FValue.Length() == 0 ); }
   bool isNull( void ) { return ( FType == xmlaNone ); }

   int getAsInteger( void );
   double getAsDouble( void );
   bool getAsBoolean( void );
   AnsiString getAsString( void );
};
//---------------------------------------------------------------------------
class xmlnode : public pnode
{
   friend class xmltree;

   private:
   AnsiString FName;
   AnsiString FValue;
   xmlattr** FAttr;
   int FAttrCount;

   void clearAttr( void );
   void addAttr( xmlattr* Attr );
   xmlattr* addAttr( AnsiString AName, AnsiString AValue );

   void saveToFile( FILE* File, int Level );
   AnsiString saveToString( int Level );

   public:
   xmlnode( void );
   xmlnode( AnsiString AName, AnsiString AValue );
   ~xmlnode();

   AnsiString getName( void );
   AnsiString getValue( void );

   void setName( AnsiString Value );
   void setValue( AnsiString Value );

   virtual void clear( void );
   virtual bool hasChildren( void ) { return pnode::haschildren(); }

   virtual xmlnode* getFirst( void ) { return (xmlnode*)( pnode::getfirst() ); }
   virtual xmlnode* getLast( void ) { return (xmlnode*)( pnode::getlast() ); }
   virtual xmlnode* getNext( void ) { return (xmlnode*)( pnode::getnext() ); }
   virtual xmlnode* getPrev( void ) { return (xmlnode*)( pnode::getprev() ); }

   virtual xmlnode* getFirstCh( void ) { return (xmlnode*)( pnode::getfirstch() ); }
   virtual xmlnode* getLastCh( void ) { return (xmlnode*)( pnode::getlastch() ); }
   virtual xmlnode* getNextCh( xmlnode* node ) { return (xmlnode*)( pnode::getnextch( node ) ); }
   virtual xmlnode* getPrevCh( xmlnode* node ) { return (xmlnode*)( pnode::getprevch( node ) ); }

   xmlattr* findAttr( AnsiString AName );
   xmlattr* getAttr( int index );

   xmlattr* setAttrValue( AnsiString AName, AnsiString AValue, bool AllowAdd = true );
   xmlattr* setAttribute( AnsiString AName, AnsiString AValue, bool AllowAdd = true );
   AnsiString getAttrValue( AnsiString AName );
   void delAttr( AnsiString AName );

   virtual xmlnode* getNodeByName( AnsiString AName );
   virtual AnsiString getNodeValue( AnsiString AName, AnsiString ADefault = "" );

   virtual AnsiString readString( AnsiString ANodeName, AnsiString ADefault = "" );
   virtual int readInteger( AnsiString ANodeName, int ADefault = 0 );
   virtual double readDouble( AnsiString ANodeName, double ADefault = 0.0 );
   virtual bool readBoolean( AnsiString ANodeName, bool ADefault = false );

   int getAttrCount( void ) { return FAttrCount; }
   xmlattr* getAttrByName( AnsiString AName );
};
//---------------------------------------------------------------------------
class xmlsearchrec
{
   private:
   AnsiString FName;
   AnsiString FValue;
   AnsiString FAttrName;
   AnsiString FAttrValue;
   xmlnode* FNode;

   public:
   xmlsearchrec( void );
   ~xmlsearchrec();

   void clear( void );

   void setName( AnsiString Value ) { FName = Value; }
   AnsiString getName( void ) { return FName; }

   void setValue( AnsiString Value ) { FValue = Value; }
   AnsiString getValue( void ) { return FValue; }

   void setAttrName( AnsiString Value ) { FAttrName = Value; }
   AnsiString getAttrName( void ) { return FAttrName; }

   void setAttrValue( AnsiString Value ) { FAttrValue = Value; }
   AnsiString getAttrValue( void ) { return FAttrValue; }

   void setNode( xmlnode* Node ) { FNode = Node; }
   xmlnode* getNode( void ) { return FNode; }
};
//---------------------------------------------------------------------------
class xmltree : public ptree
{
   private:
   int _lastError;
   xmlsearchrec _search;
   xmlnode* _root;
   xmlnode* _version;
   AnsiString _rootName;

   void translateBuffer( char* Buffer );
   void translateAttributes( xmlnode* Parent );
   void setAttributes( xmlnode* Node );

   public:
   xmltree( void );
   xmltree( AnsiString ARootName );
   ~xmltree();

   void addNode( xmlnode* ANode, xmlnode* AParent = NULL );
   xmlnode* addNode( AnsiString AName, AnsiString AValue, xmlnode* AParent = NULL );
   virtual void clear( void );

   virtual xmlnode* getFirst( void ) { return (xmlnode*)( ptree::getfirst() ); }
   virtual xmlnode* getLast( void ) { return (xmlnode*)( ptree::getlast() ); }
   virtual xmlnode* getNext( xmlnode* node ) { return (xmlnode*)( ptree::getnext( node ) ); }
   virtual xmlnode* getPrev( xmlnode* node ) { return (xmlnode*)( ptree::getprev( node ) ); }

   virtual xmlnode* getFirstCh( xmlnode* node ) { return (xmlnode*)( ptree::getfirstch( node ) ); }
   virtual xmlnode* getLastCh( xmlnode* node ) { return (xmlnode*)( ptree::getlastch( node ) ); }
   virtual xmlnode* getNextCh( xmlnode* parent, xmlnode* node ) { return (xmlnode*)( ptree::getnextch( parent, node ) ); }
   virtual xmlnode* getPrevCh( xmlnode* parent, xmlnode* node ) { return (xmlnode*)( ptree::getprevch( parent, node ) ); }

   virtual xmlnode* getRoot( void ) { return _root; }
   virtual AnsiString getRootName( void ) { return ( _root ? _root->getName() : AnsiString( "?" ) ); } 

   virtual void clearSearch( void );
   virtual xmlnode* findFirst( AnsiString AName, AnsiString AValue, AnsiString AAttrName, AnsiString AAttrValue );
   virtual xmlnode* findNext( void );

   void loadFromBuffer( char* Buffer );
   void loadFromFile( AnsiString FileName );

   void saveToFile( AnsiString FileName );
   AnsiString saveToString( void );

   int lastError( void );
};
//---------------------------------------------------------------------------
#ifdef __BORLANDC__
//---------------------------------------------------------------------------
class TXMLAttr;
class TXMLNode;
class TXMLTree;
//---------------------------------------------------------------------------
class TXMLAttr : public xmlattr
{
   private:
   AnsiString __fastcall GetName( void ) { return xmlattr::getName(); }
   AnsiString __fastcall GetValue( void ) { return xmlattr::getValue(); }
   int __fastcall GetType( void ) { return xmlattr::getType(); }
   AnsiString __fastcall GetTypeStr( void ) { return xmlattr::getTypeStr(); }

   int __fastcall GetAsInteger( void ) { return xmlattr::getAsInteger(); }
   double __fastcall GetAsDouble( void ) { return xmlattr::getAsDouble(); }
   bool __fastcall GetAsBoolean( void ) { return xmlattr::getAsBoolean(); }
   AnsiString __fastcall GetAsString( void ) { return xmlattr::getAsString(); }

   public:
   __property AnsiString Name = { read=GetName };
   __property AnsiString Value = { read=GetValue };
   __property int Type = { read=GetType };
   __property AnsiString TypeStr = { read=GetTypeStr };

   __property int AsInteger = { read=GetAsInteger };
   __property double AsDouble = { read=GetAsDouble };
   __property bool AsBoolean = { read=GetAsBoolean };
   __property AnsiString AsString = { read=GetAsString };
};
//---------------------------------------------------------------------------
class TXMLNode : public xmlnode
{
   private:
   void __fastcall SetName( AnsiString Value ) { xmlnode::setName( Value ); }
   void __fastcall SetValue( AnsiString Value ) { xmlnode::setValue( Value ); }
   void __fastcall SetTag( int Value ) { xmlnode::settag( Value ); }

   AnsiString __fastcall GetName( void ) { return xmlnode::getName(); }
   AnsiString __fastcall GetValue( void ) { return xmlnode::getValue(); }
   int __fastcall GetTag( void ) { return xmlnode::gettag(); }
   bool __fastcall GetHasChildren( void ) { return xmlnode::hasChildren(); }

   TXMLTree* __fastcall GetOwner( void ) { return (TXMLTree*)( xmlnode::getowner() ); }
   TXMLNode* __fastcall GetParent( void ) { return (TXMLNode*)( xmlnode::getparent() ); };

   TXMLAttr* __fastcall GetAttr( int Index ) { return (TXMLAttr*)( xmlnode::getAttr( Index ) ); }
   int __fastcall GetAttrCount( void ) { return xmlnode::getAttrCount(); }

   public:
   __fastcall TXMLNode( AnsiString AName, AnsiString AValue );

   TXMLNode* GetFirst( void ) { return (TXMLNode*)( xmlnode::getFirst() ); }
   TXMLNode* GetLast( void ) { return (TXMLNode*)( xmlnode::getLast() ); }
   TXMLNode* GetNext( void ) { return (TXMLNode*)( xmlnode::getNext() ); }
   TXMLNode* GetPrev( void ) { return (TXMLNode*)( xmlnode::getPrev() ); }

   TXMLNode* GetFirstCh( void ) { return (TXMLNode*)( xmlnode::getFirstCh() ); }
   TXMLNode* GetLastCh( void ) { return (TXMLNode*)( xmlnode::getLastCh() ); }
   TXMLNode* GetNextCh( TXMLNode* node ) { return (TXMLNode*)( xmlnode::getNextCh( node ) ); }
   TXMLNode* GetPrevCh( TXMLNode* node ) { return (TXMLNode*)( xmlnode::getPrevCh( node ) ); }

   bool __fastcall HasAttr( AnsiString AName ) { return ( xmlnode::findAttr( AName ) != NULL ); }
   AnsiString __fastcall GetAttrValue( AnsiString AName ) { return xmlnode::getAttrValue( AName ); }
   void __fastcall SetAttrValue( AnsiString AName, AnsiString AValue ) { xmlnode::setAttrValue( AName, AValue ); }
   TXMLAttr* __fastcall GetAttrByName( AnsiString AName ) { return (TXMLAttr*)( xmlnode::getAttrByName( AName ) ); }

   TXMLNode* __fastcall GetNodeByName( AnsiString AName ) { return (TXMLNode*)( xmlnode::getNodeByName( AName ) ); }
   AnsiString __fastcall GetNodeValue( AnsiString ANodeName, AnsiString ADefault = "" ) { return xmlnode::getNodeValue( ANodeName, ADefault ); }

   AnsiString __fastcall ReadString( AnsiString ANodeName ) { return xmlnode::readString( ANodeName ); }
   int __fastcall ReadInteger( AnsiString ANodeName ) { return xmlnode::readInteger( ANodeName ); }
   double __fastcall ReadDouble( AnsiString ANodeName ) { return xmlnode::readDouble( ANodeName ); }
   bool __fastcall ReadBoolean( AnsiString ANodeName ) { return xmlnode::readBoolean( ANodeName ); }

   __property AnsiString Name = { read=GetName, write=SetName };
   __property AnsiString Value = { read=GetValue, write=SetValue };
   __property TXMLTree* Owner = { read=GetOwner };
   __property TXMLNode* Parent = { read=GetParent };
   __property TXMLNode* First = { read=GetFirst };
   __property TXMLNode* Last = { read=GetLast };
   __property TXMLNode* Next = { read=GetNext };
   __property TXMLNode* Prev = { read=GetPrev };
   __property int Tag = { read=GetTag, write=SetTag };
   __property bool HasChildren = { read=GetHasChildren };

   __property TXMLAttr* Attr[ int Index ] = { read=GetAttr };
   __property int AttrCount = { read=GetAttrCount };
};
//---------------------------------------------------------------------------
class TXMLTree : public xmltree
{
   private:
   int __fastcall GetLastError( void ) { return xmltree::lastError(); }

   TXMLNode* __fastcall GetRoot( void ) { return (TXMLNode*)( xmltree::getRoot() ); }
   AnsiString __fastcall GetRootName( void ) { return ( xmltree::getRoot() ? xmltree::getRoot()->getName() : AnsiString( "?" ) ); }
   
   public:
   __fastcall TXMLTree( void );
   __fastcall TXMLTree( AnsiString AName );

   void __fastcall Clear( void ) { xmltree::clear(); }
   void __fastcall AddNode( TXMLNode* Node, TXMLNode* Parent );
   TXMLNode* __fastcall AddNode( AnsiString Name, AnsiString Value, TXMLNode* Parent );

   void __fastcall LoadFromStream( TStream* Stream );
   void __fastcall LoadFromFile( AnsiString FileName ); // { xmltree::loadFromFile( FileName ); }

   void __fastcall SaveToStream( TStream* Stream );
   void __fastcall SaveToFile( AnsiString FileName ) { xmltree::saveToFile( FileName ); }

   virtual TXMLNode* GetFirst( void ) { return (TXMLNode*)( xmltree::getFirst() ); }
   virtual TXMLNode* GetLast( void ) { return (TXMLNode*)( xmltree::getLast() ); }
   virtual TXMLNode* GetNext( TXMLNode* node ) { return (TXMLNode*)( xmltree::getNext( node ) ); }
   virtual TXMLNode* GetPrev( TXMLNode* node ) { return (TXMLNode*)( xmltree::getPrev( node ) ); }

   virtual TXMLNode* GetFirstCh( TXMLNode* node ) { return (TXMLNode*)( xmltree::getFirstCh( node ) ); }
   virtual TXMLNode* GetLastCh( TXMLNode* node ) { return (TXMLNode*)( xmltree::getLastCh( node ) ); }
   virtual TXMLNode* GetNextCh( TXMLNode* parent, TXMLNode* node ) { return (TXMLNode*)( xmltree::getNextCh( parent, node ) ); }
   virtual TXMLNode* GetPrevCh( TXMLNode* parent, TXMLNode* node ) { return (TXMLNode*)( xmltree::getPrevCh( parent, node ) ); }

   __property int LastError = { read=GetLastError };
   //__property TXMLNode* First = { read=GetFirst };
   //__property TXMLNode* Last = { read=GetLast };
   __property TXMLNode* Root = { read=GetRoot };
   __property AnsiString Name = { read=GetRootName };
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
#endif
