/***************************************************************************
                          tlcd.cpp  -  description
                             -------------------
    begin                : pon lis 18 2002
    copyright            : (C) 2002 by Piotr Gridniew
    email                : gridniew@x4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pgcalc.h"
#include "tlcd.h"

//---------------------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------------------
TLCDHeaderSection::TLCDHeaderSection( TLCDDisplay* AOwner )
{
   Owner = AOwner;
   Text = "";
   MaxLength = 0;
   Left = 0;
   pixLeft = 0;
   pixSize = 0;
}
//---------------------------------------------------------------------------------------
TLCDHeaderSection::~TLCDHeaderSection()
{
}
//---------------------------------------------------------------------------------------
void TLCDHeaderSection::SetMaxLength( int AMaxLength )
{
   if( Owner )
   {
      MaxLength = AMaxLength;
      #ifdef __WIN32__
      pixSize = Owner->SmFont->FontWidth * MaxLength;
      #else
      pixSize = Owner->SmFont->fontWidth() * MaxLength;
      #endif
   }
}
//---------------------------------------------------------------------------------------
void TLCDHeaderSection::SetLeft( int ALeft )
{
   if( Owner )
   {
      Left = ALeft;
      #ifdef __WIN32__
      pixLeft = Owner->SmFont->FontWidth * Left;
      #else
      pixLeft = Owner->SmFont->fontWidth() * Left;
      #endif
   }
}
//---------------------------------------------------------------------------------------
#ifndef __WIN32__
void TLCDHeaderSection::Draw( QPainter* p )
{
   unsigned int j, x;

   if( p )
   {
   //QPainter p( Owner->owner() );
   x = pixLeft;
   for( j = 0; j < Text.length(); j++ )
   {
      Owner->SmFont->drawChar( p, x, 0, ((const QString)(Text)).at( j ) );
      x += Owner->SmFont->fontWidth();
   }
   }
}
#else
//---------------------------------------------------------------------------------------
void TLCDHeaderSection::Draw( Canvas* ACanvas )
{
   int j, x;

   //MessageBox( 0, Text.c_str(), "Header", MB_OK );
   for( j = 1, x = pixLeft; j <= Text.Length() && x <= pixLeft + pixSize; j++ )
   {
      Owner->SmFont->DrawChar( ACanvas, x, 1, Text[ j ] );
      x += Owner->SmFont->FontWidth;
   }
}
#endif
//---------------------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------------------
TLCDDisplay::TLCDDisplay( TCalc* AOwner )
//	: _painter( &_pixmap, AOwner )
{
   Font = NULL;
   SmFont = NULL;
   _owner = AOwner;
   _image = NULL;
   _left = 0;
   _top = 0;
   _width = 100;
   _height = 50;
   _trheight = 10;
   _brheight = 10;

   _locks = 0;
   setBounds( 0, 0, 100, 20 ); //_painter.begin( &_pixmap );
	
   InpLine = new TInputLine( this );
}
//---------------------------------------------------------------------------------------
TLCDDisplay::~TLCDDisplay()
{
   if( Font )
   {
      delete Font;
   }
   if( SmFont )
   {
      delete SmFont;
   }
   if( _image )
   {
      delete _image;
   }
}
//---------------------------------------------------------------------------------------
bool TLCDDisplay::LoadFonts( QString NormalFont, QString SmallFont )
{
   bool res = false;
   QString t[ 2 ] = { "Normal", "Small" };
   int errcode = 0;

   Font = new TLCDFont( this );
   if( Font->LoadFont( NormalFont ) )
   {
      SmFont = new TLCDFont( this );
      if( SmFont->LoadFont( SmallFont ) )
      {
         //QMessageBox::information( _owner, "Info", "Fonts loaded..." );
         setBounds( _left, _top, _width, _height );
         res = true;
      }
      else
      {
         errcode = 1;
      }
   }
   if( !res )
   {
      QMessageBox::critical( _owner, "Error!", "Error loading fonts (" + t[ errcode ] + ")!" );
   }
   return res;
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setFontColor( QRgb color )
{
   _fontcolor = color;
   if( Font )
   {
      Font->setFontColor( color );
   }
   if( SmFont )
   {
      SmFont->setFontColor( color );
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setBackColor( QRgb color )
{
   _backcolor = color;
   if( Font )
   {
      Font->setBackColor( color );
   }
   if( SmFont )
   {
      SmFont->setBackColor( color );
   }
   if( _image )
   {
      _image->fill( 0 );
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setBounds( int Left, int Top, int Width, int Height )
{
   RECT r;
   
	if( _painter.isActive() )
	{
		_painter.end();
	}
	
   _left = Left;
   _top = Top;
   _width = Width;
   _height = Height;
   _pixmap.resize( _width, _height );

   if( Font )
   {
     r.left = 0;
     r.top = _height - _brheight - Font->fontHeight();
     r.right = _width;
     r.bottom = _height - _brheight;
     InpLine->SetRect( r );
   }
	
	_painter.begin( &_pixmap );
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::drawText( int X, int Y, const char* Text, TLCDFont* AFont )
{
   unsigned int j;
   int x;
   
   if( !Text )
   {
   	return;
   }
   
   if( !AFont )
   {
      AFont = Font;
   }
   
   if( X >= 0 && X <= _width - AFont->fontWidth() &&
       Y >= _trheight && Y <= _height - _brheight - AFont->fontHeight() )
   {
      x = X;
      for( j = 0; j < strlen( Text ) && x <= _width - AFont->fontWidth(); j++ )
      {
         AFont->drawChar( &_painter, x, Y, Text[ j ] );
         x += AFont->fontWidth();
      }
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::printText( int X, int Y, AnsiString Text, TLCDFont* AFont )
{
   //QPainter p( _owner );
   int j, x, y;

   if( !AFont )
   {
      AFont = Font;
   }

   x = X * AFont->fontWidth();
   y = _height - _brheight - ( Y + 1 ) * AFont->fontHeight();
   if( x >= 0 && x <= _width - AFont->fontWidth() &&
       y >= _trheight && y <= _height - _brheight - AFont->fontHeight() )
   {
      for( j = 1; j <= Text.Length() && x <= _width - AFont->fontWidth(); j++ )
      {
         AFont->drawChar( &_painter, x, y, Text[ j ] );
         x += AFont->fontWidth();
      }
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::begin( void )
{/*
   if( !_painter.isActive() )
   {
      //_painter.begin( _owner );
		_painter.begin( &_pixmap, _owner );
   }*/
   _locks++;
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::end( void )
{
   _locks--;/*
   if( _painter.isActive() && !_locks )
   {
      _painter.end();
   }*/
	if( !_locks )
	{
		paint();
	}
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::paint( void )
{
   //pix = QPixmap( w, h );
   //dst.begin( &pix, _owner );
   //bitBlt( dst.device(), 0, 0, _painter.device(), _left + r.left, _top + r.top, w, h, Qt::CopyROP, true );
   //QPainter p( _owner );

	QPainter dst( _owner );
	
   //if( !_painter.isActive() )
   //{
   	//_painter.begin( _owner );
   //	_painter.begin( &_pixmap, _owner );
   //}
   
   //_painter.setPen( _backcolor );
   //_painter.setBrush( _backcolor );
   //_painter.drawRect( _left, _top, _width, _height );
   //_painter.drawRect( 0, 0, _width, _height );

   //_painter.setPen( _fontcolor );
   //_painter.moveTo( _left, _top + _trheight - 1 );
   //_painter.lineTo( _left + _width - 1, _top + _trheight - 1 );
   //_painter.moveTo( 0, _trheight - 1 );
   //_painter.lineTo( _width - 1, _trheight - 1 );

   //drawHeaders();
   //drawFuncKeys();

	//if( _owner->activeObject() )
	//{
	//	_owner->activeObject()->Refresh();
	//}
	bitBlt( dst.device(), _left, _top, _painter.device(), 0, 0, _width, _height, Qt::CopyROP, true );
   
	//_painter.end();
	dst.end(); 
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::clear( void )
{
   _painter.setPen( _backcolor );
   _painter.setBrush( _backcolor );
   _painter.drawRect( 0, 0, _width, _height );

   _painter.setPen( _fontcolor );
   _painter.moveTo( 0, _trheight - 1 );
   _painter.lineTo( _width - 1, _trheight - 1 );

   drawHeaders();
   drawFuncKeys();
}   
//---------------------------------------------------------------------------------------
void TLCDDisplay::CreateHeaderSections( int AHeaderCount )
{
   if( AHeaderCount )
   {
      int j;

      HeaderCount = 6;
      Headers = new TLCDHeaderSection*[ HeaderCount ];
      for( j = 0; j < HeaderCount; j++ )
      {
         Headers[ j ] = new TLCDHeaderSection( this );
      }

      Headers[ 0 ]->SetMaxLength( 3 );
      Headers[ 0 ]->SetLeft( 0 );

      Headers[ 1 ]->SetMaxLength( 3 );
      Headers[ 1 ]->SetLeft( 4 );

      Headers[ 2 ]->SetMaxLength( 2 );
      Headers[ 2 ]->SetLeft( 8 );

      Headers[ 3 ]->SetMaxLength( 2 );
      Headers[ 3 ]->SetLeft( 11 );

      Headers[ 4 ]->SetMaxLength( 5 );
      Headers[ 4 ]->SetLeft( 14 );

      Headers[ 5 ]->SetMaxLength( 4 );
      #ifndef __WIN32__
      Headers[ 5 ]->SetLeft( ( _width / SmFont->fontWidth() ) - 4 );
      #else
      Headers[ 5 ]->SetLeft( ( Width / SmFont->FontWidth ) - 4 );
      #endif
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setHeaderText( int Index, const char* Text )
{
   if( Index >= 1 && Index <= HeaderCount )
   {
      Headers[ Index - 1 ]->Text = Text;
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setFuncKey( int Index, const char* Text )
{
   if( Index >= 1 && Index <= 6 )
   {
      FuncKey[ Index - 1 ] = Text;
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setBRHeight( int Value )
{
   _brheight = Value;
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::setTRHeight( int Value )
{
   _trheight = Value;
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::drawHeaders( void )
{
   int j;

   for( j = 0; j < HeaderCount; j++ )
   {
      #ifndef __WIN32__
      Headers[ j ]->Draw( &_painter );
      #else
      Headers[ j ]->Draw( FCanvas );
      #endif
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::drawFuncKeys( void )
{
   //QPainter p( _owner );
   unsigned int j;
   int i;
   int x, y;
   int w, keyw;
   int l, t;
   int len, keyh;
   AnsiString desc;

   keyh = _brheight;
   w = _width / 6;
   keyw = w - 2;
   _painter.setBrush( _fontcolor );
   _painter.setPen( _fontcolor );
   //t = _top + _height - _brheight;
   t = _height - _brheight;
   for( j = 0; j < 6; j++ )
   {  /*
      r.left = j * w + 1;
      r.top = Height - BRHeight + 1;
      r.right = j * w + w - 1;
      r.bottom = Height; 
      FCanvas->FillRect( r, FontColor ); */
      //l = _left + j * w + 1;
      l = j * w + 1;
      _painter.drawRect( l, t, keyw, keyh );
      len = keyw / SmFont->fontWidth();
      desc = FuncKey[ j ].SubString( 1, len );
      //QMessageBox::information( _owner, "Key " + QString::number( j + 1 ),
      //                          desc );
      x = j * w + 1 + ( keyw - desc.Length() * SmFont->fontWidth() ) / 2;
      y = _height - _brheight + 1;
      for( i = 1; i <= desc.Length(); i++ )
      {
         SmFont->drawChar( &_painter, x, y, desc[ i ], true );
         x += SmFont->fontWidth();
      }
   }
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::drawLine( int x1, int y1, int x2, int y2, QRgb Color )
{
   //QPainter p( _owner );
   if( Color == 0 )
   {
      Color = _fontcolor;
   }
   _painter.setPen( Color );
   //_painter.drawLine( _left + x1, _top + y1, _left + x2, _top + y2 );
   _painter.drawLine( x1, y1, x2, y2 );
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::drawRect( int x1, int y1, int w, int h, QRgb Color )
{
   //QPainter p( _owner );
   if( Color == 0 )
   {
      Color = _fontcolor;
   }
   _painter.setPen( Color );
   //_painter.drawRect( _left + x1, _top + y1, w, h );
   _painter.drawRect( x1, y1, w, h );
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::fillRect( int x1, int y1, int w, int h, QRgb Color )
{
   //QPainter p( _owner );
   if( Color == 0 )
   {
      Color = _fontcolor;
   }
   _painter.setPen( Color );
   _painter.setBrush( Color );
   //_painter.drawRect( _left + x1, _top + y1, w, h );
   _painter.drawRect( x1, y1, w, h );
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::invertRect( RECT& r )
{
   QRgb c, nc;
   //QPainter src;
   QPainter dst;
   QImage img;
   QPixmap pix = QPixmap();
   int x, y;
   int w, h;

   w = r.right - r.left;
   h = r.bottom - r.top;
   
   //fprintf( stderr, "TLCDDisplay::invertRect(): Pixmap parameters: ( w=%d, h=%d )\n", w, h );
            
   pix = QPixmap( w, h );
   dst.begin( &pix, _owner );
   //src.begin( _owner );
   //begin();

   //bitBlt( dst.device(), 0, 0, _painter.device(), _left + r.left, _top + r.top, w, h, Qt::CopyROP, true );
   bitBlt( dst.device(), 0, 0, _painter.device(), r.left, r.top, w, h, Qt::CopyROP, true );

   img = pix.convertToImage();
   for( x = 0; x < w; x++ )
   {
      for( y = 0; y < h; y++ )
      {
          c = img.pixel( x, y );
          if( c == _fontcolor )
          {
             nc = _backcolor;
          }
          else if( c == _backcolor )
          {
             nc = _fontcolor;
          }
          img.setPixel( x, y, nc );
      }
   }
   //_painter.drawImage( _left + r.left, _top + r.top, img );
   _painter.drawImage( r.left, r.top, img );
   
   //src.end();
   dst.end();
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::InvertRect( RECT& r )
{
  invertRect( r );
}
//---------------------------------------------------------------------------------------
void TLCDDisplay::invertRow( int RowNum )
{
   RECT r;

   if( RowNum >= 0 && RowNum < rowCount() )
   {
      r.left = 0;
      r.top = _height - _brheight - ( RowNum + 1 ) * Font->fontHeight() - 1;
      r.right = _width - 1;
      r.bottom = r.top + Font->fontHeight();
      invertRect( r );
   }
}
//---------------------------------------------------------------------------------------
