/***************************************************************************
                          tlcdfont.cpp  -  description
                             -------------------
    begin                : pon lis 18 2002
    copyright            : (C) 2002 by Piotr Gridniew
    email                : gridniew@x4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qpainter.h"
#include "qmessagebox.h"

#include "pgcalc.h"
#include "tlcdfont.h"

TLCDFont::TLCDFont( TLCDDisplay* AOwner )
{
   _owner = AOwner;
   _fontcolor = qRgb( 0, 0, 0 );
   _backcolor = qRgb( 200, 200, 200 );
}

TLCDFont::~TLCDFont()
{
   //delete _img;
}

bool TLCDFont::LoadFont( QString FileName )
{
   bool res = false;
   
   _fname = FileName;
   _img = QImage( _fname );
   if( !_img.isNull() )
   {
      _width = _img.width();
      _height = _img.height();
      if( _width % 16 || _height % 16 )
      {
         //Invalid dimension
         QMessageBox::critical( _owner->owner(),
                                "Error!",
                                "Invalid font bitmap dimensions:\nWidth=" +
                                QString::number( _width ) + "; Height=" +
                                QString::number( _height ) );
      }
      else
      {
         //QMessageBox::information( _owner, "OK!", "Font bitmap dimensions:\nWidth=" +
         //                       QString::number( _width ) + "; Height=" +
         //                       QString::number( _height ) );
         _fontwidth = _width / 16;
         _fontheight = _height / 16;
         res = true;
      }
   }
   else
   {
      QMessageBox::critical( _owner->owner(), "Error", "Error loading font " + _fname );
   }
   return res;
}

void TLCDFont::setFontColor( QRgb color )
{
   if( !_img.isNull() )
   {
      QRgb c;
      int x, y, w, h;

      w = _img.width();
      h = _img.height();
      for( y = 0; y < h; y++ )
      {
         for( x = 0; x < w; x++ )
         {
            c = _img.pixel( x, y );
            if( c == _fontcolor )
            {
               _img.setPixel( x, y, color );
            }
         }
      }
   }
   _fontcolor = color;
}

void TLCDFont::setBackColor( QRgb color )
{
   if( !_img.isNull() )
   {
      QRgb c;
      int x, y, w, h;

      w = _img.width();
      h = _img.height();
      for( y = 0; y < h; y++ )
      {
         for( x = 0; x < w; x++ )
         {
            c = _img.pixel( x, y );
            if( c != _fontcolor )
            {
               _img.setPixel( x, y, color );
            }
         }
      }
   }
   _backcolor = color;
}

QRect TLCDFont::getCharRect( int chr )
{
   QRect r;

   if( chr >= 0 && chr < 256 )
   {
      int col, row;

      col = chr % 16;
      row = chr / 16;
      r.setLeft( col * _fontwidth );
      r.setTop( row * _fontheight );
      r.setRight( ( col + 1 ) * _fontwidth - 1 );
      r.setBottom( ( row + 1 ) * _fontheight - 1 );
   }
   return r;
}

void TLCDFont::drawChar( QPainter* p, int ax, int ay, int chr, bool inverse )
{
   if( p && chr >= 0 && chr < 256 &&
       ax >= 0 && ay < _owner->width() &&
       ay >= 0 && ay < _owner->height()
     )
   {
      int l, t;
      int x, y;
      QRgb c;
      QImage i;
      
      l = ( chr % 16 ) * _fontwidth;
      t = ( chr / 16 ) * _fontheight;
      i = QImage( _img.copy( l, t, _fontwidth, _fontheight ) );
      if( inverse )
      {
         for( y = 0; y < _fontheight; y++ )
         {
            for( x = 0; x < _fontwidth; x++ )
            {
               c = i.pixel( x, y );
               if( c == _fontcolor )
               {
                  c = _backcolor;
               }
               else if( c == _backcolor )
               {
                  c = _fontcolor;
               }
               else
               {
                  c = qRgb( 0, 0, 0 );
               }
               i.setPixel( x, y, c );
            }
         }
      }
            
      //p->drawImage( _owner->left() + ax, _owner->top() + ay, i );
      p->drawImage( ax, ay, i );
   }
}   
