#ifdef __WIN32__
#include "TCalc.h"
#else 
#include "pgcalc.h"
#endif

#include "uCalcConst.h"

//---------------------------------------------------------------------------
TCalcConstLib::TCalcConstLib( TCalc* AOwner )
   : TCalcObject( AOwner ),
     _result( 0 ),
     _const( NULL ),
	  hPos( 0 ),
	  hStart( 0 ),
	  _f6_text( "SELECT" )
{
   SetName( "CalcCONST" );
}
//---------------------------------------------------------------------------
TCalcConstLib::~TCalcConstLib( void )
{
}
//---------------------------------------------------------------------------
void TCalcConstLib::setParentName( AnsiString AName )
{
   AnsiString p = AName.UpperCase();

   if( p.Pos( "RPN" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "STCK";
   }
   else if( p.Pos( "ALG" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "EXPR";
   }
   else
   {
   }
}
//---------------------------------------------------------------------------
void TCalcConstLib::assignConstants( atomlist* AList )
{
   _const = AList;
}
//---------------------------------------------------------------------------
void TCalcConstLib::Refresh( void )
{
   int i, j, rcount;
   AnsiString p;
   atom a;
   char buf[ 100 ];

   rcount = LCD->rowCount() - 1;
	
	LCD->begin();   
   TCalcObject::Refresh();
	
	LCD->fillRect( 0, LCD->trheight(), LCD->width() - 1,
                  LCD->height() - LCD->trheight() - LCD->brheight(), LCD->backcolor() );
   
   for( j = 0, p = ""; j < LCD->colCount(); j++ )
   {
      p += AnsiString( (char)( 31 ) );
   }
   LCD->printText( 0, rcount, p );
   p = "CONSTANTS";
   LCD->printText( ( LCD->colCount() - p.Length() ) / 2, rcount, p );
   
   for( j = rcount - 1; j >= 0; j-- )
   {
      i = rcount - j - 1;
      if( i + hStart < _const->count() )
      {
         //MessageBox( Owner->Handle, _const->getDesc( i + hStart ), "Const", MB_OK );
         p = AnsiString( _const->getAtom( i + hStart ).name() ) + ": " + 
             AnsiString( _const->getDesc( i + hStart ) );
         LCD->printText( 0, j, p );
      }
   }
   if( hStart > 0 )
   {
      LCD->printText( LCD->colCount() - 1, rcount - 1, AnsiString( (char)( 19 ) ) );
   }
   if( hStart + rcount - 1 < _const->count() - 1 )
   {
      LCD->printText( LCD->colCount() - 1, 0, AnsiString( (char)( 18 ) ) );
   }
   LCD->invertRow( rcount - hPos - 1 );
	LCD->end();
}
//---------------------------------------------------------------------------
void TCalcConstLib::Activate( void )
{
   Open();
   
   hPos = 0;
   hStart = 0;
   _result = -1;
   
   DefFunc( 1, "", baUnknown );
   DefFunc( 2, "", baUnknown );
   DefFunc( 3, "", baUnknown );
   DefFunc( 4, "", baUnknown );
   DefFunc( 5, "CANCL", baCancel );
   DefFunc( 6, _f6_text, baEnter );
   Owner->DisallowMenu();
}
//---------------------------------------------------------------------------
void TCalcConstLib::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;
   int rcount = LCD->rowCount() - 1;
   
   TCalcObject::ExecAction( Action );
   if( Action == baUnknown || Child )
   {
      return;
   }

   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Action == baEnter || Action == baOk )
   {
      _result = hPos + hStart;
      Close();
   }
   else if( Action == baCancel )
   {
      Close();
   }
   else if( Action == baUp )
   {
      if( hPos > 0 )
      {
         hPos--;
      }
      else if( hStart > 0 )
      {
         hStart--;
      }
   }
   else if( Action == baDown )
   {
      if( hPos + hStart < _const->count() - 1 )
      {
         if( hPos < rcount - 1 )
         {
            hPos++;
         }
         else 
         {
            hStart++;
         }
      }
   }
   else
   {
   }
   
   if( lProcessed )
   {
      Action = baUnknown;
		Refresh();
   }
}
//---------------------------------------------------------------------------
int TCalcConstLib::ShowModal( void )
{
   #ifdef __WIN32__
	MSG msg;

   Activate();   
   while( !IsClosed() ) // msg.message != WM_QUIT ) //&& Calc.Handle )
   {
      //if( PeekMessage( &msg, Calc.Handle, 0, 0, PM_REMOVE ) )
      if( GetMessage( &msg, NULL, 0, 0 ) )
      {
         //if( msg.message != WM_QUIT )
         //{
            //WindowProcedure( msg.hwnd, msg.message, msg.wParam, msg.lParam ); 
            TranslateMessage( &msg );
            DispatchMessage( &msg );
         //}
         //else
         //{
         //   return baClose;
         //}
      }
      else
      {
            Close();
      }
   }
   //Calc.WriteLog( "Menu [" + FCaption + "] finished..." );
   //if( msg.message == WM_QUIT )
   //{
   //   SendMessage( Calc.Handle, WM_QUIT, 0, 0 );
   //}
	#else
   Calc->setActiveObject( this );

   //Activate();
   _result = -1;
   while( !IsClosed() ) //&& !Calc->Terminated() ) // msg.message != WM_QUIT )
   {
      //fprintf( stderr, "App->processOneEvent()\n" );
      App->processEvents();


      //fprintf( stderr, "_result=%d\n", _result );
   }
   #endif
	
	return _result;
}
//---------------------------------------------------------------------------

