#ifndef _UCALCMNU_H
#define _UCALCMNU_H

#include "uCalcWin.h"
//---------------------------------------------------------------------------
class TCalcMenuItem
{
   private:
   AnsiString _caption;
   int _command;
   
   public:
   TCalcMenuItem( void ) : _caption(""), _command( 0 ) {}
   TCalcMenuItem( AnsiString ACaption, int ACommand ) 
   : _caption( ACaption ), 
     _command( ACommand ) 
     {}
  
  AnsiString Caption( void ) { return _caption; }
  int Command( void ) { return _command; }
};
//---------------------------------------------------------------------------
class TCalcMenuItems
{
   private:
   TCalcMenuItem** _items;
   int _count;
   
   public:
   TCalcMenuItems( void );
   ~TCalcMenuItems();
   
   void Add( TCalcMenuItem* Item );
   void Add( AnsiString Caption, int Command );
   void Clear( void );
   
   int Count( void ) { return _count; }
   TCalcMenuItem* Item( int Index );
};
//---------------------------------------------------------------------------
class TCalcMenu : public TCalcWin
{
   private:
   int CStart;
   int CPos;
   int CVisible;
   TCalcMenuItems* Items;
   TCalcScrollBar* sb;
   int maxh;
   
   public:
   TCalcMenu( TCalc* AOwner, TCalcObject* AParent = NULL );
   ~TCalcMenu();

   virtual void SetBounds( int Left, int Top, int Width, int Height );
   virtual void Activate( void );   
   virtual void Refresh( void );
   virtual void ExecAction( TButtonAction& Action );
   virtual void SetDefault( int Default );
   virtual int ShowModal( void );
   
   void SetPosition( int Pos );
   int GetPosition( void ) { return CPos; }
   
   void AddItem( AnsiString Caption, int Command );
   
   TCalcMenuItem* Item( int Index );
};
//---------------------------------------------------------------------------
#endif // _UCALCMNU_H
