//---------------------------------------------------------------------------
#include <math.h>
#include <atomutil.h>

#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif

#include "uCalcWin.h"
#include "uCalcMnu.h"
//#include "uCalcDialog.h"
#include "uCalcRPN.h"
#include "TInputBox.h"

//---------------------------------------------------------------------------
TCalcRPN::TCalcRPN( TCalc* AOwner )
   : TCalcObject( AOwner )
{
   Precision = 5;
   //LCD = AOwner->GetLCD();

   Stack = Owner->Stack;
   //Stack = new TMathStack( NULL );
   //Stack->Size = 1024;
   //Stack->Push( 0.0 );

   IsError = false;
   SetName( "CalcRPN" );
   DotPressed = false;

   SClipboard = "";
   //Clip = Clipboard();

   CStackPos = 0;
   CStackDispPos = 0;
}
//---------------------------------------------------------------------------
TCalcRPN::~TCalcRPN(  )
{
   //delete Stack;
   //Stack = NULL;
}
//---------------------------------------------------------------------------
void TCalcRPN::Refresh( void )
{ 
   int j, i, lcount, x;
   AnsiString p;
/*
   if( LCD->LCDMode == lcdMessage )
   {
   }
   else if( LCD->LCDMode == lcdMenu )
   {
   }
   else
   {*/

   LCD->begin();
   TCalcObject::Refresh();

      lcount = ( LCD->InpLine->Buffer.Length() > 0 ? LCD->rowCount() - 1 : LCD->rowCount() );
      x = ( lcount == LCD->rowCount() ? 0 : 1 );
      LCD->fillRect( 0, LCD->trheight(), LCD->width() - 1,
                     LCD->height() - LCD->trheight() - LCD->brheight(), LCD->backcolor() );

      for( j = 0, i = 1; j < lcount && Stack; j++ )
      {
         if( j < Stack->count() ) //Count )
         {
            //p = Stack->Lines->Strings[ j ]; // Round( Stack->GetValue( j ), Precision ) );
            p = AnsiString( Stack->get( j ).getnamed( Stack->prec() ) );//Precision ) );
         }
         else
         {
            p = "";
         }
         //fprintf( stderr, "Getting %d element from stack = [%s]...\n", j, p.c_str() );
         //LCD->SetLine( j + x, p, taRightJustify, i++ );
         LCD->printText( 0, j + x, IntToStr( j + 1 ) + ":" );
         if( LCD->colCount() - p.Length() < 2 )
         {
            LCD->printText( 2, j + x, p.SubString( 1, LCD->colCount() - 3 ) + AnsiString( (char)( 127 ) ) );
         }
         else
         {
            LCD->printText( LCD->colCount() - p.Length(), j + x, p );
         }
      }
      if( x == 1 )
      {
         //LCD->PrintText( 0, 0, LCD->InpLine->Buffer );
         LCD->InpLine->Draw();
      }
      //LCD->Repaint();

      if( Mode ) //&& CNewHistPos != CHistPos )
      {
         LCD->invertRow( CStackPos );
      } 
      
      if( Child )
      {
         Child->Refresh();
      }
   LCD->end();
}
//---------------------------------------------------------------------------
void TCalcRPN::Activate( void )
{
   SetMode( 0 );
   LCD->InputBuffer = "";
   LCD->InpLine->SetStyle( ilsAllowNumber | 
                           ilsAllowDot | 
                           ilsAllowSeparator |
                           ilsAllowChar | 
                           ilsAllowBrace |
                           ilsAllowString | 
                           ilsAllowOperator |
                           ilsAllowFunc |
                           ilsAllowExpression |
                           ilsAllowSymbol );
   Refresh();
}
//---------------------------------------------------------------------------
/*
void TCalcRPN::ToInputLine( TMathStackOp Opr )
{
   AnsiString p;

   if( Mode )
   {
      if( CStackPos < Stack->Count )
      {
         p = Stack->Lines->Strings[ CStackPos ];
         if( p.SubString( 1, 1 ) == ":" )
         {
            p = p.Delete( 1, 1 );
         }
         LCD->InputBuffer = p;
         SetMode( 0 );
      }
   }
   Refresh();
   Eval( Opr );
}*/
//---------------------------------------------------------------------------
void TCalcRPN::ExecActionMode1( TButtonAction& Action )
{ 
   bool lProcessed = true;
   
   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Action == baCancel )
   {
      SetMode( 0 );
   }
   else if( Action == baUp )
   {
      if( CStackPos < Stack->count() - 1 )
      {
         CStackPos++;
      }
      else
      {
         lProcessed = false;
      }
   }
   else if( Action == baDown )
   {
      if( CStackPos > 0 )
      {
         CStackPos--;
      }
      else
      {
         lProcessed = false;
      }
   }
   else if( Action == baDrop )
   {
      Stack->drop( CStackPos );
      SetMode( 0 );
   }
   else if( Action == baEcho )
   {
      LCD->InpLine->Buffer = AnsiString( Stack->get( CStackPos ).getstring() );
      LCD->InpLine->CursorEnd();
      SetMode( 0 );
   }
   else if( Action == baSwap )
   {
      if( CStackPos < Stack->count() - 1 ) 
      {
         Stack->swap( CStackPos, CStackPos + 1 );
         SetMode( 0 );
      }
   }
   else if( Action == ba2Top )
   {
      if( CStackPos > 0 )
      {
         Stack->totop( CStackPos );
         SetMode( 0 );
      }
   }
   else if( Action == baSto )
   {
      if( StoreResult( CStackPos ) )
      {
         SetMode( 0 );
      }
   }
   else
   {
      lProcessed = false;
   }
   if( lProcessed )
   {
      Refresh();
      Action = baUnknown;
   }
}
//---------------------------------------------------------------------------
void TCalcRPN::ExecAction( TButtonAction& Action )
{
   atom a;
   AnsiString p;
   bool lProcessed = true;
   bool lExit;
   char ChrValue;
   char digits[ 10 ] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };
   TButtonAction bdigit[ 10 ] = { ba0, ba1, ba2, ba3, ba4, ba5, ba6, ba7, ba8, ba9 };
   int j;
   
   TCalcObject::ExecAction( Action );
   if( Action == baUnknown || Child )
   {
      return;
   }

   if( Mode )
   {
      ExecActionMode1( Action );
      return;
   }
   
   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Eval( Action ) )
   {
      Action = baUnknown;
      return;
   }
   /*
   if( Action >= ba0 && Action <= ba9 )
   {
      for( j = 0, lExit = false; j < 10 && !lExit; j++ )
      {
         if( bdigit[ j ] == Action )
         {
            ChrValue = digits[ j ];
            lExit = true;
         }
      }
      LCD->InpLine->InsertText( AnsiString( ChrValue ) );
      //if( LCD->InputBuffer.Length() > 0 )
      //{
      //   Refresh();
      //}
   }
   else if( Action == baDot )
   {
      LCD->InpLine->InsertText( AnsiString( "." ) );
   }*/
   if( Action == baEnter )
   {
      p = LCD->InpLine->Buffer;
      //MessageBox( Owner->Handle, "Before", "", MB_OK );
      if( p.Length() > 0 )
      {
         Push( p );
         //LCD->InpLine->Clear();
      }
      else if( Stack->count() > 0 )
      {
         atom a = Stack->get( 0 );
         Stack->push( a );
      }
      //MessageBox( Owner->Handle, "After", "", MB_OK );
   }
   else if( Action == baBackSpace )
   {
      if( LCD->InpLine->Length() > 0 )
      {
         LCD->InpLine->BackSpace();
      }
      else
      {
         if( !Stack->drop( 0 ) )
         {
            ErrMsg( Stack->errmsg() );
         }
      }
   }
   else if( Action == baEex )
   {
      if( LCD->InpLine->Buffer.Pos( "E" ) <= 0 )
      {
         LCD->InpLine->InsertText( "E" );
      }
   }
	else if( Action == baPi )
	{
		Push( "Pi" );
	}
	else if( Action == baComplexI )
	{
		Push( "i" );
	}
   else if( Action == baClear )
   {
      Stack->clear();
   }
   else if( Action == baAdd )
   {
      Eval( sfAdd );
   }
   else if( Action == baSub )
   {
      Eval( sfSub );
   }
   else if( Action == baMul )
   {
      Eval( sfMul );
   }
   else if( Action == baDiv )
   {
      Eval( sfDiv );
   }
   else if( Action == baPercent )
   {
      Eval( sfPercent );
   }
   else if( Action == baPercentT )
   {
      Eval( sfPercentT );
   }
   else if( Action == baPercentCH )
   {
      Eval( sfPercentCH );
   }
   
   else if( Action == baFactorial )
   {
      Eval( sfFactorial );
   }
   else if( Action == baNeg )
   {
      j = LCD->InpLine->Buffer.Pos( "E" );
      if( j )
      {
         LCD->InpLine->SetSign();
      }
      else
      {
         Eval( sfNeg );
      }
   }
   else if( Action == baSign )
   {
      Eval( sfSign );
   }
   else if( Action == baAbs )
   {
      Eval( sfAbs );
   }
   else if( Action == baYpowX )
   {
      Eval( sfPow );
   }
   else if( Action == baXpow2 )
   {
      Eval( sfPow2 );
   }
   else if( Action == ba1perX )
   {
      Eval( sf1perX );
   }
   else if( Action == baSqrt )
   {
      Eval( sfSqrt );
   }
   else if( Action == baXRoot )
   {
      Eval( sfRootN );
   }
   else if( Action == baLn )
   {
      Eval( sfLn );
   }
   else if( Action == baLnp1 )
   {
      Eval( sfLnp1 );
   }
   else if( Action == baLog )
   {
      Eval( sfLog10 );
   }
   else if( Action == baExp )
   {
      Eval( sfExp );
   }
   else if( Action == baExpm )
   {
      Eval( sfExpm );
   }
   else if( Action == baALog )
   {
      //Eval( sfALog );
   }
   
   else if( Action == baSin )
   {
      Eval( sfSin );
   }
   else if( Action == baSinH )
   {
      Eval( sfSinH );
   }
   else if( Action == baASin )
   {
      Eval( sfASin );
   }
   else if( Action == baArgSH )
   {
      Eval( sfASinH );
   }
   
   else if( Action == baCos )
   {
      Eval( sfCos );
   }
   else if( Action == baCosH )
   {
      Eval( sfCosH );
   }
   else if( Action == baACos )
   {
      Eval( sfACos );
   }
   else if( Action == baArgCH )
   {
      Eval( sfACosH );
   }
   
   else if( Action == baTan )
   {
      Eval( sfTan );
   }
   else if( Action == baTanH )
   {
      Eval( sfTanH );
   }
   else if( Action == baATan )
   {
      Eval( sfATan );
   }
   else if( Action == baArgTH )
   {
      Eval( sfATanH );
   }
   
   else if( Action == baCtg )
   {
      Eval( sfCtg );
   }
   else if( Action == baCtgH )
   {
      Eval( sfCtgH );
   }
   else if( Action == baACtg )
   {
      Eval( sfACtg );
   }
   else if( Action == baArgCTH )
   {
      Eval( sfACtgH );
   }
   
   else if( Action == baSec )
   {
      Eval( sfSec );
   }
   else if( Action == baSecH )
   {
      Eval( sfSecH );
   }
   else if( Action == baASec )
   {
      Eval( sfASec );
   }
   else if( Action == baASecH )
   {
      Eval( sfASecH );
   }
   
   else if( Action == baCsc )
   {
      Eval( sfCsc );
   }
   else if( Action == baCscH )
   {
      Eval( sfCscH );
   }
   else if( Action == baACsc )
   {
      Eval( sfACsc );
   }
   else if( Action == baACscH )
   {
      Eval( sfACscH );
   }

   else if( Action == baDeg2Rad )
   {
      Eval( sfDeg2Rad );
   }
   else if( Action == baRad2Deg )
   {
      Eval( sfRad2Deg );
   }

   else if( Action == baReal2Complex )
   {
      Eval( sfReal2Complex );
   }
   else if( Action == baArg )
   {
      Eval( sfArg );
   }
   else if( Action == baConj )
   {
      Eval( sfConj );
   }
   else if( Action == baPolar )
   {
      Eval( sfPolar );
   }
   else if( Action == baNorm )
   {
      //Eval( sfNorm );
   }
   else if( Action == baRe )
   {
      Eval( sfReal );
   }
   else if( Action == baIm )
   {
      Eval( sfImag );
   }
   else if( Action == baIp )
   {
      Eval( sfIp );
   }
   else if( Action == baFp )
   {
      Eval( sfFp );
   }
   
   else if( Action == baEq )
   {
      Eval( sfEq );
   }
   else if( Action == baNEq )
   {
      Eval( sfNEq );
   }
   else if( Action == baLess )
   {
      Eval( sfLess );
   }
   else if( Action == baLessEq )
   {
      Eval( sfLessEq );
   }
   else if( Action == baGreat )
   {
      Eval( sfGreat );
   }
   else if( Action == baGreatEq )
   {
      Eval( sfGreatEq );
   }
   
   else if( Action == baAnd )
   {
      Eval( sfAnd );
   }
   else if( Action == baOr )
   {
      Eval( sfOr );
   }
   else if( Action == baXor )
   {
      Eval( sfXor );
   }
   else if( Action == baNot )
   {
      Eval( sfNot );
   }
   else if( Action == baIntDiv )
   {
      Eval( sfIntDiv );
   }
   else if( Action == baIntMod )
   {
      Eval( sfIntMod );
   }
   else if( Action == baSlb )
   {
      Eval( sfSlb );
   }
   else if( Action == baSrb )
   {
      Eval( sfSrb );
   }
   else if( Action == baRlb )
   {
      Eval( sfRlb );
   }
   else if( Action == baRrb )
   {
      Eval( sfRrb );
   }
   
   else if( Action == baCrossVector )
   {
      Eval( sfCross );
   }
   else if( Action == baDotVector )
   {
      Eval( sfDot );
   }
   else if( Action == baReal2Vector2 )
   {
      Eval( sfReal2Vector2 );
   }
   else if( Action == baReal2Vector3 )
   {
      Eval( sfReal2Vector3 );
   }
   
   else if( Action == baLength )
   {
      Eval( sfLength );
   }

   else if( Action == baConvert )
   {
      Eval( sfConvert );
   }
   
   else if( Action == baSum )
   {
      Eval( sfSum );
   }
   else if( Action == baAvg )
   {
      Eval( sfAvg );
   }
   else if( Action == baMin )
   {
      Eval( sfMin );
   }
   else if( Action == baMax )
   {
      Eval( sfMax );
   }
   
   else if( Action == ba2Bin )
   {
      Eval( sfBin );
   }
   else if( Action == ba2Dec )
   {
      Eval( sfDec );
   }
   else if( Action == ba2Hex )
   {
      Eval( sfHex );
   }
   else if( Action == ba2Oct )
   {
      Eval( sfOct );
   }
   
   else if( Action == baIsPrime )
   {
      Eval( sfIsPrime );
   }
   else if( Action == baGamma )
   {
      Eval( sfGamma );
   }
   else if( Action == baPsi )
   {
      Eval( sfPsi );
   }
   
   else if( Action == baEval )
   {
      Eval( sfEvalExp );
   }
   else if( Action == baNum )
   {
      Eval( sfNum );
   }
   else if( Action == baDeriv )
   {
      Eval( sfDeriv );
   }
   else if( Action == baDervx )
   {
      Eval( sfDervx );
   }
   else if( Action == baInteg )
   {
      Eval( sfInteg );
   }
   else if( Action == baIntvx )
   {
      Eval( sfIntvx );
   }
   else if( Action == baIntegN )
   {
      Eval( sfIntegN );

   }
   else if( Action == baSolve )
   {
      Eval( sfSolve );
   }
   else if( Action == baSolvx )
   {
      Eval( sfSolvx );
   }
   
   /*
   else if( Action == baCat )
   {
      Calc.CmdCatalog();
      Action = baUnknown;
      return;
      /*
      TCalcMenu* mnu = new TCalcMenu( Owner, this );
      mnu->SetCaption( "Test menu" );
      for( j = 0; j < 50; j++ )
      {
         mnu->AddItem( AnsiString( "ITEM " ) + IntToStr( j + 1 ), j + 1 );
      }      
      mnu->ShowModal();
      */
   //}

   else if( Action == baUp || Action == baHist )
   {
      if( Stack->count() )
      {
         SetMode( 1 );
      }
      else
      {
         lProcessed = false;
      }
   }
   /*
   else if( Action == baMode )
   {
      Calc.SetMode();
      Action = baUnknown;
      return;
   }
   */
   else if( Action == baCancel && LCD->InpLine->Buffer.Length() > 0 )
   {
      LCD->InpLine->Clear(); //Buffer = "";
   }
   else
   {
      LCD->InpLine->ExecAction( Action );
      if( Action != baUnknown )
      {
         lProcessed  = false;
      }
   }
   /*
   else if( Action == baLeft )
   {
      LCD->InpLine->CursorLeft( 1 );
   }
   else if( Action == baRight )
   {
      LCD->InpLine->CursorRight( 1 );
   }
   else if( Action == baHome )
   {
      LCD->InpLine->CursorHome();
   }
   else if( Action == baEnd )
   {
      LCD->InpLine->CursorEnd();
   }
   else
   {
      lProcessed = false;
   }
   */
   
   if( lProcessed )
   {
      Action = baUnknown;
      Refresh();
   }
}
//---------------------------------------------------------------------------
void TCalcRPN::InputChar( int Char )
{/*
   LCD->InsertToBuffer( (char)Char );
   Refresh();*/
}
//---------------------------------------------------------------------------
void TCalcRPN::SetMode( int AMode )
{
   Mode = AMode;
   switch( AMode )
   {
      case 0:
      DefFunc( 1, "", baUnknown );
      DefFunc( 2, "", baUnknown );
      DefFunc( 3, "", baUnknown );
      DefFunc( 4, "", baUnknown );
      DefFunc( 5, "PASTE", baPaste );
      DefFunc( 6, "CLEAR", baClear );
      CStackDispPos = 0;
      CStackPos = 0;
      CNewStackPos = 0;
      Owner->AllowMenu();
      break;

      case 1:
      DefFunc( 1, AnsiString( (char)16 ) + "TOP", ba2Top );
      DefFunc( 2, "SWAP", baSwap );
      DefFunc( 3, "ECHO", baEcho );
      DefFunc( 4, "DROP", baDrop );
      DefFunc( 5, "COPY", baCopy );
      DefFunc( 6, "CANCL", baCancel );
      Owner->DisallowMenu();
      break;
   }
}
//---------------------------------------------------------------------------
void TCalcRPN::ExecMenuCmd( int AMenuCmd )
{
}
//---------------------------------------------------------------------------
void TCalcRPN::BackSpace( void )
{/*
   AnsiString p;

   LCD->DeleteFromBuffer();
   p = LCD->InputBuffer;
   if( !p.Pos( DecSign ) )
   {
      DotPressed = false;
   }
   DisplayClear = false;*/
}
//---------------------------------------------------------------------------
bool TCalcRPN::StoreResult( int Index )
{
   AnsiString name;
   int res = mrCancel;
   int idx;
   atom a;
   atomlist* vars = Stack->getVariables();   
   
   if( vars && Stack->count() )
   {
      TInputBox* ib = new TInputBox( Owner, this );
      ib->SetPrompt( "Store to variable" );
      ib->SetStyle( ilsAllowSymbol );
      ib->SetButtons( btOk | btCancel );
      res = ib->ShowModal();
      name = ib->GetText();
      delete ib;
   
      if( res == mrOk )
      {
         if( Index == -1 )
         {
            a = Stack->pop();
         }
         else
         {
            a = Stack->get( Index );
         }
     
         if( ( name == "X" && ( a.type() == aDouble || a.type() == aInteger ) ) ||
             name != "X" )
         {
            idx = vars->findAtom( name );
            if( idx == -1 )
            {
               vars->addatom( new atom( a ), name.c_str() );
            }
            else
            {
               vars->replaceatom( idx, new atom( a ), name.c_str() );
            }
         }
      }
      Owner->setActiveObject( this );
   }
   else if( !vars )
   {
      ErrMsg( "(STO): No assigned variables!" );
   }
   else if( !Stack->count() )
   {
      ErrMsg( "(STO): Empty stack!" );
   }
   return ( res == mrOk );
}
//---------------------------------------------------------------------------
bool TCalcRPN::Push( AnsiString p )
{
   atom a;
   bool res;
   char buf[ 3 ];
   int const_index;
   int var_index;
   int func_index = -1;
   atomlist* constants;
   atomlist* variables;
   AnsiString msg;

   //sprintf( buf, "%s", p.c_str() );
   res = false;
   func_index = Stack->isfunc( p.c_str(), false );
   constants = Stack->getConstants();
   const_index = ( constants ? constants->findAtom( p.c_str() ) : -1 ); //Stack->isconst( p.c_str() );
   variables = Stack->getVariables();
   var_index = ( variables ? variables->findAtom( p.c_str() ) : -1 ); //Stack->isvar( p.c_str() );
   if( const_index >= 0 && constants )
   {
      a = constants->getAtom( const_index );
   }
   else if( var_index >= 0 && variables )
   {
      a = variables->getAtom( var_index );
   }
   else if( func_index >= 0 )
   {
   }
   else
   {
      a = str2atom( p.c_str() );//buf ); //atom( atof( p.c_str() ) );
   }

   if( !a.isnull() )
   {
      Stack->push( a );
      res = true;
   }
   else
   {
      res = Stack->evalcmd( p.c_str(), false );
      if( !res )
      {
        msg = Stack->errmsg();
      }
   }
   
   if( res )
   {
      LCD->InpLine->Clear();
   }
   else
   {
      ErrMsg( msg );
   }
   return res;
}
//---------------------------------------------------------------------------
bool TCalcRPN::Eval( TButtonAction Action )
{ 
   bool res = false;
   AnsiString p;
   
   if( Action == baConvert && LCD->InpLine->Buffer.Pos( "_" ) )
   {
   }
   else if( Action != baCancel && Action != baEnter )
   {
      p = LCD->InpLine->Buffer;
      if( p.Length() > 0 )
      {
         if( ( p[ 1 ] == '\"' && p[ p.Length() ] == '\"' ) ||
             ( p[ 1 ] == '\'' && p[ p.Length() ] == '\'' ) ||
             p.Pos( "_" )
           )
         {
            LCD->InpLine->ExecAction( Action );
            Refresh();
            res = true;
         }
      }
   }
   return res;
}
//---------------------------------------------------------------------------
void TCalcRPN::Eval( TStackFunc Func )
{ 
   AnsiString p;
   bool res = true;

   if( LCD->InpLine->Length() > 0 )
   {
      p = LCD->InpLine->Buffer;
      LCD->InpLine->Clear();
      res = Push( p );
   }
   
   if( res )
   {
      //ErrMsg( "Before Eval" );
      if( !( Stack->eval( Func ) ) )
      {
         ErrMsg( Stack->errmsg() );
      }
      else
      {
         //ErrMsg( "After Eval" );
      }
   }
/*
   if( Stack->Error )
   {
      ErrMsg( Stack->ErrorMsg );
   }  */
}
//---------------------------------------------------------------------------
//void TCalcRPN::ErrMsg( AnsiString Message )
//{
   //Owner->ErrMsg( Message );
//}
//---------------------------------------------------------------------------
/*
void TCalcRPN::SetAngleMeasure( TAngleMeasure Value )
{
   Stack->AngleMeasure = Value;
}
*/
//---------------------------------------------------------------------------
void TCalcRPN::SaveState( FILE* file )
{
   if( file )
   {
      Stack->save( file );
   }
}
//---------------------------------------------------------------------------
void TCalcRPN::SaveState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xmlnode* xstack;
         xmlnode* xatom;
         int j;
         atom a;
         
         xstack = xtree->addNode( "Stack", "", node );
         for( j = Stack->count() - 1; j >= 0; j-- )
         {
            a = Stack->get( j );
            xatom = xtree->addNode( "Atom", AnsiString( a.getstring( 12 ) ), xstack );
            xatom->setAttribute( "type", IntToStr( a.type() ) );
            xatom->setAttribute( "format", IntToStr( a.format() ) );
            xatom->setAttribute( "name", AnsiString( a.name() ) );
         }
      }     
   }
}
//---------------------------------------------------------------------------
void TCalcRPN::LoadState( FILE* file )
{
   if( file )
   {
      Stack->load( file );
      /*
      if( !strcmp( buf, "Stack" ) && readed == 5 )
      {
         //Stack->Load( file );
      }
      else
      {
         MessageBox( Owner->Handle, "Error loading stack objects!",
                     "Error!", MB_OK | MB_ICONERROR );
      }
      */
   }
}
//---------------------------------------------------------------------------
void TCalcRPN::LoadState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xmlnode* xstack = node->getNodeByName( "Stack" );
         if( xstack )
         {
            atom a;
            int type, format;
            xmlnode* n;
            AnsiString v, name;
            
            n = xstack->getFirstCh();
            while( n )
            {
               v = n->getValue();
               type = n->getAttrValue( "type" ).ToInt();
               format = n->getAttrValue( "format" ).ToInt();
               
               switch( type )
               {
                  case aInteger:
                  switch( format )
                  {
                     case aifBin:
                     a = atom( BinStrToInt( v ), aifBin );
                     break;
                     
                     case aifOct:
                     a = atom( OctStrToInt( v ), aifOct );
                     break;
                     
                     case aifHex:
                     a = atom( HexStrToInt( v ), aifHex );
                     break;
                     
                     default:
                     a = atom( v.ToInt(), format );
                     break;
                  }
                  break;
               
                  case aDouble:
                  switch( format )
                  {
                     case aifExp:
                     a = atom( StrEToDouble( v ), aifExp );
                     break;
                     
                     default:
                     a = atom( StrToDouble( v ), aifDec );
                     break;
                  }
                  break;
               
                  case aComplex:
                  a = atom( StrToComplex( v ), aifDec );
                  break;
               
                  case aMeasure:
                  switch( format )
                  {
                     case aifExp:
                     a = atom( StrToMeasure( v ), aifExp );
                     break;
                     
                     default:
                     a = atom( StrToMeasure( v ), aifDec );
                     break;
                  }
                  break;
                
                  default:
                  a = str2atom( v.c_str() );
                  break;
               }
               
               name = n->getAttrValue( "name" );
               if( name.Length() > 0 )
               {
                  a.setname( name.c_str() );
               }
               Stack->push( a );
               
               n = n->getNext();
            }
         }
      }
   }
}
//---------------------------------------------------------------------------
