#include <stdio.h>
#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif

#include "uCalcUnitConv.h"
#include "uCalcMnu.h"
#include "TInputBox.h"
//---------------------------------------------------------------------------
TCalcUnitConv::TCalcUnitConv( TCalc* AOwner )
   : TCalcObject( AOwner ),
     _result( -1 ),
     hPos( 0 ),
     hStart( 0 ),
     _parentName( "" ),
     _f6_text( "" ),
     _stack( NULL ),
     _inter( NULL ),
     basec( 0 ),
     basecidx( 0 ),
     baseu( "" ),
     baseuidx( 0 )
{
   SetName( "CalcUnitConv" );
 
   catStr = new TStringList();
   catDesc = new TStringList();
   uomStr = new TStringList();
   uomDesc = new TStringList();

   resUom = new TStringList();
   resVal = new TStringList();
      
   results = new atomlist();
   
   GetMeasureCategories( catStr, catDesc );
   
   value = 0.0;
   if( catStr->Count() > 0 )
   {
      basec = catStr->String( 0 ).ToInt();
      basecidx = 1;
      
      GetMeasuresInCategory( basec, uomStr, uomDesc );
      if( uomStr->Count() > 0 )
      {
         baseu = uomStr->String( 0 );
         baseuidx = 1;
         
         Calculate();
      }
   }
}
//---------------------------------------------------------------------------
TCalcUnitConv::~TCalcUnitConv( void )
{
   delete catStr;
   delete catDesc;
   delete uomStr;
   delete uomDesc;
   
   delete resUom;
   delete resVal;
   
   delete results;
}
//---------------------------------------------------------------------------
void TCalcUnitConv::setParentName( AnsiString AName )
{
   AnsiString p = AName.UpperCase();

   if( p.Pos( "RPN" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "STCK";
      _parentName = "RPN";
   }
   else if( p.Pos( "ALG" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "EXPR";
      _parentName = "ALG";
   }
   else
   {
   }
}
//---------------------------------------------------------------------------
void TCalcUnitConv::assignStack( atomstack* AStack )
{
   _stack = AStack;
}
//---------------------------------------------------------------------------
void TCalcUnitConv::assignInter( atominter* AInter )
{
   _inter = AInter;
}
//---------------------------------------------------------------------------
void TCalcUnitConv::Refresh( void )
{
   int j, ccount, rcount;
   int x, y;
   AnsiString p;
   char buf[ 20 ];
   
   LCD->begin();
   TCalcObject::Refresh();
   
   rcount = LCD->rowCount() - 1;
   ccount = LCD->colCount() - 5 - 2;

   LCD->fillRect( 0, LCD->trheight(), LCD->width() - 1,
                  LCD->height() - LCD->trheight() - LCD->brheight(), LCD->backcolor() );
						
   for( j = 0, p = ""; j < LCD->colCount(); j++ )
   {
      p += AnsiString( (char)( 31 ) );
   }
   LCD->printText( 0, rcount, p );
   p = "[UNIT CONVERTER]";
   LCD->printText( ( LCD->colCount() - p.Length() ) / 2, rcount, p );

   LCD->printText( 0, rcount - 1, "CAT. :" );
   LCD->printText( 7, rcount - 1, basecidx ? catDesc->String( basecidx - 1 ) : AnsiString( "?" ) );

   sprintf( buf, "%s %s", DoubleToStr( value ).c_str(), baseu.c_str() ); 
   LCD->printText( 0, rcount - 2, "VALUE:" );
   LCD->printText( 7, rcount - 2, AnsiString( buf ) );

   for( j = 0, p = ""; j < LCD->colCount(); j++ )
   {
      p += AnsiString( "-" );
   }
   LCD->printText( 0, rcount - 3, p );
   
   for( j = 0; j <= rcount - 4; j++ )
   {
      if( j + hStart < resUom->Count() && j + hStart < results->count() )
      {
         sprintf( buf, "= %-s %s", results->getAtom( j + hStart ).getstring(), resUom->String( j + hStart ).SubString( 1, 5 ).c_str() ); // resVal->String( j + hStart ).c_str() );
         //sprintf( buf, "%-5s: %-s", resUom->String( j + hStart ).SubString( 1, 5 ).c_str(), results->getAtom( j + hStart ).getstring() ); // resVal->String( j + hStart ).c_str() );
         LCD->printText( 0, rcount - 4 - j, AnsiString( buf ) );
      }
   }
   LCD->invertRow( rcount - 4 - hPos );
   
   if( Child )
   {
      Child->Refresh();
   }
   LCD->end();
}
//---------------------------------------------------------------------------
void TCalcUnitConv::Activate( void )
{
   Open();
   
   hPos = 0;
   hStart = 0;
   
   DefFunc( 1, "CAT", baA );
   DefFunc( 2, "VALUE", baB );
   DefFunc( 3, "UNIT", baC );
   DefFunc( 4, "", baUnknown );
   DefFunc( 5, "CLOSE", baCancel );
   DefFunc( 6, _f6_text, baOk );
   Owner->DisallowMenu();
}
//---------------------------------------------------------------------------
void TCalcUnitConv::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;
   int rcount = LCD->rowCount() - 4;
   AnsiString p;

   TCalcObject::ExecAction( Action );
   if( Action == baUnknown || Child )
   {
      return;
   }

   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Action == baOk )
   {
      if( _stack && _parentName == "RPN" )
      {
         double x = *((double*)( results->getAtom( hPos + hStart ).value() ));
         int fmt = results->getAtom( hPos + hStart ).format();
         p = resUom->String( hPos + hStart );
         atom a = atom( CMeasure( x, CUnit( p ) ), fmt );
         _stack->push( a );
      }
      Close();
   }
   else if( Action == baCancel )
   {
      Close();
   }
   else if( Action == baA )
   {
      SelectCategory();
   }   
   else if( Action == baB )
   {
      EditValue();
   }
   else if( Action == baC )
   {
      SelectUOM();
   }
   else if( Action == baDown )
   {
      if( hPos < rcount - 1 )
      {
         hPos++;
      }
      else if( hPos + hStart < resUom->Count() - 1 )
      {
         hStart++;
      }
   }
   else if( Action == baUp )
   {
      if( hPos > 0 )
      {
         hPos--;
      }
      else if( hPos + hStart > 0 )
      {
         hStart--;
      }
   }
   else
   {
      lProcessed = false;
   }
   
   if( lProcessed )
   {
      Action = baUnknown;
      #ifndef __WIN32__
      Refresh();
      #endif
   }
}
//---------------------------------------------------------------------------
void TCalcUnitConv::EditValue( void )
{
   int res;
   AnsiString str_value;
   
   TInputBox* ib = new TInputBox( Owner, this );
   ib->SetPrompt( "Input Value" );
   ib->SetStyle( ilsAllowNumber | ilsAllowDot );
   ib->SetButtons( btOk | btCancel );
   if( value > 0.0 )
   {
      ib->SetText( DoubleToStr( value ) );
   }
   else
   {
   }
   res = ib->ShowModal();
   str_value = ib->GetText();
   delete ib;
   
   if( res == mrOk )
   {
      value = StrToDouble( str_value );
      Calculate();
   }
   Owner->setActiveObject( this );
}
//---------------------------------------------------------------------------
void TCalcUnitConv::SelectCategory( void )
{
   int j, res;
   
   TCalcMenu* mnu = new TCalcMenu( Owner, this );
   mnu->SetCaption( "*** MEASURE CATEGORIES ***" );
   for( j = 0; j < catStr->Count(); j++ )
   {
      mnu->AddItem( IntToStr( j + 1 ) + "." + catDesc->String( j ).UpperCase(),
                    (TButtonAction)( j + 1 ) );
   }
   res = mnu->ShowModal();
   delete mnu;
   
   if( res > 0 )
   {
      basecidx = res;
      basec = catStr->String( basecidx - 1 ).ToInt();
      GetMeasuresInCategory( basec, uomStr, uomDesc );
      if( uomStr->Count() > 0 )
      {
         baseu = uomStr->String( 0 );
         baseuidx = 1;
         
         Calculate();
      }
      else
      {
         baseu = 0;
         baseuidx = 0;
      }
   }
   Owner->setActiveObject( this );   
}
//---------------------------------------------------------------------------
void TCalcUnitConv::SelectUOM( void )
{
   int j, res;
   
   TCalcMenu* mnu = new TCalcMenu( Owner, this );
   mnu->SetCaption( "*** BASE UNIT ***" );
   for( j = 0; j < uomStr->Count(); j++ )
   {
      mnu->AddItem( IntToStr( j + 1 ) + "." + uomDesc->String( j ).UpperCase(),
                    (TButtonAction)( j + 1 ) );
   }
   res = mnu->ShowModal();
   delete mnu;
   
   if( res > 0 )
   {
      baseuidx = res;
      baseu = uomStr->String( baseuidx - 1 );
      
      Calculate();
   }
   
   Owner->setActiveObject( this );   
}
//---------------------------------------------------------------------------
void TCalcUnitConv::Calculate( void )
{
   atom a;
   AnsiString p;
   int j, uom;
   CMeasure m;
   double x;
   double min_x, max_x;

   for( j = 0, min_x = 1.0, max_x = 1.0; j < Owner->Precision(); j++ )
   {
      min_x /= 10.0;
      max_x *= 10.0;
   }
   
   resUom->Clear();
   resVal->Clear();
   results->clear();
   
   for( j = 0; j < uomStr->Count(); j++ )
   {
      //uom = uomStr->String( j );
      if( j != baseuidx - 1 )
      {
         m = CMeasure( value, baseu );
         x = m.ConvertTo( CUnit( uomStr->String( j ) ) ).GetValue();
         resUom->Add( uomStr->String( j ) );
         //a = atom( x, aifExp );
         if( x >= min_x && x <= max_x )
         {
            results->addatom( new atom( x, aifDec ) );
         }
         else
         {
            results->addatom( new atom( x, aifExp ) );
         }
         //MessageBox( Owner->Handle, ( "J=" + IntToStr( j ) + "; X=" + DoubleToStr( x ) + "; A=" + a.getstring() ).c_str(), "Double X", MB_OK );
         //resVal->Add( DoubleToStrF( x, 5 ) ); // Owner->Precision() ) );
      }
   }
   hPos = 0;
   hStart = 0;
}
//---------------------------------------------------------------------------
void TCalcUnitConv::SaveState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xtree->addNode( "Category", IntToStr( basec ), node );
         xtree->addNode( "BaseUnit", baseu, node );
         xtree->addNode( "Value", DoubleToStr( value ), node );
      }
   }
}
//---------------------------------------------------------------------------
void TCalcUnitConv::LoadState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         basec = node->readInteger( "Category" );
         baseu = node->readString( "BaseUnit" );
         value = node->readDouble( "Value" );
         
         GetMeasuresInCategory( basec, uomStr, uomDesc );

         basecidx = catStr->IndexOf( IntToStr( basec ) ) + 1;
         //MessageBox( Owner->Handle, ( "Index Of BaseC=" + IntToStr( basec ) + " is " + IntToStr( basecidx ) ).c_str(), "", MB_OK );
         baseuidx = uomStr->IndexOf( baseu ) + 1;
         //MessageBox( Owner->Handle, ( "Index Of BaseU=" + baseu + " is " + IntToStr( baseuidx ) ).c_str(), "", MB_OK );

         Calculate();
      }
   }
}
//---------------------------------------------------------------------------

