#ifndef _UCALCUNITCONV_H
#define _UCALCUNITCONV_H

#include "astack.h"
#include "ainter.h"
#include "ucalcobj.h"
//---------------------------------------------------------------------------
class TCalcUnitConv : public TCalcObject
{
   private:
   int _result;
   int hPos, hStart;
   AnsiString _parentName;
   AnsiString _f6_text;
   atomstack* _stack;
   atominter* _inter;
   
   TStringList* catStr;
   TStringList* catDesc;
   TStringList* uomStr;
   TStringList* uomDesc;
   TStringList* resUom;
   TStringList* resVal;
   
   atomlist* results;
   
   double value;
   int basec, basecidx, baseuidx;
   AnsiString baseu;
   
   public:
   TCalcUnitConv( TCalc* AOwner );
   ~TCalcUnitConv( void );
   
   void setParentName( AnsiString AName );
   void assignStack( atomstack* AStack );
   void assignInter( atominter* AInter );
   
   void Refresh( void );
   void Activate( void );
   void ExecAction( TButtonAction& Action );

   void EditValue( void );   
   void SelectCategory( void );
   void SelectUOM( void );
   
   void Calculate( void );

   void SaveState( xmlnode* node );
   void LoadState( xmlnode* node );
};
//---------------------------------------------------------------------------
#endif // _UCALCUNITCONV_H
