#include "uCalcWin.h"

#ifdef __WIN32__
#include "TCalc.h"
#else
#include "qmessagebox.h"
#include "arect.h"
#include "pgcalc.h"
#endif
//---------------------------------------------------------------------------
//
//
//---------------------------------------------------------------------------
TCalcScrollBar::TCalcScrollBar( TLCDDisplay* ALcd )
{
   _lcd = ALcd;
   _min = 0;
   _max = 0;
   _pos = 0;
   _page = 0;
   _style = csbVert;
   _left = 0;
   _top = 0;
   _width = 0;
   _height = 0;
}
//---------------------------------------------------------------------------
TCalcScrollBar::~TCalcScrollBar()
{
}
//---------------------------------------------------------------------------
void TCalcScrollBar::SetBounds( int Left, int Top, int Width, int Height )
{
   _left = Left;
   _top = Top;
   _width = Width;
   _height = Height;
}
//---------------------------------------------------------------------------
void TCalcScrollBar::SetLayout( double Min, double Max, double Page )
{
   _min = Min;
   _max = Max;
   _page = Page;
}
//---------------------------------------------------------------------------
void TCalcScrollBar::SetStyle( TCalcScrollBarStyle Style )
{
   _style = Style;
}
//---------------------------------------------------------------------------
void TCalcScrollBar::SetPosition( double Pos )
{
   _pos = Pos;
}
//---------------------------------------------------------------------------
void TCalcScrollBar::Draw( void )
{
   RECT r;
   
   if( !_lcd || _page >= _max - _min )
   {
      return;
   }
   
   r.left = _left;
   r.top = _top;
   r.right = r.left + _width;
   r.bottom = r.top + _height;

   #ifdef __WIN32__
   Canvas* c = _lcd->GetCanvas();
   c->Rectangle( _left, _top, _left + _width, _top + _height );
   #else
   _lcd->drawRect( _left, _top, _width, _height );
   #endif
   if( _style == csbVert )
   {
      double ph = ( _page * (double)( _height - 2 ) ) / ( _max - _min );
      double py = ( _height - ph ) / ( _max - _min );
      
      r.left = _left + 1;
      r.top = _top + (int)( py * _pos ) + 1;
      r.right = _left + _width - 1;
      r.bottom = r.top + (int)ph - 1;

      #ifdef __WIN32__
      _lcd->invertRect( r );
      #else
      _lcd->invertRect( r );
      #endif
   }
}
//---------------------------------------------------------------------------
//
//
//---------------------------------------------------------------------------
TCalcWin::TCalcWin( TCalc* AOwner, TCalcObject* AParent )
   : TCalcObject( AOwner, AParent )
{
   FCenter = true;
   FInvertCaption = false;
   SetName( "TCalcWin" );
   if( LCD )
   {
      #ifdef __WIN32__
      FWidth = LCD->Width - 20;
      FHeight = LCD->Height - ( LCD->TRHeight + LCD->BRHeight ) - 20;
      FLeft = ( LCD->Width - FWidth ) / 2;
      FTop = LCD->TRHeight + ( ( LCD->Height - ( LCD->TRHeight + LCD->BRHeight ) - FHeight ) / 2 );
      #else
      FWidth = LCD->width() - 20;
      FHeight = LCD->height() - ( LCD->trheight() + LCD->brheight() ) - 20;
      FLeft = ( LCD->width() - FWidth ) / 2;
      FTop = LCD->trheight() + ( ( LCD->height() - ( LCD->trheight() + LCD->brheight() ) - FHeight ) / 2 );
      #endif
   }
}
//---------------------------------------------------------------------------
TCalcWin::~TCalcWin()
{
   if( Parent )
   {
      Parent->SetChild( NULL );
   }
}
//---------------------------------------------------------------------------
void TCalcWin::SetBounds( int Left, int Top, int Width, int Height )
{
   if( FCenter )
   {
      FWidth = Width;
      FHeight = Height;
      #ifdef __WIN32__
      FLeft = ( LCD->Width - FWidth ) / 2;
      FTop = LCD->TRHeight + ( ( LCD->Height - ( LCD->TRHeight + LCD->BRHeight ) - FHeight ) / 2 );
      #else
      FLeft = ( LCD->width() - FWidth ) / 2;
      FTop = LCD->trheight() + ( ( LCD->height() - ( LCD->trheight() + LCD->brheight() ) - FHeight ) / 2 );
      #endif
   }
   else
   {
      FLeft = Left;
      FTop = Top;
      FWidth = Width;
      FHeight = Height;
   }
}
//---------------------------------------------------------------------------
void TCalcWin::SetShadow( int Shadow )
{
   FShadow = Shadow;
}
//---------------------------------------------------------------------------
void TCalcWin::SetCaption( AnsiString ACaption )
{
   FCaption = ACaption;
}
//---------------------------------------------------------------------------
void TCalcWin::SetInvertCaption( bool AValue )
{
   FInvertCaption = AValue;
}
//---------------------------------------------------------------------------
void TCalcWin::SetCenter( bool ACenter )
{
   FCenter = ACenter;
   SetBounds( FLeft, FTop, FWidth, FHeight );
}
//---------------------------------------------------------------------------
void TCalcWin::SetButtons( int AButtons )
{
   FButtons = AButtons;
}
//---------------------------------------------------------------------------
void TCalcWin::Refresh( void )
{
   RECT r;
   int j;

   LCD->begin();
   
   TCalcObject::Refresh();
   LCD->drawRect( FLeft, FTop, FWidth, FHeight );
   
   for( j = 0; j < FShadow; j++ )
   {
      LCD->drawLine( FLeft + j, FTop + FHeight + j,
                     FLeft + FWidth + j, FTop + FHeight + j );
      LCD->drawLine( FLeft + FWidth + j, FTop + FHeight + j,
                     FLeft + FWidth + j, FTop + j );
   }
   LCD->fillRect( FLeft + 1, FTop + 1, FWidth - 2, FHeight - 2, LCD->backcolor() );
   
   if( FCaption.Length() > 0 )
   {
      int x = FLeft + ( FWidth - FCaption.Length() * LCD->SmFont->fontWidth() ) / 2;
      int y = FTop + 2;

      LCD->drawText( x, y, FCaption.c_str(), LCD->SmFont );
      r.left = FLeft + 1;
      r.top = FTop + 1;
      r.right = r.left + FWidth - 2;
      r.bottom = r.top + LCD->SmFont->fontHeight() + 2;
      if( FInvertCaption )
      {
         LCD->invertRect( r );
      }
      else
      {
         LCD->drawLine( r.left + 1, r.bottom, r.right - 1, r.bottom );
      }
      //LCD->fillRect( FLeft + 1, r.bottom + 1, FWidth - 2, FHeight - ( LCD->SmFont->fontHeight() + 4 ), LCD->backcolor() );
   }
   //Owner->repaint( LCD->left(), LCD->top(), LCD->width(), LCD->height(), false );
   //Owner->update( LCD->left(), LCD->top(), LCD->width(), LCD->height() );
   LCD->end();
}
//---------------------------------------------------------------------------
void TCalcWin::Activate( void )
{
   if( Parent )
   {
      Parent->SetChild( this );
      StoreFunc();
   }

   Open();
   DefFunc( 1, FButtons & btYes ? "YES" : "", FButtons & btYes ? baYes : baUnknown );
   DefFunc( 2, FButtons & btNo ? "NO" : "", FButtons & btNo ? baNo : baUnknown );
   DefFunc( 3, "", baUnknown );
   DefFunc( 4, "", baUnknown );
   DefFunc( 5, FButtons & btCancel ? "CANCL" : "", FButtons & btCancel ? baCancel : baUnknown );
   DefFunc( 6, FButtons & btOk ? "OK" : "", FButtons & btOk ? baOk : baUnknown );
   
   Refresh();
}
//---------------------------------------------------------------------------
void TCalcWin::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;

   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
      //QMessageBox::information( Owner, "Msg", "Dostalem!" );
   }

   if( Action == baClose )
   {
      Result = mrNone;
      Close();
      //SendMessage( Owner->Handle, WM_DESTROY, 0, 0 );
   }
   else if( Action == baCancel )
   {
      Result = mrCancel;
      Close();

      //RestoreFunc();
   }
   else if( Action == baOk || Action == baEnter )
   {
      Result = mrOk;
      Close();
   }
   else if( Action == baYes )
   {
      Result = mrYes;
      Close();
   }
   else if( Action == baNo )
   {
      Result = mrNo;
      Close();
   }
   else
   {
      lProcessed = false;
   }
   if( lProcessed )
   {
      //fprintf( stderr, "Action processed by TCalcWin (Action=%d, _result=%d)\n", (int)( Action ), _result );
      //Refresh();
      Action = baUnknown;
   }
}
//---------------------------------------------------------------------------
int TCalcWin::ShowModal( void )
{
	return TCalcObject::ShowModal();
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
TCalcMsgBox::TCalcMsgBox( TCalc* AOwner, TCalcObject* AParent, AnsiString AMsg )
   : TCalcWin( AOwner, AParent )
{
   FMsg = AMsg;
   FStrings = new TStrings();
   SetMsgLines();
}
//---------------------------------------------------------------------------
TCalcMsgBox::~TCalcMsgBox()
{
   delete FStrings;
}
//---------------------------------------------------------------------------
void TCalcMsgBox::SetMsgLines()
{
   AnsiString p;
   int start, stop, space;
   int w, h;
   bool lExit;
   
   //MessageBox( 0, FMsg.c_str(), "", MB_OK );
   FStrings->Clear();
   w = LCD->width() - 10;//4 * LCD->Font->FontWidth;
   start = 1;
   stop = 1;
   space = -1;
   lExit = false;
   while( !lExit )
   {
      if( stop >= FMsg.Length() )
      {
         p = FMsg.SubString( start, FMsg.Length() );
         FStrings->Add( p );
         lExit = true;
      }
      else if( FMsg[ stop ] == '\n' )
      {
         p = FMsg.SubString( start, stop - start );
         FStrings->Add( p );
         stop++;
         start = stop;
      }
      else if( FMsg[ stop ] == ' ' )
      {
         space = stop;
         stop++;
      }
      else
      {
         stop++;
      }

      if( ( stop - start + 2 ) * LCD->Font->fontWidth() > w )

      {
         if( space > start )
         {
               p = FMsg.SubString( start, space - start );
               FStrings->Add( p );
               start = space + 1;
               stop = start;
               space = -1;

         }
         else
         {
               p = FMsg.SubString( start, stop - start ) + AnsiString( "-" );
               FStrings->Add( p );
               start = stop + 1;


               stop++;
         }
      }
   }
   if( FStrings->Count() > 0 )
   {
      h = LCD->SmFont->fontHeight() + 4 + LCD->Font->fontHeight() * FStrings->Count() + 2;
   }
   else
   {
      //MessageBox( 0, FStrings->Text().c_str(), "FStrings", MB_OK );
      h = 100;
   }
   SetShadow( 2 );
   SetCenter( true );
   SetBounds( 0, 0, w, h );
}
//---------------------------------------------------------------------------
void TCalcMsgBox::Refresh( void )
{
   int x, y, j;
   AnsiString p;
   
   if( !LCD )
   {
      return;
   }

   LCD->begin();
   
   TCalcWin::Refresh();
   y = FTop + LCD->SmFont->fontHeight() + 5;
   for( j = 0; j < FStrings->Count(); j++ )
   {
      p = FStrings->String( j );
      x = FLeft + ( FWidth - p.Length() * LCD->Font->fontWidth() ) / 2;
      LCD->drawText( x, y, p.c_str(), LCD->Font ); 
      y += LCD->Font->fontHeight();
   }
   LCD->end();
}
//---------------------------------------------------------------------------
//
//
//
//---------------------------------------------------------------------------
void CalcMsg( AnsiString AMessage, AnsiString ACaption )
{
   TCalcObject* AParent = Calc->activeObject();
   TCalcMsgBox* msg = new TCalcMsgBox( Calc, AParent, AMessage );
   msg->SetName( "MsgBox" );
   msg->SetCaption( AnsiString( "*** " ) + ACaption.UpperCase() + AnsiString( " ***" ) ); 
   msg->SetInvertCaption( true );
   msg->SetButtons( btOk );
   msg->ShowModal();
   delete msg;

	Calc->setActiveObject( AParent );
}
//---------------------------------------------------------------------------
void ErrMsg( AnsiString AMessage, AnsiString ACaption )
{
   TCalcObject* AParent = Calc->activeObject();
   TCalcMsgBox* msg = new TCalcMsgBox( Calc, AParent, AMessage );

   msg->SetName( "ErrMsgBox" );
   msg->SetCaption( ACaption.UpperCase() ); 
   msg->SetInvertCaption( true );
   msg->SetButtons( btOk );
   //for( int j = 100; j < 700; j += 100 )
   //{
   //   Beep( 200, 30 );
   //}
   msg->ShowModal();
   delete msg;

   //AParent->closeChild();
	Calc->setActiveObject( AParent );
}
//---------------------------------------------------------------------------
int ConfirmMsg( AnsiString AMessage, AnsiString ACaption )
{
   int res;
   
   TCalcObject* AParent = Calc->activeObject();
   TCalcMsgBox* msg = new TCalcMsgBox( Calc, AParent, AMessage );
   msg->SetName( "ConfirmMsgBox" );
   msg->SetCaption( AnsiString( "*** " ) + ACaption.UpperCase() + AnsiString( " ***" ) ); 
   msg->SetInvertCaption( true );
   msg->SetButtons( btYesNoCancel );
   res = msg->ShowModal();
	delete msg;
	
   //AParent->closeChild(); //delete msg;
	Calc->setActiveObject( AParent );
   
   return res;
}
//---------------------------------------------------------------------------

