//---------------------------------------------------------------------------
#include <math.h>

#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif

#include "ucalcobj.h"

//---------------------------------------------------------------------------
TCalcObject::TCalcObject( TCalc* AOwner, TCalcObject* AParent )
{
   char buf[ 101 ];

   #ifdef __WIN32__
   tmpCanvas = NULL;
   hBmp = NULL;
   #else
   #endif
   
   Child = NULL;
   Owner = AOwner;
   Parent = AParent;
   FClosed = false;
   FModal = false;
   if( Owner )
   {
      LCD = Owner->GetLCD();
   }
   else
   {
      LCD = NULL;
   }

   //GetLocaleInfo( LOCALE_USER_DEFAULT,
   //               LOCALE_SDECIMAL,
   //               buf,
   //               100 );
   DecSign = AnsiString( buf );
   //FSeparator = ";";
   FSeparator = ",";
   Name = "CalcObject";
   MenuPos = new TStrings();
}
//---------------------------------------------------------------------------
TCalcObject::~TCalcObject( )
{
   delete MenuPos;
   
   if( Child )
   {
      delete Child;
   }
}
//---------------------------------------------------------------------------
bool TCalcObject::IsClosed( )
{
   return FClosed;
}
//---------------------------------------------------------------------------
bool TCalcObject::HasChild( )
{
   if( Child )
   {
      return true;
   }
   else
   {
      return false;
   }
}
//---------------------------------------------------------------------------
bool TCalcObject::IsModal( void ) 
{ 
   return FModal; 
}
//---------------------------------------------------------------------------
bool TCalcObject::IsModalEx( void )
{
   bool lResult = false;
   
   if( Child )
   {
      lResult = Child->IsModalEx();
   }         
   else
   {
      lResult = FModal;
   }
   return lResult;     
}   
//---------------------------------------------------------------------------
TCalcObject* TCalcObject::GetChild( void )
{
   return Child;
}
//---------------------------------------------------------------------------
void TCalcObject::SetChild( TCalcObject* AChild )
{
   Child = AChild;
}
//---------------------------------------------------------------------------
void TCalcObject::closeChild( void )
{
   if( Child )
   {
      Child->Close();
      delete Child;
   }
   Child = NULL;
   Calc->setActiveObject( this );
   Calc->repaint();
}
//---------------------------------------------------------------------------
TLCDDisplay* TCalcObject::GetLCD( void )
{
   return LCD;
}
//---------------------------------------------------------------------------
void TCalcObject::SetName( AnsiString AName )
{
   Name = AName;
}
//---------------------------------------------------------------------------
AnsiString TCalcObject::GetName( void )
{
   return Name;
}
//---------------------------------------------------------------------------
void TCalcObject::Open( )
{
   FClosed = false;
}
//---------------------------------------------------------------------------
void TCalcObject::Close( )
{
   FClosed = true;
   if( FuncStored )
   {
      RestoreFunc();
   }
}
//---------------------------------------------------------------------------
void TCalcObject::Refresh( void )
{
   if( Child )
   {
      Child->Refresh();
   }
   else if( LCD )
   {
      LCD->drawHeaders();
      LCD->drawFuncKeys();
   }
}
//---------------------------------------------------------------------------
void TCalcObject::Activate( void )
{
   Refresh();
}
//---------------------------------------------------------------------------
void TCalcObject::ExecAction( TButtonAction& Action )
{
   if( Child )
   {
      //fprintf( stderr, "Child Name: %s -> Action(%d)\n", Child->GetName().c_str(), (int)( Action ) );
      Child->ExecAction( Action );
      if( Child->IsClosed() )
      {
         //delete Child;
         Child = NULL;
         Action = baUnknown;

      }
   }
}
//---------------------------------------------------------------------------
void TCalcObject::InputChar( int Char )
{
   //Beep( 1500, 30 );
}
//---------------------------------------------------------------------------
void TCalcObject::DefFunc( int FuncNumber, AnsiString Descr,
                                TButtonAction Action)
{
   if( FuncNumber > 0 && FuncNumber < 7 )
   {
      Func[ FuncNumber - 1 ].Action = Action;
      Func[ FuncNumber - 1 ].Descr = Descr;
      #ifdef __WIN32__
      LCD->SetFuncKey( FuncNumber, Descr );
      #else
      LCD->setFuncKey( FuncNumber, Descr.c_str() );
      #endif
   }
}
//---------------------------------------------------------------------------
void TCalcObject::ClearFunc( int FuncNumber )
{
   if( FuncNumber > 0 && FuncNumber < 7 )
   {
      Func[ FuncNumber - 1 ].Action = baUnknown;
      Func[ FuncNumber - 1 ].Descr = "";
      #ifdef __WIN32__
      LCD->SetFuncKey( FuncNumber, "" );
      #else
      LCD->setFuncKey( FuncNumber, "" );
      #endif
   }
}
//---------------------------------------------------------------------------
void TCalcObject::ClearAllFunc( void )
{
   for( int j = 1; j <= 6; j++ )
   {
      ClearFunc( j );
   }
}
//---------------------------------------------------------------------------
void TCalcObject::StoreFunc( void )
{
   int j;

   for( j = 0; j < 6; j++ )
   {
      OldFunc[ j ].Action = Parent ? Parent->GetFunc( j + 1 ) : baUnknown;
      OldFunc[ j ].Descr = LCD->FuncKey[ j ];
      ClearFunc( j + 1 );
   }
   FuncStored = true;
}
//---------------------------------------------------------------------------
void TCalcObject::RestoreFunc( void )
{
   int j;

   if( FuncStored && Parent )
   {
      for( j = 0; j < 6; j++ )
      {
         Parent->DefFunc( j + 1, OldFunc[ j ].Descr, OldFunc[ j ].Action );
      }
      FuncStored = false;
   }
}
//---------------------------------------------------------------------------
TButtonAction TCalcObject::GetFunc( int FuncNumber )
{
   TButtonAction res = baUnknown;

   if( FuncNumber > 0 && FuncNumber < 7 )
   {
      res = Func[ FuncNumber - 1 ].Action;
      //QMessageBox::information( Owner, "Func Key", Func[ FuncNumber - 1 ].Descr.c_str() );
   }
   return res;
}
//---------------------------------------------------------------------------
TButtonAction TCalcObject::GetFunc( TButtonAction FuncNumber )
{
   TButtonAction tab[ 6 ] = { baF1, baF2, baF3, baF4, baF5, baF6 };
   int j, act;
   TButtonAction res = baUnknown;
   bool lExit;

   for( j = 0, lExit = false, act = -1; j < 6 && !lExit; j++ )
   {
      if( tab[ j ] == FuncNumber )
      {
         act = j + 1;
         lExit = true;
      }
   }
   if( act != -1 )
   {
      res = GetFunc( act );
   }
   return res;
}
//---------------------------------------------------------------------------
TFunctionKey TCalcObject::GetFuncKey( int KeyNum )
{
   TFunctionKey key;
   
   if( KeyNum >= 1 && KeyNum <= 6 )
   {
      return Func[ KeyNum - 1 ];
   }
   return key;
}
//---------------------------------------------------------------------------
/*
void TCalcObject::StoreRect( RECT& src )
{
   RECT dst;

   if( tmpCanvas )
   {
   }
   else
   {
      dst.left = 0;
      dst.top = 0;
      dst.right = src.right - src.left + 1;
      dst.bottom = src.bottom - src.top + 1;

      hBmp = (HBITMAP)CreateCompatibleBitmap( LCD->GetCanvas()->GetHDC(), dst.right, dst.bottom );
      tmpCanvas = new BitmapCanvas( LCD->GetCanvas()->GetHDC(), hBmp );

      BitBlt( tmpCanvas->GetHDC(), dst.left, dst.top, dst.right, dst.bottom,              //target dc
              LCD->GetCanvas()->GetHDC(), //hMemDC,               //source dc
              src.left, src.top,                 //left-top to take bitmap from source
              SRCCOPY );             //flag for blt operation - here it's just a copy
   }
}
//---------------------------------------------------------------------------
void TCalcObject::RestoreRect( RECT& dst )
{
   RECT src;

   if( tmpCanvas )
   {
      //src.left = 0;
      //src.top = 0;
      //src.right = dst.right - dst.left + 1;
      //src.bottom = dst.bottom - dst.top + 1;

      BitBlt( LCD->GetCanvas()->GetHDC(), dst.left, dst.top, dst.right, dst.bottom,              //target dc
              tmpCanvas->GetHDC(), //hMemDC,               //source dc
              0, 0,                 //left-top to take bitmap from source
              SRCCOPY );             //flag for blt operation - here it's just a copy

      delete tmpCanvas;
      DeleteObject( hBmp );
   }
   else
   {
   }
} */
//---------------------------------------------------------------------------
void TCalcObject::SaveState( FILE* file )
{
}
//---------------------------------------------------------------------------
void TCalcObject::LoadState( FILE* file )
{
}
//---------------------------------------------------------------------------
int TCalcObject::ShowModal( void )
{
	FModal = true;
	
   #ifdef __WIN32__
   MSG msg;

   Activate();   
   while( !IsClosed() ) // msg.message != WM_QUIT ) //&& Calc.Handle )
   {
      if( GetMessage( &msg, NULL, 0, 0 ) )
      {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
      }
      //else
      //{
      //      Close();
      //}
   }
	#else
   Calc->setActiveObject( this );

   Result = -1;
   while( !IsClosed() ) //&& !Calc->Terminated() ) // msg.message != WM_QUIT )
   {
      App->processEvents();
   }
   #endif
	
	FModal = false;
	return Result;
}
//---------------------------------------------------------------------------

