/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef LOCALFILEPLUGIN_H
#define LOCALFILEPLUGIN_H

#include "plugins.h"
#include "plugininfo.h"

class QFile;

class QHaccTable;
class QHaccTableIndex;

class LocalFileDBInfo : public PluginInfo {
 public:
	LocalFileDBInfo();
};

class LocalFileDBPlugin : public QHaccDBPlugin {
 public:
	static const LocalFileDBInfo pinfo;

	LocalFileDBPlugin();
	virtual ~LocalFileDBPlugin();
	
	bool connect( QHacc * engine, const QString& home, QString& error );
	bool load( Table t, const QHaccResultSet * model );

	virtual bool save( QString& error );
	virtual bool load( QString& error );

	virtual const PluginInfo& info() const;
	
	uint cnt( Table t );

	int add( Table, const TableRow& );

	void updateWhere( Table, const TableSelect&, const TableUpdate& );
	void updateWhere( Table, const TableSelect&, const TableRow& );

	auto_ptr<QHaccResultSet> getWhere( Table, vector<TableSelect>,
																		 uint& retrows );
	auto_ptr<QHaccResultSet> getWhere( Table, const TableGet&,
																		 vector<TableSelect>, uint& retrows );
	auto_ptr<QHaccResultSet> getWhere( Table, const TableSelect&,
																		 uint& retrows );

	void deleteWhere( Table, const TableSelect& );

	void setAtom( AtomicOp, QString name ="dbatom" );

	TableCol max( Table, int col );
	TableCol min( Table, int col );
	bool dirty() const;
	void startLoad( Table, uint =0 );
	void stopLoad( Table );

	virtual QString create( const QString& dirname ) const;
	static QString screate( const QString& dirname );
	virtual bool imprt( QHaccResultSet * );
	virtual bool exprt( QHaccResultSet * );

	static bool loadt( QHaccTable& tbl, const QString& fn, QString& error );
	static bool savet( QHaccTable& tbl, const QString& fn, bool protect,
										 QString& error );
 protected:

	virtual bool iconnect( QHacc * engine, const QString& home, QString& error );
	virtual bool iload( QString& error );
	virtual bool iloadt( QHaccTable& tbl, const QString& fn, QString& error );
	virtual bool isavet( QHaccTable& tbl, const QString& fn, QString& error );

	auto_ptr<QHaccTable> xtrans( vector<TableSelect> );

	QHacc * engine;
	QString home;
	QHaccTable ** dbs; // an array of all the tables
	QHaccTable * preferences, * accounts, * transactions, * splits;
	QHaccTable * journals, * procs, * namedtrans;
	bool needsave;

	QHaccTable * table( Table ) const; // lookup function
};

#endif
