/************************* * * * * * * * * * * * * ***************************
		 Copyright (c) 1999-2005 Ryan Bobko
												ryan@ostrich-emulators.com

		 This program is free software; you can redistribute it and/or modify
		 it under the terms of the GNU General Public License as published by
		 the Free Software Foundation; either version 2 of the License, or
		 (at your option) any later version.

		 This program is distributed in the hope that it will be useful,
		 but WITHOUT ANY WARRANTY; without even the implied warranty of
		 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		 GNU General Public License for more details.

		 You should have received a copy of the GNU General Public License
		 along with this program; if not, write to the Free Software
		 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "plugininfo.h"
#include "qhacc.h"
#include "resultset.h"
#include "qhaccutils.h"
#include "localfileplugin.h"

PluginInfo::PluginInfo(){
	piprefs.reset( new QHaccResultSet( QC::IPICOLS, QC::IPICOLTYPES ) );
	targ=NONE;
	atom=raw=false;
	guisel=true;
}

PluginInfo::PluginInfo( const PluginInfo& model ){
	if( &model!=this ) reinit( model );
}

PluginInfo& PluginInfo::operator=( const PluginInfo& model ){
	if( &model!=this ) reinit( model );
	return *this;
}

void PluginInfo::reinit( const PluginInfo& model ){
	description=model.descr();
	filename=model.fname();
	stubby=model.stub();
	targ=model.target();
	guisel=model.isGUISelectable();
	atom=model.atomizer();
	raw=model.rawloader();

	auto_ptr<QHaccResultSet> tp=model.prefs();
	piprefs=tp;
}

PluginInfo::~PluginInfo(){}

void PluginInfo::setFilename( const QString& s ){ filename=s; }

QString PluginInfo::descr() const { return description; }
QString PluginInfo::stub() const { return stubby; }
QString PluginInfo::fname() const { return filename; }
TargetType PluginInfo::target() const { return targ; }
bool PluginInfo::atomizer() const { return atom; }
bool PluginInfo::rawloader() const { return raw; }
bool PluginInfo::isGUISelectable() const { return guisel; }
auto_ptr<QHaccResultSet> PluginInfo::prefs() const {
	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( *( piprefs.get() ) ) );
	return ret;
}
