/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "qhaccconstants.h"

const int QC::TID=    0;
const int QC::TNUM=   1;
const int QC::TPAYEE= 2;
const int QC::TMEMO=  3;
const int QC::TDATE=  4;
const int QC::TLID=   5;
const int QC::TTYPE=  6;
const int QC::TMETA=  7;
const int QC::TVOID=  8;
const int QC::TCOLS=  9;
const char * QC::TCOLNAMES[]={ "TID", "NUM", "PAYEE", "MEMO", "DATE",
															 "JOURNALID", "TYPE", "TMETA", "TVOID" };
const ColType QC::TCOLTYPES[]={ CTUINT, CTSTRING, CTSTRING, CTSTRING, CTDATE,
																CTUINT,	CTUINT, CTSTRING, CTBOOL };

const int QC::SID=      0;
const int QC::STID=     1;
const int QC::SACCTID=  2;
const int QC::SSUM=     3;
const int QC::SRECO=    4;
const int QC::SRECODATE=5;
const int QC::SMETA=    6;
const int QC::STAXABLE= 7;
const int QC::SCOLS=    8;
const char * QC::SCOLNAMES[]={ "SID", "STID", "ACCTID", "SUM", "RECO",
															 "RECODATE", "SMETA", "TAXABLE" };
const ColType QC::SCOLTYPES[]={ CTUINT, CTUINT, CTUINT, CTSTRING, CTUINT,
																CTDATE, CTSTRING, CTBOOL };

const int QC::XTID=      0;
const int QC::XSID=      1;
const int QC::XTLID=     2;
const int QC::XSRECO=    3;
const int QC::XSACCTID=  4;
const int QC::XTTYPE=    5;
const int QC::XTNUM=     6;
const int QC::XTPAYEE=   7;
const int QC::XTMEMO=    8;
const int QC::XSSUM=     9;
const int QC::XTDATE=    10;
const int QC::XSRECODATE=11;
const int QC::XSMETA=    12;
const int QC::XTMETA=    13;
const int QC::XSTAXABLE= 14;
const int QC::XTVOID=    15;
const int QC::XCOLS=     16;
const ColType QC::XCOLTYPES[]={ CTUINT, CTUINT, CTUINT, CTUINT, CTUINT,
																CTUINT, CTSTRING, CTSTRING, CTSTRING, CTSTRING,
																CTDATE, CTDATE, CTSTRING, CTSTRING,
																CTBOOL, CTBOOL };
const char * QC::XCOLNAMES[]={ "TID", "SID", "JOURNALID", "RECO", "ACCTID",
															 "TYPE", "NUM", "PAYEE", "MEMO", "SUM",
															 "DATE", "RECODATE", "SMETA", "TMETA", 
															 "TAXABLE", "TVOID" };

const int QC::NID=      0;
const int QC::NNAME=    1;
const int QC::NTID=     2;
const int QC::NACCTID=  3;
const int QC::NSHORTCUT=4;
const int QC::NCOLS=    5;
const ColType QC::NCOLTYPES[]={ CTUINT, CTSTRING, CTUINT, CTUINT, CTSTRING };
const char * QC::NCOLNAMES[]={ "ID", "NAME", "TID", "ACCTID", "SHORTCUT" };


const int QC::AID=           0;
const int QC::ANAME=         1;
const int QC::AOBAL=         2;
const int QC::ACBAL=         3;
const int QC::ARBAL=         4;
const int QC::ABUDGET=       5;
const int QC::ATRANSNUMS=    6;
const int QC::ADEFAULTNUM=   7;
const int QC::ANUM=          8;
const int QC::AINSTNAME=     9;
const int QC::AINSTADDR1=    10;
const int QC::AINSTADDR2=    11;
const int QC::AINSTCITY=     12;
const int QC::AINSTSTATE=    13;
const int QC::AINSTZIP=      14;
const int QC::AINSTPHONE=    15;
const int QC::AINSTFAX=      16;
const int QC::AINSTEMAIL=    17;
const int QC::AINSTCONTACT=  18;
const int QC::AINSTNOTES=    19;
const int QC::ACATEGORY=     20;
const int QC::ATAXED=        21;
const int QC::ATYPE=         22;
const int QC::APID=          23;
const int QC::AMETA=         24;
const int QC::ACOLS=         25;
const char * QC::ACOLNAMES[]={ "ID", "NAME", "OBAL", "CBAL", "RBAL",
															 "BUDGET", "TRANSNUMS", "DEFAULTNUM",
															 "NUM", "INSTNAME",	"INSTADDR1",
															 "INSTADDR2", "INSTCITY", "INSTSTATE",
															 "INSTZIP", "INSTPHONE", "INSTFAX",
															 "INSTEMAIL", "INSTCONTACT", "INSTNOTES",
															 "CATEGORY", "TAXED", "TYPE", "PID", "AMETA" };
const ColType QC::ACOLTYPES[]={ CTUINT, CTSTRING, CTSTRING, CTSTRING,
																CTSTRING, CTSTRING, CTSTRING, CTSTRING,
																CTSTRING, CTSTRING, CTSTRING, CTSTRING,
																CTSTRING, CTSTRING, CTSTRING, CTSTRING,
																CTSTRING, CTSTRING, CTSTRING, CTSTRING,
																CTBOOL, CTBOOL, CTUINT, CTUINT, CTSTRING };

const char * QC::ASEP="::";


const int QC::PPREF=  0;
const int QC::PVALUE= 1;
const int QC::PCOLS=  2;
const char * QC::PCOLNAMES[]={ "PREF", "VALUE" };
const ColType QC::PCOLTYPES[]={ CTSTRING, CTSTRING };

const uint QC::ASSET=    0;
const uint QC::LIABILITY=1;
const uint QC::EQUITY=   2;
const uint QC::EXPENSE=  3;
const uint QC::REVENUE=  4;
const uint QC::NUMTYPES= 5;


const int QC::LID=  0;
const int QC::LNAME=1;
const int QC::LDESC=2;
const int QC::LCOLS=3;
const char * QC::LCOLNAMES[]={ "ID", "NAME", "DESCRIPTION" };
const ColType QC::LCOLTYPES[]={ CTUINT, CTSTRING, CTSTRING };

const int QC::JID=       0;
const int QC::JLASTRUN=  1;
const int QC::JFREQUENCY=2;
const int QC::JWHAT=     3;
const int QC::JCOLS=     4;
const char * QC::JCOLNAMES[]={ "ID", "LASTRUN", "FREQUENCY", "WHATTORUN" };
const ColType QC::JCOLTYPES[]={ CTUINT, CTDATE, CTINT, CTSTRING };


const int QC::IPIPREF= 0;
const int QC::IPIDESCR=1;
const int QC::IPITYPE= 2;
const int QC::IPILABEL=3;
const int QC::IPICOLS= 4;
const char * QC::IPICOLNAMES[]={ "PREF", "PIDESCR", "TYPE", "LABEL" };
const ColType QC::IPICOLTYPES[]={ CTSTRING, CTSTRING, CTINT, CTSTRING };

const uint QC::NREC=0;
const uint QC::MREC=1;
const uint QC::YREC=2;

const uint QC::REGULAR=0;
const uint QC::MEMORIZED=1;

const int QC::DECIMALS=2;

const int QC::MONTHFREQ=-1;
const int QC::BIMONTHFREQ=-2;
const int QC::ONETIMEFREQ=-3;
const int QC::QUARTERLYFREQ=-4;
const int QC::LASTMONTHDAYFREQ=-5;

const int QC::NEVER=0;
const int QC::NEW=  1;
const int QC::ALL=  2;

const int QC::AMERICAN= 0;
const int QC::EUROPEAN= 1;
const int QC::YEARFIRST=2;

const QDate QC::XDATE=QDate( 8000, 1, 1 );

const int QC::NUMTABLES=7;
const char * QC::TABLENAMES[]={ "preferences", "journals", "accounts", 
																"transactions", "splits", "namedtrans",
																"jobs" };
const char * QC::TCSEP="||";
const char * QC::REMAINDERVAL="*";
const char * QC::LOANREGEXP="loan[\\(](.*),(.*),(\\d+)[\\)]";
const int QC::LOANINT=1;
const int QC::LOANPMT=2;
const int QC::LOANNPR=3;
const char * QC::MARKETREGEXP="market[\\(](.*)@(.*)[\\)]";
const int QC::MARKETSHARES=1;
const int QC::MARKETPRICE=2;


const int QC::PREFT=( int )PREFERENCES;
const int QC::JRNLT=( int )JOURNALS;
const int QC::ACCTT=( int )ACCOUNTS;
const int QC::TRANT=( int )TRANSACTIONS;
const int QC::SPLTT=( int )SPLITS;
const int QC::NAMET=( int )NAMEDTRANS;
const int QC::JOBST=( int )JOBS;

