/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCTABLEROWS_H
#define _QHACCTABLEROWS_H

#include "qhaccconstants.h"

#include <qstring.h>
#include <qdatetime.h>

class QHaccTable;
class QHaccTableIndex;
class TableCol;

typedef int ( TableCol::*compfunc )( const TableCol& ) const;

class TableCol {
 public:
	TableCol();
	TableCol( const QString& );
	TableCol( const char * );
	TableCol( int );
	TableCol( uint );
	TableCol( float );
	TableCol( const QDate& );
	TableCol( bool );
	const TableCol& operator=( const TableCol& );
	bool operator==( const TableCol& ) const;
	bool operator!=( const TableCol& ) const;

	int compareTo( const TableCol&, ColType ) const;

	int geti() const;
	uint getu() const;
	bool getb() const;
	float getf() const;
	QDate getd() const;
	const QString& gets() const;

 private:
	QString data;
	
	static const compfunc COMPARERS[];

	int compareString( const TableCol& ) const;
	int compareBool( const TableCol& ) const;
	int compareInt( const TableCol& ) const;
	int compareUInt( const TableCol& ) const;
	int compareFloat( const TableCol& ) const;
	int compareDate( const TableCol& ) const;
	int compareNull( const TableCol& ) const;
};

class PosVal {
 public:
	PosVal();
	PosVal( int, const TableCol& );
	PosVal( const PosVal& );
	const PosVal& operator=( const PosVal& );
	~PosVal();
	
	int getp() const;
	const TableCol& getv() const;
	void get( int&, TableCol& ) const;

 protected:
	int pos;
	TableCol val;

	void init( int, const TableCol& );
};

class TableRow {
 public:
	TableRow();
	TableRow( int );
	TableRow( const TableRow& );
	TableRow( const QString&, int );
	TableRow( TableCol *, int );
	virtual ~TableRow();

	QString toString() const;
	const TableRow& operator=( const TableRow& );
	const TableCol& operator[]( int ) const;
	bool isNull() const;

	int geti( int ) const;
	uint getu( int ) const;
	bool getb( int ) const;
	float getf( int ) const;
	QDate getd( int ) const;
	const QString& gets( int ) const;

	const TableCol& get( int ) const;
	void set( const PosVal& );
	void set( int, const TableCol& );
	int cols() const;

 protected:
	TableCol * data;
	int size;

	void init( int );
};

typedef TableRow Split;
typedef TableRow Journal;
typedef TableRow Account;
typedef TableRow Transaction;

#endif



