/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _TABLEOPS_H
#define _TABLEOPS_H

#include "qhacctablerows.h"

#include <vector>

using namespace std;

class TableSelect {
 public:
	static const int EQ, NE, GT, GE, LT, LE, NO, ALL;

	TableSelect( int, const TableCol&, int checktype =TableSelect::EQ );
	TableSelect( const PosVal&, int checktype =TableSelect::EQ );
	TableSelect();
	TableSelect( const TableSelect& );
	const TableSelect& operator=( const TableSelect& );
	~TableSelect();

	void getAll( PosVal&, int& type ) const;

	/**
	 * Check the given row against the selection criteria
	 */
	bool check( const TableRow&, ColType ct ) const;
	
	/**
	 * A string representation of the selection criteria
	 */
	QString toString() const;

	/**
	 * @return a valid SQL representation of the selection operator, if possible
	 *  =,!=, >, <, etc.
	 */
	QString sqlSel() const;

	/**
	 * @return True, if the operator is a valid SQL operator. ALL and NO are
	 *  the only operators that are not sqlValid
	 */
	bool sqlValid() const;

	/**
	 * @return the selection operator
	 */
	int check() const;
	
	/**
	 * @return the column to check against the operator
	 */
	int column() const;

	/**
	 * @return the TableCol value to be checked against
	 */
	TableCol model() const;

 protected:
	int checktype;
	PosVal posval;
};

class TableUpdate {
 public:
	TableUpdate( int, const TableCol& );
	TableUpdate( vector<PosVal> );
	TableUpdate( const TableUpdate& );
	const TableUpdate& operator=( const TableUpdate& );
	~TableUpdate();

	PosVal operator[]( uint ) const;
	uint cnt() const;

 protected:
	vector<PosVal> changes;
};

class TableGet {
 public:
	TableGet();
	TableGet( int );
	TableGet( int, int modifier );
	TableGet( vector<int> );
	const TableGet& operator=( const TableGet& );
	~TableGet();
	
	uint cnt() const;
	int operator[]( uint ) const;
	int getMod( uint ) const;

	static const int UQ;

 protected:
	vector<int> positions;
	int mod;
};

#endif
