/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "aqbplugin.h"

#include "qhacc.h"
#include "qhaccext.h"
#include "qhacctable.h"
#include "qhaccutils.h"

#include <kbanking/settings.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new AQBImporter; }
	void destroy( AQBImporter * p ){ delete p; }
}

const AQBInfo AQBImporter::pinfo;

AQBImporter::AQBImporter() : LocalFileDBPlugin() { aqb=0; }

AQBImporter::~AQBImporter(){ 
	if( aqb ) delete aqb; 
}

const PluginInfo& AQBImporter::info() const { return pinfo; }

bool AQBImporter::iconnect( QHacc *, const QString&, QString& ){
	return true;
}

bool AQBImporter::iload( QString& err ){ 
	aqb=new KBanking( "QHacc" );
	int nogo=aqb->init();
	if( nogo ){
		err="could not initialize AQBanking backend";
		return false;
	}

	KBankingSettings bs( aqb );
	
  if( bs.init() ) qWarning("Error on ini of settings dialog.");
	else {
    bs.exec();
    if ( !bs.fini() ) qWarning("Error on fini of settings dialog.");
  }
	return true;
}

bool AQBImporter::exprt( QHaccResultSet * data ){
	return true;
}

bool AQBImporter::imprt( QHaccResultSet * ){ return false; }
bool AQBImporter::save( QString& ){ return false; }


AQBInfo::AQBInfo(){
	targ=NONE;
	description="AqBanking";
	stubby="AQB";
}
