/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef AQBIMPORTER_H
#define AQBIMPORTER_H

#include "localfileplugin.h"

#include <kbanking/kbanking.h>

class QHaccTable;

using namespace std;

class AQBInfo : public PluginInfo {
 public:
	AQBInfo();
};

class AQBImporter : public LocalFileDBPlugin {
 public:
	static const AQBInfo pinfo;

	AQBImporter();
	virtual ~AQBImporter();

	const PluginInfo& info() const;

	virtual bool iconnect( QHacc * eng, const QString& home, QString& error );
	virtual bool iload( QString& error );
	virtual bool exprt( QHaccResultSet * );

	virtual bool imprt( QHaccResultSet * );
	virtual bool save( QString& );

 protected:
	KBanking * aqb;
};

#endif
