/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef GPG_H
#define GPG_H

#include "localfileplugin.h"

#include <gpgme.h>

class GPGInfo : public PluginInfo {
 public:
	GPGInfo();
};

class GPGDBPlugin : public LocalFileDBPlugin {
 public:
	static const GPGInfo pinfo;

	GPGDBPlugin();
	virtual ~GPGDBPlugin();

	const PluginInfo& info() const;

 protected:
	virtual bool iload( QString& err );
	virtual bool iconnect( QHacc * engine, const QString& home, QString& error );
	virtual bool gpgloadt( QHaccTable& tbl, const QString& file, QString& err );
	virtual bool isavet( QHaccTable& tbl, const QString& file, QString& error );

	static gpgme_error_t passphrase_cb( void * hook, const char * uid_hint, 
																			const char * passphrase_info,
																			int last_was_bad, int fd );
	const QString& gpgpass( const char * uid_hint, const char * pass_info, 
													int last_was_bad );

 private:
	gpgme_ctx_t gpgctx;
	bool madectx;
	QString passphrase;
};



#endif
