/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************* * * * * * * * * * * * * ***************************/

#include "doublelinegraph.h"
#include "qhacctable.h"
#include "qhacc.h"

#include <qpainter.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new DoubleLineGraph; }
	void destroy( DoubleLineGraph * p ){ delete p; }
}

DoubleLineGraph::DoubleLineGraph(){
	setIvsE( true );
	setLine( true );
}

DoubleLineGraph::~DoubleLineGraph(){}

void DoubleLineGraph::paintRow( QPainter * p, const TableRow& last, 
																const TableRow& row, int wstart, int wspot,
																const QColor& color, bool drawTots,
																const QString& head ) const {
	paintRow( p, last, row, wstart, wspot, color, drawTots, head, INCREASES );
	paintRow( p, last, row, wstart, wspot, color, drawTots, head, DECREASES );
}

void DoubleLineGraph::paintRow( QPainter * p, const TableRow& last, 
																const TableRow& row, int wstart, int,
																const QColor& color, bool drawTots,
																const QString& head, uint col ) const {
	//cout<<"PAINTROW\t"<<row->toString()<<"\t";
	//if( last ) cout<<last->toString();
	//else cout<<"no last row";
	//cout<<endl;
	
	int sum=row.geti( col );
	int hpos=zeroline-( int )( sum/factor );
	bool manyaccts=( accounts->rows()>1 );
	int sstart=wstart, send=wpm;
	int tstart=wstart;
	//p->setPen( QPen( color ) );
	//cout<<"  point is ("<<wpos<<","<<hpos<<")..."<<sum<<"*"<<factor<<"="<<sum*factor<<endl;

	int wpos=wstart+( wpm/2 );
	tstart=wpos;
	if( manyaccts ) sstart=wstart;
	
	if( !last.isNull() ){
		if( manyaccts ) p->setPen( QPen( color, 3 ) );
		else p->setPen( QPen( "black", 3 ) );
		
		// draw a line from the last value to this one
		int lsum=last.geti( col );
		int lwpos=wpos-wpm;
		int lhpos=zeroline-( int )( lsum/factor );
		//cout<<"  last was ("<<lwpos<<","<<lhpos<<")..."<<lsum<<"*"<<factor<<"="<<sum*factor<<endl;
		p->drawLine( lwpos, lhpos, wpos, hpos );
		
		p->fillRect( lwpos-3, lhpos-3, 6, 6, QBrush( "black" ) );
	}
	
	// draw a little box over the datapoint
	p->fillRect( wpos-3, hpos-3, 6, 6, QBrush( "black" ) );
	
	if( !head.isNull() ) drawTitle( p, head, sstart, tstart, hpos );	

	if( drawTots )
		drawSum( p, sum, sstart, hpos, send, p->fontMetrics().height() );
}

const DoubleLineInfo DoubleLineGraph::pinfo;
const PluginInfo& DoubleLineGraph::info() const { return pinfo; }
