/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef GRAPHERS_H
#define GRAPHERS_H

#include "plugins.h"
#include "plugininfo.h"

#include <qstring.h>

class QHacc;
class QHaccTable;
class QHaccResultSet;

class QColor;
class QPixmap;

class GraphBase : public QHaccGraphPlugin {
 public:
	GraphBase();
	virtual ~GraphBase();
	
	virtual void setup( QHacc * eng );
	void paint( QPainter *, const QRect& );
	void setData( uint lid, const QHaccResultSet& accts, const QDate& s,
								const QDate& e );
	vector<TableSelect> describeMouse( const QPoint& ) const;
	
 protected:
	uint journalid;
	QHacc * engine;
	QDate start, end;
	int baseline, zeroline;
  QColor * colors;
	QHaccTable * data, * accounts;
	static const QString EMPTYSTR;

	virtual void paintBase( QPainter *, const QRect& ) =0;
	virtual void paintMain( QPainter *, const QRect& ) =0;
	virtual void painted( const QPixmap& );
	virtual TableSelect mouseSel( const QPoint& ) const =0;
	virtual void mouseDates( const QPoint&, QDate& s, QDate& e ) const;
	virtual void isetData() =0;
};


/*****************/
/***Plugin Info***/
/*****************/

class GraphInfo : public PluginInfo {
 public:
	GraphInfo();
};

class DoubleBarInfo : public GraphInfo {
 public:
	DoubleBarInfo();
};

class SingleBarInfo : public GraphInfo {
 public:
	SingleBarInfo();
};

class DoubleLineInfo : public GraphInfo {
 public:
	DoubleLineInfo();
};

class SingleLineInfo : public GraphInfo {
 public:
	SingleLineInfo();
};

class PieInfo : public GraphInfo {
 public:
	PieInfo();
};

#endif
