/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef PSQLPLUGIN_H
#define PSQLPLUGIN_H

#include "sqldbplugin.h"

#include "libpq-fe.h"

class QHacc;

class PSQLDBInfo : public QHaccSQLDBInfo {
 public:
	PSQLDBInfo();
	virtual ~PSQLDBInfo();
};

/* read and write to PostgreSQL databases */
class PSQLDBPlugin : public QHaccSQLDBPlugin{
 public:
	static const PSQLDBInfo pinfo;

	PSQLDBPlugin();
	virtual ~PSQLDBPlugin();

	const PluginInfo& info() const;

	bool connect( QHacc *, const QString&, QString& );

	void setAtom( AtomicOp, QString ="dbatom" );
	bool atomizer() const;

	QString create( const QString& dbname ) const;
	static QString screate( const QString& dbname );

	auto_ptr<QHaccResultSet> sel( const QString& stmt, vector<ColType> types,
																uint& rows );

	int  run( const QString& stmt );
	uint cnt( Table );
	
	QString selField( const QString& fieldname, ColType ) const;
	QString sqlField( const TableCol&, ColType ) const;

 protected:
	QString minmax( Table t, int col, bool max );
	PGconn * conn;
	int atoms;
};

#endif
