/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "areport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new AvesReport; }
	void destroy( AvesReport * p ){ delete p; }
}

const uint AvesReport::AVENTRANS=  0;
const uint AvesReport::AVEADELTA=  1;
const uint AvesReport::AVELTRANS=  2;
const uint AvesReport::AVESTRANS=  3;
const uint AvesReport::AVEATRANS=  4;
const uint AvesReport::AVEDDELTA=  5;
const uint AvesReport::AVESPAN=    6;
const uint AvesReport::AVENDEBITS= 7;
const uint AvesReport::AVEADEBIT=  8;
const uint AvesReport::AVENCREDITS=9;
const uint AvesReport::AVEACREDIT= 10;

AvesReport::AvesReport(){}
AvesReport::~AvesReport(){}

auto_ptr<QHaccResultSet> AvesReport::generate( uint jid,
																							 QHaccResultSet * accounts,
																							 const QDate& start,
																							 const QDate&  end,
																							 QString& title ){
	
	title=titler( accounts, jid, start, end );
	return igen( gentrans( accounts, jid, start, end ) );
}

auto_ptr<QHaccResultSet> AvesReport::generate( QHaccResultSet * accounts,
																							 vector<TableSelect> ss,
																							 QString& title ){
	// figure out the title and the affected transactions
	title=titler( accounts );
	return igen( gentrans( accounts, ss ) );
}

auto_ptr<QHaccResultSet> AvesReport::igen( auto_ptr<QHaccResultSet> trans,
																					 QDate start, QDate end ) const {


	//cout<<rows<<" trans in igen are:"<<endl;
	//for( uint i=0; i<trans->rows(); i++ ) cout<<" "<<trans->at( i ).toString()<<endl;
	//cout<<"--"<<endl;
	const MonCon& conv=engine->converter();

	uint rows=trans->rows();
	float daysTo=0;
	int total, big, small, cds, dbs, ncds, ndbs;
	total=big=small=cds=dbs=ncds=ndbs=0;
	
	QHaccTableIndex idx( trans.get(), QC::XTDATE, CTDATE );
	if( rows>0 && !start.isValid() ){
		start=idx.min().getd();
		end=idx.max().getd();
	}

	for( uint i=0; i<rows; i++ ){
		const Transaction& t=trans->at( idx[i] );
		int tsum=conv.converti( t[QC::XSSUM].gets(), Engine, Engine );
		
		total+=tsum;
		
		if( i==0 ){
			big=tsum;
			small=tsum;
		}
		else{
			if( tsum>big ) big=tsum;
			if( tsum<small ) small=tsum;
			
			const Transaction& ot=trans->at( idx[i-1] );
			daysTo+=ot.getd( QC::XTDATE ).daysTo( t.getd( QC::XTDATE ) );
		}
		
		if( tsum>0 ){
			cds+=tsum;
			ncds++;
		}
		else{
			dbs+=tsum;
			ndbs++;
		}
	}
	
	float ftot=conv.convert( total, Engine, Engine ).toFloat();
	const uint count=11;
	QString * sums=new QString[count], temp;
	
	sums[AVENTRANS]=temp.setNum( rows );
	sums[AVEADELTA]=conv.convert( total );
	sums[AVELTRANS]=conv.convert( big );
	sums[AVESTRANS]=conv.convert( small );
	temp.setNum( ftot/( rows==0 ? 1 : rows ), 'f', QC::DECIMALS );
	sums[AVEATRANS]=conv.convert( temp, EngSep, PrefSep );
	temp.setNum( ftot/( start>=end ? 1 : start.daysTo( end ) ), 
							 'f', QC::DECIMALS );
	sums[AVEDDELTA]=conv.convert( temp, EngSep, PrefSep );
	sums[AVESPAN]=temp.setNum( daysTo/( rows<2 ? 1 : rows-1 ), 
														 'f', QC::DECIMALS );
	sums[AVENDEBITS]=temp.setNum( ncds );
	temp.setNum( conv.convert( cds, Engine, Engine ).toFloat()/
							 ( ncds==0 ? 1 : ncds ), 'f', QC::DECIMALS );
	sums[AVEADEBIT]=conv.convert( temp, EngSep, PrefSep );
	sums[AVENCREDITS]=temp.setNum( ndbs );

	temp.setNum( conv.convert( dbs, Engine, Engine ).toFloat()/
							 ( ndbs==0 ? 1 : ndbs ), 'f', QC::DECIMALS );
	sums[AVEACREDIT]=conv.convert( temp, EngSep, PrefSep );
	
	const char * strs[]={ "Number of Transactions:",
												"Account Delta:",
												"Largest Transaction:",
												"Smallest Transaction:",
												"Average Transaction:",
												"Average Daily Change:",
												"Average Days Between Transactions:",
												"Number of Credits:",
												"Average Credit:",
												"Number of Debits:",
												"Average Debit:" };
	
	auto_ptr<QHaccResultSet>ret( new QHaccResultSet( 2 ) );
	for( uint i=0; i<count; i++ ){
		TableCol cols[]={ TableCol( strs[i] ), TableCol( sums[i] ) };
		ret->add( TableRow( cols, 2 ) );
	}
	delete [] sums;
	return ret;
}

const AvesInfo AvesReport::pinfo;
const PluginInfo& AvesReport::info() const { return pinfo; }
