/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "bdgreport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"
#include "qhacclineedits.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new BudgetReport; }
	void destroy( BudgetReport * p ){ delete p; }
}

BudgetReport::BudgetReport(){}
BudgetReport::~BudgetReport(){}

auto_ptr<QHaccResultSet> BudgetReport::generate( uint jid,
																								QHaccResultSet * accts,
																								const QDate& start,
																								const QDate&  end,
																								QString& title ){
	const MonCon& conv=engine->converter();

	title=titler( accts, jid, start, end );

	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 3 ) );
	// figure out the title and the affected transactions

	// create the return table and row structure
	TableSelect ge( QC::XTDATE, start, TableSelect::GE );
	TableSelect le( QC::XTDATE, end,   TableSelect::LE ); 

	vector<TableSelect> crit;
	crit.push_back( ge );
	crit.push_back( le );
	crit.push_back( TableSelect( QC::XTVOID, false ) );
		

	if( jid!=0 ) crit.push_back( TableSelect( QC::XTLID, jid ) );

	QString sep=engine->getSP( "DATESEPARATOR" );
	int fmt=engine->getIP( "DATEFORMAT" );

	uint arows=accts->rows();
	for( uint i=0; i<arows; i++ ){
		const Account& acct=accts->at( i );

		uint rr=0;
		auto_ptr<QHaccResultSet> temptrans=engine->getXTForA( acct, TableGet(),
																													crit, rr );
		// the budget report needs account and date info,
		// so do everything here
		uint * pos=0, sz=0;
		QHaccTableIndex idx( temptrans.get(), QC::XTDATE, CTDATE );
		QHaccSegmenter::segment( engine, &idx, start, end, pos, sz );
		
		QDate ndate=start;
		for( uint i=0; i<sz-1; i++ ){
			QString head=Utils::shortStringFromDate( ndate, sep, fmt );
			head.append( "-" );
			
			ndate=ndate.addMonths( 1 );
			ndate=ndate.addDays( -1 );
			if( ndate>end ) ndate=end;
			head.append( Utils::shortStringFromDate( ndate, sep, fmt ) );
			ndate=ndate.addDays( 1 );
			TableCol month( head );
			
			int sum=0, budget=conv.converti( acct[QC::ABUDGET].gets(),
																			 Engine, Engine );
			
			for( uint j=pos[i]; j<pos[i+1]; j++ )
				sum+=conv.converti( temptrans->at( idx[j] )[QC::XSSUM].gets(),
														Engine, Engine );

			TableCol tca( engine->getFNameOfA( acct ) );
			if( budget!=0 ){
				QString val;
				int obBal=sum-budget;
				if( ( budget<0 && sum<budget ) || ( budget>0 && sum>budget ) ){
					val+="+ ";
				}
				else{
					val+="- ";
					obBal=0-obBal;
				}
				
				val+=QString( "%1 (%2/%3)" ).arg( conv.convert( obBal ) ).arg( conv.convert( sum ) ).arg( conv.convert( budget ) );
				TableCol cols[]={ month, tca, TableCol( val ) };
				ret->add( TableRow( cols, 3 ) );
			}
			else{
				TableCol cols[]={ month, tca, TableCol( "no budget set" ) };
				ret->add( TableRow( cols, 3 ) );
			}
		}
	}
	
	return ret;
}

auto_ptr<QHaccResultSet> BudgetReport::generate( QHaccResultSet * accts,
																								 vector<TableSelect> ss,
																								 QString& title ){
	const MonCon& conv=engine->converter();

	// figure out the title and the affected transactions
	title=titler( accts );
	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 3 ) );
	// figure out the title and the affected transactions

	// ignore void transactions
	ss.push_back( TableSelect( QC::XTVOID, false ) );

	auto_ptr<QHaccResultSet> junk=gentrans( accts, ss );
	QHaccTable junkt( *(junk.get() ) );
	QDate start=junkt.min( QC::XTDATE ).getd();
	QDate end=junkt.max( QC::XTDATE ).getd();
	
	QString sep=engine->getSP( "DATESEPARATOR" );
	int fmt=engine->getIP( "DATEFORMAT" );

	uint arows=accts->rows();
	for( uint i=0; i<arows; i++ ){
		const Account& acct=accts->at( i );
		
		uint rr=0;
		auto_ptr<QHaccResultSet> temptrans=engine->getXTForA( acct, TableGet(),
																													ss, rr );
		// the budget report needs account and date info,
		// so do everything here
		uint * pos=0, sz=0;
		QHaccTableIndex idx( temptrans.get(), QC::XTDATE, CTDATE );
		QHaccSegmenter::segment( engine, &idx, start, end, pos, sz );
		
		QDate ndate=start;
		for( uint i=0; i<sz-1; i++ ){
			QString head=Utils::shortStringFromDate( ndate, sep, fmt );
			head.append( "-" );
				
			ndate=ndate.addMonths( 1 );
			ndate=ndate.addDays( -1 );
			if( ndate>end ) ndate=end;
			head.append( Utils::shortStringFromDate( ndate, sep, fmt ) );
			ndate=ndate.addDays( 1 );
			TableCol month( head );
			
			int sum=0, budget=conv.converti( acct[QC::ABUDGET].gets(),
																			 Engine, Engine );
			
			for( uint j=pos[i]; j<pos[i+1]; j++ )
				sum+=conv.converti( temptrans->at( idx[j] )[QC::XSSUM].gets(),
														Engine, Engine );

			
			TableCol tca( engine->getFNameOfA( acct ) );
			if( budget!=0 ){
				QString val;
				int obBal=sum-budget;
				if( ( budget<0 && sum<budget ) || ( budget>0 && sum>budget ) ){
					val+="+ ";
				}
				else{
					val+="- ";
					obBal=0-obBal;
				}
				
				val+=QString( "%1 (%2/%3)" ).arg( conv.convert( obBal ) ).arg( conv.convert( sum ) ).arg( conv.convert( budget ) );
				TableCol cols[]={ month, tca, TableCol( val ) };
				ret->add( TableRow( cols, 3 ) );
			}
			else{
				TableCol cols[]={ month, tca, TableCol( "no budget set" ) };
				ret->add( TableRow( cols, 3 ) );
			}
		}
	}

	return ret;
}


const BudgetInfo BudgetReport::pinfo;
const PluginInfo& BudgetReport::info() const { return pinfo; }
