/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef JREPORT_H
#define JREPORT_H

#include "reporter.h"

class JournalReport : public ReportBase {
 public:
	JournalReport();
	virtual ~JournalReport();

	virtual const PluginInfo& info() const;
	static const JournalInfo pinfo;

	virtual void selected( QDate& start, QDate& stop, bool& enableacctsel,
												 bool& enablemultiselect );

	QString writereport( const QString& title, const QHaccResultSet * data );

	virtual auto_ptr<QHaccResultSet> generate( uint journalid,
																						 QHaccResultSet * accounts,
																						 const QDate& start,
																						 const QDate&  end,
																						 QString& title );

	virtual auto_ptr<QHaccResultSet> generate( QHaccResultSet * accounts,
																						 vector<TableSelect> selectors,
																						 QString& title );

 private:
	auto_ptr<QHaccResultSet> igen( auto_ptr<QHaccResultSet> trans ) const;

	bool homeok( const QString& home, uint& jid, auto_ptr<QHaccResultSet>& accts,
							 QDate& start, QDate& stop, QString& err );

};

#endif
