/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "mbdgreport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"
#include "qhacclineedits.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new MonthlyBudgetReport; }
	void destroy( MonthlyBudgetReport * p ){ delete p; }
}

MonthlyBudgetReport::MonthlyBudgetReport(){}
MonthlyBudgetReport::~MonthlyBudgetReport(){}

auto_ptr<QHaccResultSet> MonthlyBudgetReport::generate( uint jid,
																												QHaccResultSet *,
																												const QDate& start,
																												const QDate&  end,
																												QString& title ){
	const MonCon& conv=engine->converter();
	// add two rows to the accts table so that titler function
	// returns a "Multiple" line
	QHaccResultSet accts( QC::ACOLS );
	accts+=TableRow( QC::ACOLS );
	accts+=TableRow( QC::ACOLS );
	title=titler( &accts, jid, start, end );

	const int ID=0, NAME=1, BUDGET=2, PID=3;
	int FIELDS[]={ QC::AID, QC::ANAME, QC::ABUDGET, QC::APID };
	vector<int>FI;
	for( int i=0; i<4; i++ ) FI.push_back( FIELDS[i] );
	auto_ptr<QHaccResultSet> rslt=engine->getAs( TableGet( FI ) );
	//for( uint i=0; i<4; i++ )	cout<<rslt->colname( i )<<endl;
	
	QHaccTable tbl( *rslt );
	
	// order on name just to look nice
	QHaccTableIndex idx( &tbl, NAME, CTSTRING );
	const uint RWS=tbl.rows();
	//tbl.setName( "ryan" );
	
	// we want to display full names of the accounts, so do some updating!
	for( uint i=0; i<RWS; i++ ){
		Account acct=tbl.at( i );
		QString fname=engine->getFNameOfA( acct.getu( PID ) );
		if( !fname.isEmpty() ){
			fname+=QC::ASEP;
			fname+=acct.gets( NAME );
			tbl.updateWhere( TableSelect( ID, acct[ID] ),
											 TableUpdate( NAME, TableCol( fname ) ) );
		}
	}
	
	TableCol tc( "" );
	TableCol tot[]={ TableCol( " Total Budget:" ), tc, tc, tc };
	TableRow total( tot, 4 );
	
	int totf=0, totfu=0;
	auto_ptr<QHaccResultSet>ret( new QHaccResultSet( 4 ) );
	for( uint i=0; i<RWS; i++ ){
		Account acct=tbl[idx[i]];
		int bf=conv.converti( acct[BUDGET].gets(), Engine, Engine );
		
		if( bf!=0.0 ){
			// we have a budget, so figure out if what amount we've already used
			
			vector<TableSelect> criteria;
			criteria.push_back( TableSelect( QC::XTDATE, start, TableSelect::GE ) );
			criteria.push_back( TableSelect( QC::XTDATE, end, TableSelect::LE ) );
			criteria.push_back( TableSelect( QC::XTVOID, false ) );

			uint rr=0;
			auto_ptr<QHaccResultSet> rstrans=engine->getXTForA( acct, TableGet(), 
																													criteria, rr );
			
			int sum=0;
			for( uint i=0; i<rr; i++ )
				sum+=conv.converti( rstrans->at( i )[QC::XSSUM].gets(), 
														Engine, Engine );

			float bfsum=( bf==0 ? 100 : bf );
			TableCol cols[]={ TableCol( acct.gets( NAME ) ),
												TableCol( conv.convert( sum ) ),
												TableCol( conv.convert( bf ) ),
												TableCol( "("+QString().setNum( sum*100/bfsum, 'f', 2 )+"%)" )
			};
			
			ret->add( TableRow( cols, 4 ) );
			totf+=bf;
			totfu+=sum;
		}
	}
	
	
	float ftotf=( totfu==0 ? 100 : totf );
	total.set( 1, TableCol( conv.convert( totfu ) ) );
	total.set( 2, TableCol( conv.convert( totf ) ) );
	total.set( 3, TableCol( "("+QString().setNum( totfu*100/ftotf,
																								'f', 2 )+"%)" ) );
	ret->add( total );

	return ret;
}

auto_ptr<QHaccResultSet> MonthlyBudgetReport::generate( QHaccResultSet *,
																												vector<TableSelect>,
																												QString& title ){
	// figure out the title and the affected transactions
	title="Program error: Cannot generate Monthly Budget Report from this function";
	return auto_ptr<QHaccResultSet>(new QHaccResultSet( 0 ) );
}

void MonthlyBudgetReport::selected( QDate& start, QDate& stop,
																		bool& enableacctsel,
																		bool& enablemultiselect ){
	start=stop.addMonths( -1 );
	enableacctsel=false;
	enablemultiselect=false;
}


bool MonthlyBudgetReport::homeok( const QString&, uint& jid,
																	auto_ptr<QHaccResultSet>&,
																	QDate& start, QDate& stop, QString& ){

	auto_ptr<QHaccResultSet> js=engine->getLs();
	Journal j=js->at( engine->getIP( "JOURNALINDEX" ) );
	jid=j[QC::LID].getu();

	QDate now=QDate::currentDate();
	stop=now.addDays( 1+now.daysInMonth()-now.day() );
	start=stop.addMonths( -1 );
	return true;
}

const MonthlyBudgetInfo MonthlyBudgetReport::pinfo;
const PluginInfo& MonthlyBudgetReport::info() const { return pinfo; }
