/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "preport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new PayeeReport; }
	void destroy( PayeeReport * p ){ delete p; }
}

PayeeReport::PayeeReport(){}
PayeeReport::~PayeeReport(){}

auto_ptr<QHaccResultSet> PayeeReport::generate( uint jid,
																								QHaccResultSet * accounts,
																								const QDate& start,
																								const QDate&  end,
																								QString& title ){

	title=titler( accounts, jid, start, end );
	return igen( gentrans( accounts, jid, start, end ) );
}

auto_ptr<QHaccResultSet> PayeeReport::generate( QHaccResultSet * accounts,
																								vector<TableSelect> ss,
																								QString& title ){
	// figure out the title and the affected transactions
	title=titler( accounts );
	return igen( gentrans( accounts, ss ) );
}

auto_ptr<QHaccResultSet> PayeeReport::igen( auto_ptr<QHaccResultSet> d ) const{
	QString temp;
	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 2 ) );
	const MonCon& conv=engine->converter();
	
	QHaccTableIndex idx( d.get(), QC::XTPAYEE, CTSTRING );
	
	uint * pos=0, sz=0;
	QHaccSegmenter::segment( engine, d.get(), &idx, pos, sz );
		
	ret->startLoad( sz-1 );
	for( uint i=0; i<sz-1; i++ ){
		const Transaction& t=d->at( idx[pos[i]] );

		int sum=0;
		for( uint j=pos[i]; j<pos[i+1]; j++ )
			sum+=conv.converti( d->at( idx[j] )[QC::XSSUM].gets(), Engine, Engine );
		
		TableCol cols[]={ TableCol( t.gets( QC::XTPAYEE )+
																"("+temp.setNum( pos[i+1]-pos[i] )+")" ),
											TableCol( conv.convert( sum ) ) };
		ret->add( TableRow( cols, 2 ) );
	}
	ret->stopLoad();

	return ret;
}

const PayeeInfo PayeeReport::pinfo;
const PluginInfo& PayeeReport::info() const { return pinfo; }
