/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef REPORTERS_H
#define REPORTERS_H

#include "plugins.h"
#include "plugininfo.h"

#include <qdatetime.h>

class QHacc;

class ReportBase : public QHaccReportPlugin {
 public:
	ReportBase();
	virtual ~ReportBase();

	virtual void selected( QDate& start, QDate& stop, bool& enableacctsel,
												 bool& enablemultiselect );

	virtual QString writereport( const QString& title,
															 const QHaccResultSet * data );

	auto_ptr<QHaccResultSet> generate( const QString& home, QString& title,
																		 QString& err, bool& ok );

	virtual auto_ptr<QHaccResultSet> generate( QHaccResultSet * accounts,
																						 vector<TableSelect> selectors,
																						 QString& title ) =0;

	virtual auto_ptr<QHaccResultSet> generate( uint journalid,
																						 QHaccResultSet * accounts,
																						 const QDate& start,
																						 const QDate&  end,
																						 QString& title ) =0;


	void setup( QHacc * eng );

 protected:
	QHacc * engine;
		
	/**
	 * See if the passed QHACC_HOME string is acceptable. If it is,
	 * return appropriate values for feeding directly into generate()
	 */
	virtual bool homeok( const QString& home, uint& jid,
											 auto_ptr<QHaccResultSet>& accts, 
											 QDate& start, QDate& stop, QString& err );

	/**
	 * Create a title for the report
	 */
	QString titler( QHaccResultSet * accts, uint jid=0,
									QDate start =QDate(), QDate stop =QDate() );

	/**
	 * Generate a set of transactions for the given accounts, dates, and journal
	 * @param jid The JournalID
	 * @param accounts A table of accounts to include
	 * @param start The start date
	 * @param stop The stop date
	 * @return A ResultSet of transactions that come with the specified dates,
	 * for the specified accounts, and in the specified journal, in XTRANS format
	 */
	auto_ptr<QHaccResultSet> gentrans( QHaccResultSet * accounts, uint jid,
																		 const QDate& start, const QDate& stop );

	/**
	 * Generate a set of transactions for the given criteria
	 * @param accounts The accounts to select transactions from
	 * @param selectors The criteria to add to calls to engine->getXTForA()
	 * @return A ResultSet of transactions that come within the criteria range.
	 * These transactions will be in XTRANS format.
	 */
	auto_ptr<QHaccResultSet> gentrans( QHaccResultSet * accounts, 
																		 vector<TableSelect> selectors );
	
};



/********************/
/****Plugin Info*****/
/********************/

class ReportInfo : public PluginInfo {
 public:
	ReportInfo();
};

class AccountsInfo : public ReportInfo {
 public:
	AccountsInfo();
};

class AvesInfo : public ReportInfo {
 public:
	AvesInfo();
};

class BudgetInfo : public ReportInfo {
 public:
	BudgetInfo();
};

class BalancesInfo : public ReportInfo {
 public:
	BalancesInfo();
};

class DeltasInfo : public ReportInfo {
 public:
	DeltasInfo();
};

class JournalInfo : public ReportInfo {
 public:
	JournalInfo();
};

class ProfitLossInfo : public ReportInfo {
 public:
	ProfitLossInfo();
};

class MonthlyBudgetInfo : public ReportInfo {
 public:
	MonthlyBudgetInfo();
};

class PayeeInfo : public ReportInfo {
 public:
	PayeeInfo();
};

class TransBalInfo : public ReportInfo {
 public:
	TransBalInfo();
};

class TransInfo : public ReportInfo {
 public:
	TransInfo();
};

class SharesInfo : public ReportInfo {
 public:
	SharesInfo();
};

#endif
