/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "sharesreport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"
#include "qhacclineedits.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new SharesReport; }
	void destroy( SharesReport * p ){ delete p; }
}

SharesReport::SharesReport(){}
SharesReport::~SharesReport(){}

auto_ptr<QHaccResultSet> SharesReport::generate( uint jid,
																								 QHaccResultSet * accts,
																								 const QDate& start,
																								 const QDate&  end,
																								 QString& title ){
	// figure out the title and the affected transactions
	title=titler( accts, jid, start, end );
	return igen( gentrans( accts, jid, start, end ) );
}

auto_ptr<QHaccResultSet> SharesReport::generate( QHaccResultSet * accts,
																								 vector<TableSelect> ss,
																								 QString& title ){
	title=titler( accts );
	return igen( gentrans( accts, ss ) );
}

auto_ptr<QHaccResultSet> SharesReport::igen( auto_ptr<QHaccResultSet>
																						 data ) const {

	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 5 ) );

	//const MonCon& conv=engine->converter();
	const QString sep=engine->getSP( "DATESEPARATOR" );
	//const int fmt=engine->getIP( "DATEFORMAT" );
	float current=0;

	QHaccTableIndex index( data.get(), QC::XTDATE, CTDATE, QC::XSID, CTUINT );
	const uint RWS=data->rows();

	// we expect this report to be run on accounts that have lots of market
	// transactions, so we'll go ahead and assume every trans is a market one
	ret->startLoad( RWS ); 

	for( uint i=0; i<RWS; i++ ){
		Transaction xtrans=data->at( i );
		Transaction trans;
		Split split;
		
		engine->splitXTrans( xtrans, trans, split );
		//int isum=conv.converti( xtrans[QC::XSSUM].gets(), Engine, Preference );

		QString price, shares;
		if( Utils::isMarket( split, &shares, &price ) ){
			TableRow datapoint( 5 );
			current+=shares.toFloat();

			datapoint.set( 0, trans[QC::TPAYEE] );
			if( shares.toFloat()<0 ){
				datapoint.set( 1, "SELL" );
				datapoint.set( 2, shares.mid( 1 ) );
			}
			else{
				datapoint.set( 1, "BUY" );
				datapoint.set( 2, shares );
			}

			datapoint.set( 3, price );
			datapoint.set( 4, current );
			
			ret->add( datapoint );
		}
	}

	ret->stopLoad();
	return ret;
}

const SharesInfo SharesReport::pinfo;
const PluginInfo& SharesReport::info() const { return pinfo; }
