/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "transreport.h"
#include "qhacc.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new TransReport; }
	void destroy( TransReport * p ){ delete p; }
}

TransReport::TransReport(){}
TransReport::~TransReport(){}

auto_ptr<QHaccResultSet> TransReport::generate( uint jid,
																								QHaccResultSet * accts,
																								const QDate& start,
																								const QDate&  end,
																								QString& title ){
	title=titler( accts, jid, start, end );
	return igen( gentrans( accts, jid, start, end ) );
}

auto_ptr<QHaccResultSet> TransReport::generate( QHaccResultSet * accts,
																								vector<TableSelect> ss,
																								QString& title ){
	title=titler( accts );
	return igen( gentrans( accts, ss ) );
}

auto_ptr<QHaccResultSet> TransReport::igen( auto_ptr<QHaccResultSet> data ){
	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 1 ) );
	TableRow line( 1 );

	const int nfields=7;
	const int fields[]={ QC::XTID, QC::XTLID, QC::XTNUM, QC::XTDATE,
											 QC::XTPAYEE, QC::XTMEMO, QC::XSSUM };
	QHaccTableIndex index( data.get(), QC::XTDATE, CTDATE, QC::XSID, CTUINT );

	uint rr=data->rows();
	ret->startLoad( rr );
	for( uint i=0; i<rr; i++ ){
		const Transaction& row=data->at( index[i] );

		QString str=row[fields[0]].gets();
		for( int i=1; i<nfields; i++ ) str+=":"+row[fields[i]].gets();
		line.set( 0, str );

		ret->add( line );
	}
	ret->stopLoad();

	return ret;
}

QString TransReport::writereport( const QString& title,
																		 const QHaccResultSet * data ){
	QString ret=title;
	if( data->isEmpty() ) ret.append( "\n\tNo Transactions" );
	else{
		for( uint i=0; i<data->rows(); i++ ) ret+="\n"+data->at( i ).gets( 0 );
	}
	return ret;
}

const TransInfo TransReport::pinfo;
const PluginInfo& TransReport::info() const { return pinfo; }
