/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef LFSQLITEPLUGIN_H
#define LFSQLITEPLUGIN_H

#include "sqliteplugin.h"

class QHacc;

class LFSQLiteInfo : public SQLiteInfo {
 public:
	LFSQLiteInfo();
};


/* read and write to SQLite databases stored in files */
class LFSQLiteDBPlugin : public SQLiteDBPlugin {
 public:
	static const LFSQLiteInfo pinfo;

	LFSQLiteDBPlugin();
	virtual ~LFSQLiteDBPlugin();

	const PluginInfo& info() const;

	bool save( QString& error );
	bool load( QString& err );
	bool connect( QHacc *, const QString&, QString& );

	QString create( const QString& ) const;
	static QString screate( const QString& );

	bool dirty() const;
	int run( const QString& stmt );

 protected:
	bool needsave;
	QHacc * engine;
	QString home;
};

#endif
