/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef XMLIMPORTER_H
#define XMLIMPORTER_H

#include "localfileplugin.h"
#include "qhacctablerows.h"

#include <stdlib.h>

#include <qxml.h>
#include <qdom.h>

class XMLInfo : public LocalFileDBInfo {
 public:
	XMLInfo();
};

class XMLDBPlugin : public LocalFileDBPlugin, public QXmlDefaultHandler {
 public:
	static const XMLInfo pinfo;
	XMLDBPlugin();
	virtual ~XMLDBPlugin();

	virtual const PluginInfo& info() const;

	virtual bool save( QString& );

 protected:
	TableRow currow;
	int tableid;
	int rowidx;
	int depth;
	
	static const int TABLED, ROWD, FIELDD;

	bool startElement( const QString&, const QString&, const QString&, 
										 const QXmlAttributes& );
	bool endElement( const QString&, const QString&, const QString& );
	bool characters( const QString& );
	
	bool writeTable( QDomDocument&, QDomElement& parent, Table ) const;

	bool iload( QString& error );
};

/* utility class for compressing/uncompressing stuff*/
class ByteBuffer{
 public:
	static const unsigned int BUFFERSIZE;
	static const unsigned int WINDOWBITS;
	static const unsigned int MAXSIZE;

	ByteBuffer( const ByteBuffer& );
	ByteBuffer( unsigned int initial, unsigned int grow =0 );
	ByteBuffer( const unsigned char * arr =0,
							unsigned int arrsz =0, unsigned int grow =0 );
	ByteBuffer( const QByteArray&, unsigned int grow =0 );
	unsigned char operator[]( unsigned int ) const;
	
	~ByteBuffer();

	void add( unsigned char arr );
	void add( const unsigned char * arr, unsigned int arrsz );
	void add( const QByteArray& );
	unsigned int length();
	const unsigned char * array();

	ByteBuffer * compress( int level, bool& okay, char * emsg );
	ByteBuffer * uncompress( bool& okay, char * emsg );
	
 private:
	void init( const unsigned char * arr, unsigned int arrsz, unsigned int g );
	void grow( unsigned int adds );
	unsigned int capacity;
	unsigned int size;
	unsigned int growby;
	unsigned char * data;
};

#endif
