/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "metadialog.h"
#include "qhacc.h"

#include <qlayout.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

#include "metadialog.moc"

/* * * * * * * * * * * * * * * * * *
 * * * * * METADATA EDITOR * * * * *
 * * * * * * * * * * * * * * * * * */
MetaDialog::MetaDialog( bool tax, bool tvo, QWidget * p, const char * n ) 
	: QDialog( p, n, true ){
  
  resize( 275, 100 );
  setCaption( tr( "Extra Transaction Data" ) );
  
  QGridLayout * layout=new QGridLayout( this, 3, 2 );	
	
	taxbox=new QCheckBox( tr( "This adjustment is taxable" ), this );
	taxbox->setChecked( tax );
	layout->addMultiCellWidget( taxbox, 0, 0, 0, 1 );

	voidbox=new QCheckBox( tr( "This is a void transaction" ), this );
	voidbox->setChecked( tvo );
	layout->addMultiCellWidget( voidbox, 1, 1, 0, 1 );

  QPushButton * but=new QPushButton( tr( "okay" ), this );
  connect( but, SIGNAL( clicked() ), SLOT( accept() ) );
  layout->addMultiCellWidget( but, 2, 2, 0, 0 ); 
  
  but=new QPushButton( tr( "cancel" ), this );
  connect( but, SIGNAL( clicked() ), SLOT( reject() ) );
  layout->addMultiCellWidget( but, 2, 2, 1, 1 ); 
}

MetaDialog::~MetaDialog(){}

bool MetaDialog::isVoid() const { return voidbox->isChecked(); }
bool MetaDialog::isTaxable() const { return taxbox->isChecked(); }


