/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "qhaccacctboxchsr.h"
#include "qhacc.h"
#include "copystore.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccacctdlg.h"
#include "qhaccconstants.h"
#include "pixmaps/account.xpm"
#include "qhaccacctboxchsr.moc"

#include <qpixmap.h>
#include <qheader.h>
#include <qpainter.h>
#include <qpopupmenu.h>

QColor QHaccABViewItem::maincolor;
QColor QHaccABViewItem::altcolor;
auto_ptr<QPixmap> QHaccABViewItem::pixmap;
bool QHaccABViewItem::useanums;

QHaccABViewItem::QHaccABViewItem( QHaccListView * p ) 
	: QHaccListViewItem( p ){
	iinit();
}
QHaccABViewItem::~QHaccABViewItem(){
	iinit();
}

void QHaccABViewItem::isetRow(){
	setPixmap( 0, *pixmap );
	setText( 0, myrow[QC::ANAME].gets() );
}

void QHaccABViewItem::iinit(){
	idcol=QC::AID;
	setDragEnabled( true );
	setDropEnabled( true );
	setRenameEnabled( 0, true );
}

bool QHaccABViewItem::acceptDrop( QMimeSource * e ){
	return QHaccTDrag::canDecode( e );
}

void QHaccABViewItem::dropper( QDropEvent * e ){
	TableRow t;
	QHaccTable s( 0 );
	uint a=0;
	Account acct=row();
	if( QHaccTDrag::decode( e, t, s, a ) ){
		e->accept();
		s.updateWhere( TableSelect( QC::SACCTID, TableCol( a ) ),
									 TableUpdate( QC::SACCTID, acct[QC::AID] ) );
		engine->updateT( t, s );
	}
}

void QHaccABViewItem::setCurr( bool b ){ curr=b; }

void QHaccABViewItem::paintCell( QPainter * p, const QColorGroup& cg, int c, 
																 int w, int aln ){
	QColorGroup _cg( cg );
	_cg.setColor( QColorGroup::Highlight, ( curr ? maincolor : altcolor ) );
	_cg.setColor( QColorGroup::HighlightedText, black );
	p->save();
	if( this==listView()->currentItem() ){
		QFont f=p->font();
		f.setBold( true );
		p->setFont( f );		
	}
	QHaccListViewItem::paintCell( p, _cg, c, w, aln );
	p->restore();
}

void QHaccABViewItem::paintBranches( QPainter * p, const QColorGroup& cg,
																		int w, int y, int h ){
	QColorGroup mycg( cg );
	mycg.setColor( QColorGroup::Base, ( isSelected() ? maincolor : altcolor ) );
	QHaccListViewItem::paintBranches( p, mycg, w, y, h );
}

void QHaccABViewItem::resetE( QHacc * e ){
	QHaccListViewItem::resetE( e );
	maincolor=engine->getCP( "MAINCOLOR" );
	altcolor=engine->getCP( "ALTCOLOR" );
	pixmap.reset( new QPixmap( account ) );
	useanums=engine->getBP( "USEANUMSFORNAMES" );
}








QHaccAccountBoxChooser::QHaccAccountBoxChooser( QHacc * eng, QWidget * p,
																								const char * c )
	: QHaccListView( eng, p, c ){

	lasti=0;
	QHaccABViewItem::resetE( engine );
	addColumn( tr( "Account" ) );
	QHeader * head=header();
	head->hide();
	head->setStretchEnabled( true, -1 );
  
	connect( this, SIGNAL( clicked( QListViewItem * ) ),
					 this, SLOT( selchange( QListViewItem * ) ) );
	connect( this, SIGNAL( spacePressed( QListViewItem * ) ),
					 this, SLOT( selchange( QListViewItem * ) ) );
#if QT_VERSION>=320
	connect( this, SIGNAL( doubleClicked( QListViewItem *, const QPoint&,
																				int ) ),
					 this, SLOT( editAcct( QListViewItem *, const QPoint&, int ) ) );
#endif
	connect( this, SIGNAL( itemRenamed( QListViewItem *, int, const QString& ) ),
					 this, SLOT( renamer( QListViewItem *, int, const QString& ) ) );


  QPopupMenu * popup=new QPopupMenu( this );
  popup->insertItem( tr( "reconcile" ), this, SLOT( recoAcct() ) );
  popup->insertItem( tr( "graph" ), this, SLOT( chart() ) );
  popup->insertItem( tr( "report" ), this, SLOT( report() ) );

  popup->insertItem( tr( "edit" ), this, SLOT( editAcct() ) );
  //popup->insertItem( tr( "new" ), this, SLOT( newAcct() ) );
  popup->insertItem( tr( "remove from list" ), this, SLOT( remAcct() ) );
	
  popup->insertSeparator();
  popup->insertItem( tr( "view su&bset" ), this,
										 SLOT( viewSubset() ) );

	setPopup( popup );
	setSorting( -1, true );
	setSelectionMode( Single );
	setAcceptDrops( true );
	viewport()->setAcceptDrops( true );
}

QHaccAccountBoxChooser::~QHaccAccountBoxChooser(){}

void QHaccAccountBoxChooser::save() const {}

void QHaccAccountBoxChooser::readPrefs( bool initial ){
	color=engine->getCP( "ALTCOLOR" );
	QHaccABViewItem::resetE( engine );

	if( initial ){
		connect( engine, SIGNAL( changedP( const QString&, QColor ) ),
						 SLOT( changeP( const QString&, QColor ) ) );
		connect( engine, SIGNAL( removedA( const Account& ) ),
						 SLOT( remAcct( const Account& ) ) );
		connect( engine, SIGNAL( updatedA( const Account&, const Account& ) ),
						 SLOT( updA( const Account&, const Account& ) ) );
	}
}

void QHaccAccountBoxChooser::startDrag(){
	Account a=getMoused();

	if( !a.isNull() ){
		QHaccADrag * dragger=new QHaccADrag( a, this );
		dragger->drag();
	}
}

void QHaccAccountBoxChooser::contentsDragEnterEvent( QDragEnterEvent * e ){
	if( QHaccADrag::canDecode( e ) || QHaccTDrag::canDecode( e ) ) e->accept();
}

void QHaccAccountBoxChooser::contentsDropEvent( QDropEvent * e ){
	Account a;
	// what item did we drop on?
	QHaccABViewItem * droploc=( QHaccABViewItem * )itemAt( contentsToViewport( e->pos() ) );
	
	if( QHaccADrag::decode( e, a ) ){
		if( e->source()==this ){
			QHaccListViewItem * dragger=findRowItem( a[QC::AID].getu() );			
			if( droploc && droploc!=dragger ) dragger->moveItem( droploc );
			emit acctOrderChanged();
		}
		else addAccount( a );
	}
	else if( droploc ) droploc->dropper( e );
}

void QHaccAccountBoxChooser::paintEmptyArea( QPainter * p, const QRect& rect ){
	p->fillRect( rect, color );
}

void QHaccAccountBoxChooser::selchange( QListViewItem * i ){
	if( !i ) return;
	if( lasti ){
		lasti->setCurr( false );
		repaintItem( lasti );
	}

	lasti=( QHaccABViewItem * )i;
	lasti->setCurr( true );
	repaintItem( lasti );
	setSelected( i, true );
	emit changedAccount( getRow( i ) );
}


void QHaccAccountBoxChooser::editAcct( QListViewItem * i, const QPoint&, int ){
	( new AccountDlg( engine, getRow( i ), this ) )->show();
}

void QHaccAccountBoxChooser::editAcct(){
	Account acct=getMoused();
  if( !acct.isNull() )( new AccountDlg( engine, acct, this ) )->show();
}

void QHaccAccountBoxChooser::recoAcct(){ emit needRecWinOf( getMoused() ); }
void QHaccAccountBoxChooser::viewSubset(){	emit needSubsetOf( getMoused() ); }
void QHaccAccountBoxChooser::chart(){ emit needGraphOf( getMoused() ); }
void QHaccAccountBoxChooser::report(){ emit needReportOf( getMoused() ); }

void QHaccAccountBoxChooser::changeP( const QString& p, QColor c ){
	if( p=="ALTCOLOR" ) color=c;
	QHaccABViewItem::resetE( engine );
	triggerUpdate();
}

void QHaccAccountBoxChooser::remAcct(){	remAcct( getMoused() ); }
void QHaccAccountBoxChooser::updA( const Account&, const Account& newer ){
	QHaccListViewItem * avi=findRowItem( newer[QC::AID].getu() );
	if( avi ) avi->setRow( newer );
}

void QHaccAccountBoxChooser::remAcct( const Account& a ){
	if( a.isNull() ) return;
	QHaccListViewItem * avi=findRowItem( a[QC::AID].getu() );
	if( avi ){
		unregisterItem( a[QC::AID].getu() );
		delete avi;
	}
}

void QHaccAccountBoxChooser::setAccount( const Account& a ){
	bool skipfind=a.isNull();
	QHaccListViewItem * avi=0;

	if( !skipfind ) avi=findRowItem( a[QC::AID].getu() );
	if( avi )	{
		// don't emit a signal here because someone else told us to select this
		blockSignals( true );
		selchange( avi );
		blockSignals( false );
	}
	else if( lasti ){
		lasti->setCurr( false );
		repaintItem( lasti );
		lasti=0;
	}
}

void QHaccAccountBoxChooser::addAccount( const Account& a ){
	QHaccABViewItem * abvi=new QHaccABViewItem( this );
	abvi->setRow( a );
}

void QHaccAccountBoxChooser::renamer( QListViewItem * i, int,
																			const QString& s ){
	Account a=getRow( i );
	a.set( QC::ANAME, s );
	engine->updateA( a, a );
}
