/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#ifndef _QHACCGRWIN_H
#define _QHACCGRWIN_H

#include "qhacctablerows.h"

#include <memory>
using namespace std;

#include <qframe.h>
#include <qlistbox.h>
#include <qdatetime.h>
#include <qstringlist.h>

#include <qdialog.h>

class QLabel;
class QPrinter;
class QPainter;
class QTextEdit;
class QComboBox;
class QGridLayout;

class QHacc;
class QHaccTable;
class QHaccDateEdit;
class QHaccGraphPlugin;
class QHaccReportPlugin;

/***********************/
/**  GRAPHDOCCONTROL  **/
/***********************/

class QHaccDocControl : public QFrame {
	Q_OBJECT
		public:
	QHaccDocControl( QHacc *, uint lid, QWidget * =0, const char * =0 );
	~QHaccDocControl();
  
	void readPrefs( bool );
	
  void setTypes( QStringList, int =0 );
  void setPicks( QStringList, int =0 );
	void setPickMode( QListBox::SelectionMode );
	
 private:
	QHacc * engine;
  QHaccDateEdit * start, * end;
	QComboBox * typer, * journaler;
	QListBox * pick;
	QLabel * llbl;

  public slots:
		void newValues();
	void newType( int );
	void getPrefs();
  void changeP( const QString&, float );
  void changeP( const QString&, QString );
	void changeP( const QString&, bool );
	void print();
	void setEnv( QDate, QDate, bool, bool );

 signals:
  void dataChanged( uint journalid, QStringList, QDate, QDate );
	void typeChanged( int );
	void printCalled();
};


/**********************************/
/**  QHACCREPORTER/GRAPHER BASE  **/
/**********************************/
class QHaccDocDisplay : public QFrame {
	Q_OBJECT
		public:
	QHaccDocDisplay( QHacc *, QWidget * =0, const char * =0 );
	virtual ~QHaccDocDisplay();

	void readPrefs( bool );
	void setData( uint lid, const QHaccTable&, const QDate&, const QDate& );
	void setType( int );
	void print( QPrinter * ) const;

 protected:
	virtual void isetType();
	virtual void irefresh();
	virtual void iprint( QPrinter * ) const;
	void refreshA( const Account& );

	int type;
	uint journalid;
	QHacc * engine;
	QDate start, end;
	QHaccTable * accounts;

	public slots:
		void refresh();
	void updA( const Account&, const Account& );

 signals:
	void selected( QDate, QDate, bool, bool );
};

/*********************/
/**  QHACCREPORTER  **/
/*********************/

class QHaccReporter : public QHaccDocDisplay {
  Q_OBJECT
    public:

  QHaccReporter( QHacc *, QWidget * =0, const char * =0 );
	void isetType();
  virtual ~QHaccReporter();

 protected:
	QTextEdit * viewer;
	QHaccReportPlugin * plugin;

	void irefresh();
	void iprint( QPrinter * ) const;
};


/********************/
/**  QHACCGRAPHER  **/
/********************/

// first, a base class for the grapher and reporter
class QHaccGrapher : public QHaccDocDisplay {
  Q_OBJECT
    public:
  QHaccGrapher( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccGrapher();
	void setData( uint lid, const QHaccTable&, const QDate&, const QDate& );
	void mouseReleaseEvent( QMouseEvent * );

 protected:
	QHaccGraphPlugin * plugin;

	void isetType();
	void irefresh();
	void iprint( QPrinter * ) const;
  void drawContents( QPainter * );

};

/*********************/
/**  QHACCGRDIALOG  **/
/*********************/

//class QHaccGRDialog : public KDialogBase {
class QHaccGRDialog : public QDialog {
  Q_OBJECT
    public:

	enum DisplayType { GRAPH, REPORT };
  QHaccGRDialog( QHacc *, DisplayType, const TableRow&, const TableRow&, 
								 QWidget * =0, const char * =0 );
  virtual ~QHaccGRDialog();

	void save();
	void readPrefs( bool );

	void done( int );

 protected:
	QHacc * engine;
  QHaccDocControl * control;
	QHaccDocDisplay * display;
	QPrinter * printer;

  public slots:
		void changeData( uint lid, QStringList, QDate, QDate );
	void changeType( int );
	void print();
};


#endif
