/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCLEDCHOOSER_H
#define _QHACCLEDCHOOSER_H

#include "qhacctablerows.h"

#include <qtabbar.h>

class QHacc;

class QHaccJournalChooser : public QTabBar {
  Q_OBJECT
    public:
  QHaccJournalChooser( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccJournalChooser();

	void save() const;
	void readPrefs( bool );
	Journal getSelected() const;

	void dragEnterEvent( QDragEnterEvent * );
	void dropEvent( QDropEvent * );

 private:
	QHacc * engine;
	int * ids; // a list of tab ids

	QTab * getLTab( const Journal& ) const;

	protected slots:
		void changeJournal( int );
	void addL( const Journal& );
	void remL( const Journal& );
	void updL( const Journal&, const Journal& );

 signals:
  void changedJournal( const Journal& );
};

#endif


