/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _SPLITDLG_H
#define _SPLITDLG_H

//#include <qlist.h>
#include <qdialog.h>
#include <qscrollview.h>

#include <list>
using namespace std;

class QHaccLineEdit;
class QHaccDateEdit;
class QHaccChoiceEdit;
class SplitEditorFrame;
class AccountAreaFrame;
class QHaccResultSet;
class QHaccTable;
class TableRow;
class QHacc;

class QHeader;


class SplitEditor : public QDialog {
  Q_OBJECT
    public:
  SplitEditor( QHacc *, QHaccTable&, QWidget * =0, const char * =0 );
  ~SplitEditor();
  
  QHaccTable getSplits() const;
  void setSplits( QHaccTable& );
  
 private:
  AccountAreaFrame * cont;
};

class AccountArea : public QScrollView {
  Q_OBJECT
    public:
  static const int NAME, PID, ID, NUM, COLS;
  static const int GRABCOLS[];

  AccountArea( QHacc *, QHaccTable&, QWidget * =0, const char * =0 );
  ~AccountArea();
  
  QHaccTable getSplits();
  
  public slots:
    QHaccChoiceEdit * addSplit( const TableRow& );
  void clearSplits();
  
 protected:
  int lineSize() const;
  uint getNumSplits() const;
  list<QHaccChoiceEdit *> accounts;
  list<QHaccLineEdit *> credits;
  list<QHaccLineEdit *> debits;
  QHacc * engine;
  QHeader * header;
  QHaccTable * accts;
};

class AccountAreaFrame : public QFrame {
  Q_OBJECT
    public:
  AccountAreaFrame( QHacc *, QHaccTable&, QWidget * =0, const char * =0 );
  ~AccountAreaFrame();
  
  QHaccTable getSplits();
  void addSplit( const TableRow& );
  void clearSplits();
  static bool verifyOrMakeA( QHacc *, const QString& aname, TableRow& acct );
  static QString displayAName( QHacc *, const TableRow&, bool useanums );
  
 protected:
  AccountArea * area;
  
  private slots:
    void adder();
};

#endif
