/* 
 *  gretl -- Gnu Regression, Econometrics and Time-series Library
 *  Copyright (C) 2001 Allin Cottrell and Riccardo "Jack" Lucchetti
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GPT_CONTROL_H
#define GPT_CONTROL_H

#include "plotspec.h"

typedef struct png_plot_t png_plot;

int remove_png_term_from_plotfile_by_name (const char *fname);

void display_session_graph_png (const char *pltname);

void gnuplot_show_png_by_name (const char *fname);

void plot_label_position_click (GtkWidget *w, png_plot *plot);

int redisplay_edited_plot (png_plot *plot);

void plot_remove_controller (png_plot *plot);

void set_plot_has_y2_axis (png_plot *plot, gboolean s);

int plot_is_mouseable (const png_plot *plot);

GtkWidget *plot_get_shell (png_plot *plot);

GPT_SPEC *plot_get_spec (png_plot *plot);

void revise_distribution_plotspec (png_plot *plot, int d, int df1, int df2);

int gp_term_code (gpointer p);

void save_graph_to_file (gpointer p, const char *fname);

void filter_gnuplot_file (int ttype, int latin, int mono, int recolor, 
			  FILE *fpin, FILE *fpout);

void gp_send_callback (GtkWidget *w, gpointer data);

int dump_plot_buffer (const char *buf, const char *fname,
		      int addpause);

#endif /* GPT_CONTROL_H */
