#ifndef BINUTILS_BITMAP_H
#define BINUTILS_BITMAP_H
/*
  Steganography by the LSB here.Message Limited to 65,536 bytes only.
  First get the length of the pixel size.Then compare to the message size.
  8*len(message)+ 16 <= pixelsize
  The two bytes are for storing the number of bytes to be read.
  Detail:
     each byte of intformation is stored in the LSB of each byte.
     so one byte takes 8 bytes to be stored.Two bytes for the messagelength.
     Hence the formula.
  The way we do it:
     The whole message is written into the pixels from the reverse message,
     and after that we write the image in a byte swapped order.
     eg: if we write it as "GNU.bmp" the letters get encoded in the order
     'p','m','b','.','U','N','G'.Then their values are stored in the order
     'p'= 0x70 is stored as 0000 0111b in the image.
 */

/*
  GNU.bmp
  size: w:299  h:362
  depth:24
 */

#include"../config.h"
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>


typedef struct 
{
  unsigned char BMP[2]; //2 bytes
  unsigned int filesize;//4  "
  unsigned char Junk1[6*2];// 12
  unsigned int width;// 4 
  unsigned int height;// 4               [totally 2+4+12+4+4 over]
  unsigned short int bitplanes;//2 bytes
  unsigned short int colordepth;//2 "
  unsigned char Junk2[2*2];//4 bytes
  unsigned int pixelsize;//2 
  unsigned char Junk3[2*9];//18 
}bmpheader; //cant use this from read...! bhoo... ;-....

typedef struct
{
  unsigned  char blue;
  unsigned  char green;
  unsigned  char red;
}pixel;


void bmp_read_header(FILE *fp,bmpheader* bmph);
void bmp_info_header(bmpheader bmph);
void  bmp_info_pixel(pixel sample);
int message_size(char *message);

int encode_message_to_file(FILE *fdest, FILE *fsrc,char *message);
int decode_message_to_file(FILE *fdest, FILE *fsrc,char *message,int length);
int file_copy(FILE *fdest,FILE *fsrc,int offset);
#endif /* BINUTILS_BITMAP_H */
